/*
 * Decompiled with CFR 0.152.
 */
package kr.motd.maven.sphinx;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kr.motd.maven.sphinx.SphinxException;
import kr.motd.maven.sphinx.SphinxRunner;
import kr.motd.maven.sphinx.SphinxRunnerLogger;
import kr.motd.maven.sphinx.SphinxUtil;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;

@Mojo(name="generate", defaultPhase=LifecyclePhase.SITE, requiresReports=true)
public class SphinxMojo
extends AbstractMojo
implements MavenReport {
    @Parameter(property="sphinx.asReport", defaultValue="false", alias="asReport")
    private boolean asReport;
    @Parameter(property="sphinx.name", defaultValue="Sphinx-Docs", alias="name")
    private String name;
    @Parameter(property="sphinx.description", defaultValue="Documentation using Python Sphinx Package", alias="description")
    private String description;
    private static final String sphinxSiteSubDirectory = "sphinx";
    private static final String[] CRUFTS = new String[]{"css/maven-base.css", "css/maven-theme.css", "css/print.css", "css/site.css", "css", "images/logos/build-by-maven-black.png", "images/logos/build-by-maven-white.png", "images/logos/maven-feather.png", "images/logos", "images/collapsed.gif", "images/expanded.gif", "images/external.png", "images/icon_error_sml.gif", "images/icon_info_sml.gif", "images/icon_success_sml.gif", "images/icon_warning_sml.gif", "images/newwindow.png", "images"};
    @Parameter(property="sphinx.srcDir", defaultValue="${basedir}/src/site/sphinx", required=true)
    private File sourceDirectory;
    @Parameter(defaultValue="${project.reporting.outputDirectory}", required=true, readonly=true)
    private File outputDirectory;
    @Parameter(property="sphinx.binBaseUrl", defaultValue="https://github.com/trustin/sphinx-binary/releases/download/", required=true, readonly=true)
    private String binaryBaseUrl;
    @Parameter(property="sphinx.binVersion", defaultValue="v0.1.1", required=true, readonly=true)
    private String binaryVersion;
    @Parameter(property="sphinx.binCacheDir", defaultValue="${settings.localRepository}/kr/motd/maven/sphinx-binary", required=true, readonly=true)
    private File binaryCacheDir;
    @Parameter(property="sphinx.builder", required=true, alias="builder", defaultValue="html")
    private String builder;
    @Parameter(property="sphinx.tags", alias="tags")
    private List<String> tags;
    @Parameter(property="sphinx.verbose", defaultValue="true", required=true, alias="verbose")
    private boolean verbose;
    @Parameter(property="sphinx.warningAsErrors", defaultValue="false", required=true, alias="warningAsErrors")
    private boolean warningsAsErrors;
    @Parameter(property="sphinx.force", defaultValue="false", required=true, alias="force")
    private boolean force;
    @Parameter(property="sphinx.skip", defaultValue="false", required=true, alias="skip")
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Sphinx execution.");
            return;
        }
        this.sourceDirectory = SphinxMojo.canonicalize(this.sourceDirectory);
        this.outputDirectory = SphinxMojo.canonicalize(this.outputDirectory);
        this.binaryCacheDir = SphinxMojo.canonicalize(this.binaryCacheDir);
        if (this.isHtmlReport()) {
            new File(this.sourceDirectory.getPath() + "/index.rst").setLastModified(System.currentTimeMillis());
        }
        try {
            SphinxRunner sphinxRunner = new SphinxRunner(this.binaryBaseUrl, this.binaryVersion, this.binaryCacheDir, new SphinxRunnerLogger(){

                @Override
                public void log(String msg) {
                    SphinxMojo.this.getLog().info((CharSequence)msg);
                }
            });
            this.getLog().info((CharSequence)("Running Sphinx; output will be placed in " + this.outputDirectory));
            List<String> args = this.getSphinxRunnerCmdLine();
            if (sphinxRunner.run(this.sourceDirectory, args) != 0) {
                throw new MavenReportException("Sphinx report generation failed");
            }
            SphinxUtil.convertLineSeparators(this.outputDirectory);
            if (!this.asReport) {
                this.deleteCruft();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to run the report", e);
        }
    }

    private static File canonicalize(File directory) throws MojoExecutionException {
        if (directory == null) {
            return null;
        }
        try {
            directory.mkdirs();
            return directory.getCanonicalFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("failed to create a directory: " + directory, (Exception)e);
        }
    }

    private void deleteCruft() {
        final File outputDirectory = this.outputDirectory;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (String c : CRUFTS) {
                    new File(outputDirectory, c.replace('/', File.separatorChar)).delete();
                }
            }
        });
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        try {
            this.execute();
        }
        catch (SphinxException e) {
            MavenReportException cause = new MavenReportException(e.getMessage());
            if (e.getCause() != null) {
                cause.initCause(e.getCause());
            }
            throw cause;
        }
        catch (Exception e) {
            throw new MavenReportException("Error generating a Sphinx report:", e);
        }
    }

    private boolean isHtmlReport() {
        return this.asReport && "html".equals(this.builder);
    }

    public String getOutputName() {
        if (this.isHtmlReport()) {
            return "sphinx/index";
        }
        return "Python-Sphinx";
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getName(Locale locale) {
        return this.name;
    }

    public String getDescription(Locale locale) {
        return this.description;
    }

    public void setReportOutputDirectory(File outputDirectory) {
        this.outputDirectory = this.asReport ? new File(outputDirectory.getPath() + '/' + sphinxSiteSubDirectory) : outputDirectory;
    }

    public File getReportOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        return true;
    }

    private List<String> getSphinxRunnerCmdLine() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.verbose) {
            args.add("-v");
        } else {
            args.add("-Q");
        }
        if (this.warningsAsErrors) {
            args.add("-W");
        }
        if (this.force) {
            args.add("-a");
            args.add("-E");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            for (String tag : this.tags) {
                args.add("-t");
                args.add(tag);
            }
        }
        args.add("-n");
        args.add("-b");
        args.add(this.builder);
        args.add(this.sourceDirectory.getPath());
        args.add(this.outputDirectory.getPath());
        return args;
    }
}

