/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.elasticsearch;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kr.jm.utils.JMString;
import kr.jm.utils.elasticsearch.JMElasticsearchBulk;
import kr.jm.utils.elasticsearch.JMElasticsearchDelete;
import kr.jm.utils.elasticsearch.JMElasticsearchIndex;
import kr.jm.utils.elasticsearch.JMElasticsearchSearchAndCount;
import kr.jm.utils.elasticsearch.JMElasticsearchUtil;
import kr.jm.utils.enums.OS;
import kr.jm.utils.exception.JMException;
import kr.jm.utils.helper.JMLog;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequestBuilder;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequestBuilder;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMElasticsearchClient
extends PreBuiltTransportClient {
    private static final Logger log = LoggerFactory.getLogger(JMElasticsearchClient.class);
    private static final String NODE_NAME = "node.name";
    private static final String CLIENT_TRANSPORT_IGNORE_CLUSTER_NAME = "client.transport.ignore_cluster_name";
    private static final String CLUSTER_NAME = "cluster.name";
    private static final String CLIENT_TRANSPORT_SNIFF = "client.transport.sniff";
    private final Settings settings;
    private final JMElasticsearchBulk jmESBulk;
    private final JMElasticsearchIndex jmESIndex;
    private final JMElasticsearchSearchAndCount jmESSearchAndCount;
    private final JMElasticsearchDelete jmESDelete;

    public JMElasticsearchClient() {
        this(JMString.buildIpOrHostnamePortPair((String)OS.getHostname(), (int)9300));
    }

    public JMElasticsearchClient(String elasticsearchConnect) {
        this(elasticsearchConnect, OS.getHostname());
    }

    public JMElasticsearchClient(String elasticsearchConnect, boolean clientTransportSniff) {
        this(elasticsearchConnect, OS.getHostname(), clientTransportSniff);
    }

    public JMElasticsearchClient(String elasticsearchConnect, boolean clientTransportSniff, String clusterName) {
        this(elasticsearchConnect, OS.getHostname(), clientTransportSniff, clusterName);
    }

    public JMElasticsearchClient(String elasticsearchConnect, String nodeName) {
        this(elasticsearchConnect, nodeName, true);
    }

    public JMElasticsearchClient(String elasticsearchConnect, String nodeName, boolean clientTransportSniff) {
        this(elasticsearchConnect, nodeName, clientTransportSniff, null);
    }

    public JMElasticsearchClient(String elasticsearchConnect, String nodeName, boolean clientTransportSniff, String clusterName) {
        this(elasticsearchConnect, JMElasticsearchClient.getSettingsBuilder(nodeName, clientTransportSniff, clusterName).build());
    }

    public JMElasticsearchClient(String elasticsearchConnect, Settings settings) {
        super(settings, new Class[0]);
        this.settings = settings;
        try {
            for (String ipPort : elasticsearchConnect.split(",")) {
                String[] separatedIpPort = ipPort.split(":");
                this.addTransportAddress(new TransportAddress(InetAddress.getByName(separatedIpPort[0]), Integer.parseInt(separatedIpPort[1])));
            }
        }
        catch (Exception e) {
            JMException.handleExceptionAndThrowRuntimeEx((Logger)log, (Throwable)e, (String)"JMElasticsearchClient", (Object[])new Object[]{elasticsearchConnect, settings});
        }
        JMLog.info((Logger)log, (String)"initElasticsearchClient", (Object[])new Object[]{elasticsearchConnect, settings});
        this.jmESBulk = new JMElasticsearchBulk(this);
        this.jmESIndex = new JMElasticsearchIndex((Client)this);
        this.jmESSearchAndCount = new JMElasticsearchSearchAndCount((Client)this);
        this.jmESDelete = new JMElasticsearchDelete((Client)this);
    }

    public static Settings.Builder getSettingsBuilder(String nodeName, boolean clientTransportSniff, String clusterName) {
        boolean isNullClusterName = Objects.isNull(clusterName);
        Settings.Builder builder = Settings.builder().put(NODE_NAME, nodeName).put(CLIENT_TRANSPORT_SNIFF, clientTransportSniff).put(CLIENT_TRANSPORT_IGNORE_CLUSTER_NAME, isNullClusterName);
        if (!isNullClusterName) {
            builder.put(CLUSTER_NAME, clusterName);
        }
        return builder;
    }

    public boolean isExists(String index) {
        IndicesExistsRequestBuilder indicesExistsRequestBuilder = this.admin().indices().prepareExists(new String[]{index});
        return ((IndicesExistsResponse)JMElasticsearchUtil.logRequestQueryAndReturn("isExists", indicesExistsRequestBuilder, indicesExistsRequestBuilder.execute())).isExists();
    }

    public boolean create(String index) {
        CreateIndexRequestBuilder createIndexRequestBuilder = this.admin().indices().prepareCreate(index);
        return ((CreateIndexResponse)JMElasticsearchUtil.logRequestQueryAndReturn("create", createIndexRequestBuilder, createIndexRequestBuilder.execute())).isAcknowledged();
    }

    public List<String> extractIdList(SearchResponse searchResponse) {
        return Arrays.stream(searchResponse.getHits().getHits()).map(SearchHit::getId).collect(Collectors.toList());
    }

    public List<String> getAllIdList(String index) {
        return this.extractIdList(this.searchAll(index));
    }

    public List<String> extractIdList(String index, QueryBuilder filterQueryBuilder) {
        return this.extractIdList(this.searchAllWithTargetCount(index, filterQueryBuilder));
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetadata>> getMappingsResponse(String ... indices) {
        GetMappingsRequestBuilder getMappingsRequestBuilder = this.admin().indices().prepareGetMappings(indices);
        return ((GetMappingsResponse)JMElasticsearchUtil.logRequestQueryAndReturn("getMappingsResponse", getMappingsRequestBuilder, getMappingsRequestBuilder.execute())).getMappings();
    }

    public Map<String, IndexStats> getAllIndicesStats() {
        IndicesStatsRequestBuilder indicesStatsRequestBuilder = this.admin().indices().prepareStats(new String[0]).all();
        return ((IndicesStatsResponse)JMElasticsearchUtil.logRequestQueryAndReturn("getAllIndicesStats", indicesStatsRequestBuilder, indicesStatsRequestBuilder.execute())).getIndices();
    }

    public Set<String> getAllIndices() {
        return this.getAllIndicesStats().keySet();
    }

    public List<String> getFilteredIndexList(String containedString) {
        return this.getAllIndices().stream().filter(index -> index.contains(containedString)).collect(Collectors.toList());
    }

    public GetResponse getQuery(GetRequestBuilder getRequestBuilder) {
        return (GetResponse)JMElasticsearchUtil.logRequestQueryAndReturn("getQuery", getRequestBuilder, getRequestBuilder.execute());
    }

    public UpdateResponse updateQuery(UpdateRequestBuilder updateRequestBuilder) {
        return (UpdateResponse)JMElasticsearchUtil.logRequestQueryAndReturn("updateQuery", updateRequestBuilder, updateRequestBuilder.execute());
    }

    public Optional<Map<String, Object>> getMappings(String index) {
        try {
            return Optional.of(((MappingMetadata)((ImmutableOpenMap)this.getMappingsResponse(index).get((Object)index)).get((Object)"_doc")).getSourceAsMap());
        }
        catch (Exception e) {
            return JMException.handleExceptionAndReturnEmptyOptional((Logger)log, (Throwable)e, (String)"getMappings", (Object[])new Object[]{index});
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setBulkProcessor(int bulkActions, long bulkSizeKB, int flushIntervalSeconds) {
        this.jmESBulk.setBulkProcessor(bulkActions, bulkSizeKB, flushIntervalSeconds);
    }

    public void setBulkProcessor(BulkProcessor.Listener bulkProcessorListener, int bulkActions, long bulkSizeKB, int flushIntervalSeconds) {
        this.jmESBulk.setBulkProcessor(bulkProcessorListener, bulkActions, bulkSizeKB, flushIntervalSeconds);
    }

    public BulkProcessor.Builder getBulkProcessorBuilder(BulkProcessor.Listener bulkProcessorListener, Integer bulkActions, ByteSizeValue bulkSize, TimeValue flushInterval, Integer concurrentRequests, BackoffPolicy backoffPolicy) {
        return this.jmESBulk.getBulkProcessorBuilder(bulkProcessorListener, bulkActions, bulkSize, flushInterval, concurrentRequests, backoffPolicy);
    }

    public BulkProcessor buildBulkProcessor(BulkProcessor.Listener bulkProcessorListener, int bulkActions, long bulkSizeKB, int flushIntervalSeconds, Integer concurrentRequests, BackoffPolicy backoffPolicy) {
        return this.jmESBulk.buildBulkProcessor(bulkProcessorListener, bulkActions, bulkSizeKB, flushIntervalSeconds, concurrentRequests, backoffPolicy);
    }

    public BulkProcessor buildBulkProcessor(BulkProcessor.Listener bulkProcessorListener, int bulkActions, long bulkSizeKB, int flushIntervalSeconds) {
        return this.jmESBulk.buildBulkProcessor(bulkProcessorListener, bulkActions, bulkSizeKB, flushIntervalSeconds);
    }

    public void sendWithBulkProcessor(List<? extends Map<String, Object>> bulkSource, String index) {
        this.jmESBulk.sendWithBulkProcessor(bulkSource, index);
    }

    public void sendWithBulkProcessor(Map<String, Object> source, String index) {
        this.jmESBulk.sendWithBulkProcessor(source, index);
    }

    public void sendWithBulkProcessor(Map<String, Object> source, String index, String id) {
        this.jmESBulk.sendWithBulkProcessor(source, index, id);
    }

    public void sendWithBulkProcessorAndObjectMapper(List<Object> bulkObject, String index) {
        this.jmESBulk.sendWithBulkProcessorAndObjectMapper(bulkObject, index);
    }

    public void sendWithBulkProcessorAndObjectMapper(Object object, String index) {
        this.jmESBulk.sendWithBulkProcessorAndObjectMapper(object, index);
    }

    public void sendWithBulkProcessorAndObjectMapper(Object object, String index, String id) {
        this.jmESBulk.sendWithBulkProcessorAndObjectMapper(object, index, id);
    }

    public void sendWithBulkProcessor(List<IndexRequest> indexRequestList) {
        this.jmESBulk.sendWithBulkProcessor(indexRequestList);
    }

    public void sendWithBulkProcessor(IndexRequest indexRequest) {
        this.jmESBulk.sendWithBulkProcessor(indexRequest);
    }

    public void closeBulkProcessor() {
        this.jmESBulk.closeBulkProcessor();
    }

    public void sendBulkDataAsync(List<? extends Map<String, Object>> bulkSourceList, String index) {
        this.jmESBulk.sendBulkDataAsync(bulkSourceList, index);
    }

    public void sendBulkDataAsync(List<? extends Map<String, Object>> bulkSourceList, String index, ActionListener<BulkResponse> bulkResponseActionListener) {
        this.jmESBulk.sendBulkDataAsync(bulkSourceList, index, bulkResponseActionListener);
    }

    public void sendBulkDataWithObjectMapperAsync(List<Object> objectBulkData, String index) {
        this.jmESBulk.sendBulkDataWithObjectMapperAsync(objectBulkData, index);
    }

    public void sendBulkDataWithObjectMapperAsync(List<Object> objectBulkData, String index, ActionListener<BulkResponse> bulkResponseActionListener) {
        this.jmESBulk.sendBulkDataWithObjectMapperAsync(objectBulkData, index, bulkResponseActionListener);
    }

    public BulkRequestBuilder buildBulkIndexRequestBuilder(List<IndexRequestBuilder> indexRequestBuilderList) {
        return this.jmESBulk.buildBulkIndexRequestBuilder(indexRequestBuilderList);
    }

    public BulkRequestBuilder buildDeleteBulkRequestBuilder(List<DeleteRequestBuilder> deleteRequestBuilderList) {
        return this.jmESBulk.buildDeleteBulkRequestBuilder(deleteRequestBuilderList);
    }

    public BulkRequestBuilder buildUpdateBulkRequestBuilder(List<UpdateRequestBuilder> updateRequestBuilderList) {
        return this.jmESBulk.buildUpdateBulkRequestBuilder(updateRequestBuilderList);
    }

    public void executeBulkRequestAsync(BulkRequestBuilder bulkRequestBuilder) {
        this.jmESBulk.executeBulkRequestAsync(bulkRequestBuilder);
    }

    public void executeBulkRequestAsync(BulkRequestBuilder bulkRequestBuilder, ActionListener<BulkResponse> bulkResponseActionListener) {
        this.jmESBulk.executeBulkRequestAsync(bulkRequestBuilder, bulkResponseActionListener);
    }

    public BulkResponse executeBulkRequest(BulkRequestBuilder bulkRequestBuilder) {
        return this.jmESBulk.executeBulkRequest(bulkRequestBuilder);
    }

    public boolean deleteBulkDocs(String index) {
        return this.jmESBulk.deleteBulkDocs(index);
    }

    public BulkResponse deleteBulkDocs(String index, QueryBuilder filterQueryBuilder) {
        return this.jmESBulk.deleteBulkDocs(index, filterQueryBuilder);
    }

    public boolean deleteBulkDocs(List<String> indexList, QueryBuilder filterQueryBuilder) {
        return this.jmESBulk.deleteBulkDocs(indexList, filterQueryBuilder);
    }

    public void deleteBulkDocsAsync(String index) {
        this.jmESBulk.deleteBulkDocsAsync(index);
    }

    public void deleteBulkDocsAsync(String index, ActionListener<BulkResponse> bulkResponseActionListener) {
        this.jmESBulk.deleteBulkDocsAsync(index, bulkResponseActionListener);
    }

    public void deleteBulkDocsAsync(String index, QueryBuilder filterQueryBuilder) {
        this.jmESBulk.deleteBulkDocsAsync(index, filterQueryBuilder);
    }

    public void deleteBulkDocsAsync(String index, QueryBuilder filterQueryBuilder, ActionListener<BulkResponse> bulkResponseActionListener) {
        this.jmESBulk.deleteBulkDocsAsync(index, filterQueryBuilder, bulkResponseActionListener);
    }

    public void deleteBulkDocsAsync(List<String> indexList, QueryBuilder filterQueryBuilder, ActionListener<BulkResponse> bulkResponseActionListener) {
        this.jmESBulk.deleteBulkDocsAsync(indexList, filterQueryBuilder, bulkResponseActionListener);
    }

    public IndexResponse indexQuery(IndexRequestBuilder indexRequestBuilder) {
        return this.jmESIndex.indexQuery(indexRequestBuilder);
    }

    public ActionFuture<IndexResponse> indexQueryAsync(IndexRequestBuilder indexRequestBuilder) {
        return this.jmESIndex.indexQueryAsync(indexRequestBuilder);
    }

    public UpdateResponse upsertQuery(UpdateRequestBuilder updateRequestBuilder) {
        return this.jmESIndex.upsertQuery(updateRequestBuilder);
    }

    public ActionFuture<UpdateResponse> upsertQueryAsync(UpdateRequestBuilder updateRequestBuilder) {
        return this.jmESIndex.upsertQueryAsync(updateRequestBuilder);
    }

    public UpdateResponse upsertData(String index, String id, Map<String, Object> source) {
        return this.jmESIndex.upsertData(index, id, source);
    }

    public ActionFuture<UpdateResponse> upsertDataAsync(String index, String id, Map<String, Object> source) {
        return this.jmESIndex.upsertDataAsync(index, id, source);
    }

    public UpdateResponse upsertData(String index, String id, String jsonSource) {
        return this.jmESIndex.upsertData(index, id, jsonSource);
    }

    public ActionFuture<UpdateResponse> upsertDataAsync(String index, String id, String jsonSource) {
        return this.jmESIndex.upsertDataAsync(index, id, jsonSource);
    }

    public UpdateResponse upsertDataWithObjectMapper(String index, String id, Object sourceObject) {
        return this.jmESIndex.upsertDataWithObjectMapper(index, id, sourceObject);
    }

    public ActionFuture<UpdateResponse> upsertDataASyncWithObjectMapper(String index, String id, Object sourceObject) {
        return this.jmESIndex.upsertDataASyncWithObjectMapper(index, id, sourceObject);
    }

    public IndexResponse sendData(String index, String id, Map<String, Object> source) {
        return this.jmESIndex.sendData(index, id, source);
    }

    public String sendData(String index, Map<String, Object> source) {
        return this.jmESIndex.sendData(index, source);
    }

    public IndexResponse sendData(String index, String id, String jsonSource) {
        return this.jmESIndex.sendData(index, id, jsonSource);
    }

    public String sendData(String index, String jsonSource) {
        return this.jmESIndex.sendData(index, jsonSource);
    }

    public IndexResponse sendDataWithObjectMapper(String index, String id, Object sourceObject) {
        return this.jmESIndex.sendDataWithObjectMapper(index, id, sourceObject);
    }

    public String sendDataWithObjectMapper(String index, Object sourceObject) {
        return this.jmESIndex.sendDataWithObjectMapper(index, sourceObject);
    }

    public ActionFuture<IndexResponse> sendDataAsync(String index, String id, Map<String, Object> source) {
        return this.jmESIndex.sendDataAsync(index, id, source);
    }

    public ActionFuture<IndexResponse> sendDataAsync(String index, Map<String, Object> source) {
        return this.jmESIndex.sendDataAsync(index, source);
    }

    public ActionFuture<IndexResponse> sendDataAsync(String index, String id, String jsonSource) {
        return this.jmESIndex.sendDataAsync(index, id, jsonSource);
    }

    public ActionFuture<IndexResponse> sendDataAsync(String index, String jsonSource) {
        return this.jmESIndex.sendDataAsync(index, jsonSource);
    }

    public ActionFuture<IndexResponse> sendDataAsyncWithObjectMapper(String index, String id, Object sourceObject) {
        return this.jmESIndex.sendDataAsyncWithObjectMapper(index, id, sourceObject);
    }

    public ActionFuture<IndexResponse> sendDataAsyncWithObjectMapper(String index, Object sourceObject) {
        return this.jmESIndex.sendDataAsyncWithObjectMapper(index, sourceObject);
    }

    public SearchResponse searchWithTargetCount(SearchRequestBuilder searchRequestBuilder) {
        return this.jmESSearchAndCount.searchWithTargetCount(searchRequestBuilder);
    }

    public SearchResponse searchWithTargetCount(SearchRequestBuilder searchRequestBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchWithTargetCount(searchRequestBuilder, aggregationBuilders);
    }

    public SearchResponse searchWithTargetCount(boolean isSetExplain, String[] indices, QueryBuilder[] mustConditionQueryBuilders, QueryBuilder[] filterConditionQueryBuilders) {
        return this.jmESSearchAndCount.searchWithTargetCount(isSetExplain, indices, mustConditionQueryBuilders, filterConditionQueryBuilders);
    }

    public SearchResponse searchWithTargetCount(boolean isSetExplain, String[] indices, QueryBuilder[] mustConditionQueryBuilders, QueryBuilder[] filterConditionQueryBuilders, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchWithTargetCount(isSetExplain, indices, mustConditionQueryBuilders, filterConditionQueryBuilders, aggregationBuilders);
    }

    public SearchRequestBuilder getSearchRequestBuilder(QueryBuilder queryBuilder, String ... indices) {
        return this.jmESSearchAndCount.getSearchRequestBuilder(queryBuilder, indices);
    }

    public SearchRequestBuilder getSearchRequestBuilder(QueryBuilder queryBuilder, AggregationBuilder[] aggregationBuilders, String ... indices) {
        return this.jmESSearchAndCount.getSearchRequestBuilder(queryBuilder, aggregationBuilders, indices);
    }

    public SearchRequestBuilder getSearchRequestBuilder(String[] indices, QueryBuilder queryBuilder) {
        return this.jmESSearchAndCount.getSearchRequestBuilder(indices, queryBuilder);
    }

    public SearchRequestBuilder getSearchRequestBuilder(String[] indices, QueryBuilder queryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.getSearchRequestBuilder(indices, queryBuilder, aggregationBuilders);
    }

    public SearchRequestBuilder getSearchRequestBuilder(SearchRequestBuilder searchRequestBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.getSearchRequestBuilder(searchRequestBuilder, aggregationBuilders);
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, String[] indices, QueryBuilder[] mustConditionQueryBuilders, QueryBuilder[] filterConditionQueryBuilders, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.getSearchRequestBuilder(isSetExplain, indices, mustConditionQueryBuilders, filterConditionQueryBuilders, aggregationBuilders);
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, String[] indices) {
        return this.jmESSearchAndCount.getSearchRequestBuilder(isSetExplain, indices);
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, String[] indices, QueryBuilder queryBuilder) {
        return this.jmESSearchAndCount.getSearchRequestBuilder(isSetExplain, indices, queryBuilder);
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, QueryBuilder queryBuilder, String ... indices) {
        return this.jmESSearchAndCount.getSearchRequestBuilder(isSetExplain, queryBuilder, indices);
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, String[] indices, QueryBuilder queryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.getSearchRequestBuilder(isSetExplain, indices, queryBuilder, aggregationBuilders);
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String[] indices, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.getSearchRequestBuilderWithMatchAll(isSetExplain, indices, filterQueryBuilder, aggregationBuilders);
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String[] indices) {
        return this.jmESSearchAndCount.getSearchRequestBuilderWithMatchAll(isSetExplain, indices);
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String[] indices, QueryBuilder filterQueryBuilder) {
        return this.jmESSearchAndCount.getSearchRequestBuilderWithMatchAll(isSetExplain, indices, filterQueryBuilder);
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String index, QueryBuilder filterQueryBuilder) {
        return this.jmESSearchAndCount.getSearchRequestBuilderWithMatchAll(isSetExplain, index, filterQueryBuilder);
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String[] indices, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.getSearchRequestBuilderWithMatchAll(isSetExplain, indices, aggregationBuilders);
    }

    public SearchResponse searchAll(String[] indices, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchAll(indices, aggregationBuilders);
    }

    public SearchResponse searchAll(String ... indices) {
        return this.jmESSearchAndCount.searchAll(indices);
    }

    public SearchResponse searchAll(String index, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchAll(index, filterQueryBuilder, aggregationBuilders);
    }

    public SearchResponse searchAll(String index, QueryBuilder filterQueryBuilder) {
        return this.jmESSearchAndCount.searchAll(index, filterQueryBuilder);
    }

    public SearchResponse searchAll(String index, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchAll(index, aggregationBuilders);
    }

    public SearchResponse searchAll(String[] indices, QueryBuilder filterQueryBuilder) {
        return this.jmESSearchAndCount.searchAll(indices, filterQueryBuilder);
    }

    public SearchResponse searchAll(String[] indices, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchAll(indices, filterQueryBuilder, aggregationBuilders);
    }

    public SearchResponse searchAll(boolean isSetExplain, String[] indices) {
        return this.jmESSearchAndCount.searchAll(isSetExplain, indices);
    }

    public SearchResponse searchAll(boolean isSetExplain, String[] indices, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchAll(isSetExplain, indices, aggregationBuilders);
    }

    public SearchResponse searchAll(boolean isSetExplain, String[] indices, QueryBuilder filterQueryBuilder) {
        return this.jmESSearchAndCount.searchAll(isSetExplain, indices, filterQueryBuilder);
    }

    public SearchResponse searchAll(boolean isSetExplain, String[] indices, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchAll(isSetExplain, indices, filterQueryBuilder, aggregationBuilders);
    }

    public SearchResponse searchAllWithTargetCount(String[] indices, QueryBuilder filterQueryBuilder) {
        return this.jmESSearchAndCount.searchAllWithTargetCount(indices, filterQueryBuilder);
    }

    public SearchResponse searchAllWithTargetCount(String[] indices, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchAllWithTargetCount(indices, aggregationBuilders);
    }

    public SearchResponse searchAllWithTargetCount(String index, QueryBuilder filterQueryBuilder) {
        return this.jmESSearchAndCount.searchAllWithTargetCount(index, filterQueryBuilder);
    }

    public SearchResponse searchAllWithTargetCount(String index, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchAllWithTargetCount(index, aggregationBuilders);
    }

    public SearchResponse searchAllWithTargetCount(String ... indices) {
        return this.jmESSearchAndCount.searchAllWithTargetCount(indices);
    }

    public SearchResponse searchAllWithTargetCount(String index, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchAllWithTargetCount(index, filterQueryBuilder, aggregationBuilders);
    }

    public SearchResponse searchAllWithTargetCount(String[] indices, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchAllWithTargetCount(indices, filterQueryBuilder, aggregationBuilders);
    }

    public SearchResponse searchQuery(SearchRequestBuilder searchRequestBuilder) {
        return this.jmESSearchAndCount.searchQuery(searchRequestBuilder);
    }

    public SearchResponse searchQuery(SearchRequestBuilder searchRequestBuilder, long timeoutMillis) {
        return this.jmESSearchAndCount.searchQuery(searchRequestBuilder, timeoutMillis);
    }

    public long countQuery(SearchRequestBuilder countRequestBuilder) {
        return this.jmESSearchAndCount.countQuery(countRequestBuilder);
    }

    public long countQuery(SearchRequestBuilder countRequestBuilder, long timeoutMillis) {
        return this.jmESSearchAndCount.countQuery(countRequestBuilder, timeoutMillis);
    }

    public long count(String ... indices) {
        return this.jmESSearchAndCount.count(indices);
    }

    public long count(String[] indices, QueryBuilder filterQueryBuilder) {
        return this.jmESSearchAndCount.count(indices, filterQueryBuilder);
    }

    public int getDefaultHitsCount() {
        return this.jmESSearchAndCount.getDefaultHitsCount();
    }

    public void setDefaultHitsCount(int defaultHitsCount) {
        this.jmESSearchAndCount.setDefaultHitsCount(defaultHitsCount);
    }

    public DeleteResponse deleteQuery(DeleteRequestBuilder deleteRequestBuilder) {
        return this.jmESDelete.deleteQuery(deleteRequestBuilder);
    }

    public AcknowledgedResponse deleteIndices(String ... indices) {
        return this.jmESDelete.deleteIndices(indices);
    }

    public DeleteResponse deleteDoc(String index, String type, String id) {
        return this.jmESDelete.deleteDoc(index, type, id);
    }
}

