/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.elasticsearch;

import java.util.Collection;
import java.util.List;
import kr.jm.utils.enums.OS;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMThread;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.reindex.ReindexPlugin;
import org.elasticsearch.node.InternalSettingsPreparer;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeValidationException;
import org.elasticsearch.percolator.PercolatorPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.script.mustache.MustachePlugin;
import org.elasticsearch.transport.Netty4Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMEmbeddedElasticsearch
extends Node {
    private static final Logger log = LoggerFactory.getLogger(JMEmbeddedElasticsearch.class);
    private static final Collection<Class<? extends Plugin>> PRE_INSTALLED_PLUGINS = List.of(Netty4Plugin.class, ReindexPlugin.class, PercolatorPlugin.class, MustachePlugin.class);

    public JMEmbeddedElasticsearch() {
        this(OS.getHostname(), "localhost");
    }

    public JMEmbeddedElasticsearch(Settings settings) {
        super(new Environment(InternalSettingsPreparer.prepareSettings((Settings)settings), null), PRE_INSTALLED_PLUGINS, true);
    }

    public JMEmbeddedElasticsearch(String nodeName, String networkHost) {
        this(JMEmbeddedElasticsearch.getNodeConfig("JMEmbeddedElasticsearch", nodeName, networkHost, OS.getUserWorkingDir(), true).build());
    }

    public static Settings.Builder getNodeConfig(String clusterName, String nodeName, String networkHost, String homePath, boolean nodeIngest) {
        return Settings.builder().put("node.name", nodeName).put("cluster.name", clusterName).put("network.host", networkHost).put("path.home", homePath).put("transport.type", "netty4").put("http.type", "netty4").put("node.ingest", nodeIngest);
    }

    public Node start() {
        try {
            Node node = super.start();
            JMThread.sleep((long)1000L);
            return node;
        }
        catch (NodeValidationException e) {
            return (Node)JMExceptionManager.handleExceptionAndThrowRuntimeEx((Logger)log, (Throwable)e, (String)"start", (Object[])new Object[0]);
        }
    }

    public String getTransportIpPortPair() {
        return this.getCurrentNode().getTransport().address().publishAddress().toString();
    }

    private NodeInfo getCurrentNode() {
        ClusterAdminClient cluster = this.client().admin().cluster();
        return (NodeInfo)((NodesInfoResponse)cluster.prepareNodesInfo(new String[]{((ClusterStateResponse)cluster.prepareState().get()).getState().getNodes().getLocalNodeId()}).get()).getNodes().iterator().next();
    }

    public String getHttpIpPortPair() {
        return this.getCurrentNode().getTransport().address().publishAddress().toString();
    }
}

