/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.elasticsearch;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Map;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMLog;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMElasticsearchUtil {
    private static final Logger log = LoggerFactory.getLogger(JMElasticsearchUtil.class);
    private static final ObjectMapper JsonMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL);
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};

    public static <R extends ActionRequestBuilder<? extends ActionRequest, ? extends ActionResponse>, T> T logRequestQueryAndReturn(String method, R requestBuilder, ActionFuture<T> responseFunction) {
        return JMElasticsearchUtil.logRequestQueryAndReturn(method, requestBuilder, responseFunction, null);
    }

    public static <R extends ActionRequestBuilder<? extends ActionRequest, ? extends ActionResponse>, T> T logRequestQueryAndReturn(String method, R requestBuilder, ActionFuture<T> responseFunction, Long timeoutMillis) {
        try {
            JMElasticsearchUtil.logRequestQuery(method, requestBuilder, timeoutMillis);
            return (T)(timeoutMillis == null || timeoutMillis == 0L ? responseFunction.actionGet() : responseFunction.actionGet(timeoutMillis.longValue()));
        }
        catch (Exception e) {
            return (T)JMExceptionManager.handleExceptionAndThrowRuntimeEx((Logger)log, (Throwable)e, (String)method, (Object[])new Object[]{requestBuilder});
        }
    }

    public static <R extends ActionRequestBuilder<? extends ActionRequest, ? extends ActionResponse>> R logRequestQuery(String method, R requestBuilder, Object ... params) {
        if (params == null) {
            JMLog.debug((Logger)log, (String)method, (Object[])new Object[]{requestBuilder});
        } else {
            JMLog.debug((Logger)log, (String)method, (Object[])new Object[]{Arrays.asList(params), requestBuilder});
        }
        return requestBuilder;
    }

    static Map<String, Object> buildSourceByJsonMapper(Object sourceObject) {
        try {
            return (Map)JsonMapper.convertValue(sourceObject, MAP_TYPE_REFERENCE);
        }
        catch (Exception e) {
            return (Map)JMExceptionManager.handleExceptionAndThrowRuntimeEx((Logger)log, (Throwable)e, (String)"buildSourceByJsonMapper", (Object[])new Object[]{sourceObject});
        }
    }

    static Map<String, Object> buildSourceByJsonMapper(String jsonObjectString) {
        try {
            return (Map)JsonMapper.readValue(jsonObjectString, MAP_TYPE_REFERENCE);
        }
        catch (Exception e) {
            return (Map)JMExceptionManager.handleExceptionAndThrowRuntimeEx((Logger)log, (Throwable)e, (String)"buildSourceByJsonMapper", (Object[])new Object[]{jsonObjectString});
        }
    }
}

