/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.elasticsearch;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kr.jm.utils.elasticsearch.JMElasticsearchClient;
import kr.jm.utils.elasticsearch.JMElasticsearchUtil;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMLog;
import kr.jm.utils.helper.JMOptional;
import kr.jm.utils.helper.JMPredicate;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JMElasticsearchBulk {
    private static final Logger log = LoggerFactory.getLogger(JMElasticsearchBulk.class);
    private final JMElasticsearchClient jmESClient;
    private BulkProcessor bulkProcessor;
    private final ActionListener<BulkResponse> bulkResponseActionListener = new ActionListener<BulkResponse>(){

        public void onResponse(BulkResponse bulkResponse) {
            if (bulkResponse.hasFailures()) {
                JMExceptionManager.handleException((Logger)log, (Throwable)new RuntimeException("ElasticSearch Insert Bulk Error !!!"), (String)"onResponse", (Object[])new Object[]{bulkResponse.buildFailureMessage()});
            } else {
                JMElasticsearchBulk.this.logBulkSendingSuccess(bulkResponse);
            }
        }

        public void onFailure(Exception e) {
            JMExceptionManager.handleException((Logger)log, (Throwable)e, (String)"onFailure", (Object[])new Object[0]);
        }
    };
    private final BulkProcessor.Listener bulkProcessorListener = new BulkProcessor.Listener(){

        public void beforeBulk(long executionId, BulkRequest bulkRequest) {
            log.debug("[Before] Sending Bulk - size = {}, estimatedSizeInBytes = {}", (Object)bulkRequest.requests().size(), (Object)bulkRequest.estimatedSizeInBytes());
        }

        public void afterBulk(long executionId, BulkRequest bulkRequest, Throwable failure) {
            JMExceptionManager.handleException((Logger)log, (Throwable)failure, (String)"afterBulk", (Object[])new Object[]{executionId, bulkRequest.getDescription()});
        }

        public void afterBulk(long executionId, BulkRequest request, BulkResponse bulkResponse) {
            JMElasticsearchBulk.this.logBulkSendingSuccess(bulkResponse);
        }
    };

    JMElasticsearchBulk(JMElasticsearchClient jmElasticsearchClient) {
        this.jmESClient = jmElasticsearchClient;
    }

    private void logBulkSendingSuccess(BulkResponse bulkResponse) {
        log.debug("[Success] Sending Bulk - size = {}, tookInMillis = {}", (Object)bulkResponse.getItems().length, (Object)bulkResponse.getTook().millis());
    }

    private BulkProcessor setAndReturnBulkProcessor(BulkProcessor bulkProcessor) {
        this.bulkProcessor = bulkProcessor;
        return this.bulkProcessor;
    }

    public void setBulkProcessor(int bulkActions, long bulkSizeKB, int flushIntervalSeconds) {
        this.setBulkProcessor(this.bulkProcessorListener, bulkActions, bulkSizeKB, flushIntervalSeconds);
    }

    public void setBulkProcessor(BulkProcessor.Listener bulkProcessorListener, int bulkActions, long bulkSizeKB, int flushIntervalSeconds) {
        this.bulkProcessor = this.buildBulkProcessor(bulkProcessorListener, bulkActions, bulkSizeKB, flushIntervalSeconds);
    }

    public BulkProcessor.Builder getBulkProcessorBuilder(BulkProcessor.Listener bulkProcessorListener, Integer bulkActions, ByteSizeValue byteSizeValue, TimeValue flushInterval, Integer concurrentRequests, BackoffPolicy backoffPolicy) {
        BulkProcessor.Builder builder = this.getBuilder(bulkProcessorListener);
        JMOptional.ifNotNull((Object)bulkActions, arg_0 -> ((BulkProcessor.Builder)builder).setBulkActions(arg_0));
        JMOptional.ifNotNull((Object)byteSizeValue, arg_0 -> ((BulkProcessor.Builder)builder).setBulkSize(arg_0));
        JMOptional.ifNotNull((Object)flushInterval, arg_0 -> ((BulkProcessor.Builder)builder).setFlushInterval(arg_0));
        JMOptional.ifNotNull((Object)concurrentRequests, arg_0 -> ((BulkProcessor.Builder)builder).setConcurrentRequests(arg_0));
        JMOptional.ifNotNull((Object)backoffPolicy, arg_0 -> ((BulkProcessor.Builder)builder).setBackoffPolicy(arg_0));
        return builder;
    }

    private BulkProcessor.Builder getBuilder(BulkProcessor.Listener bulkProcessorListener) {
        return BulkProcessor.builder((Client)this.jmESClient, (BulkProcessor.Listener)bulkProcessorListener);
    }

    public BulkProcessor buildBulkProcessor(BulkProcessor.Listener bulkProcessorListener, int bulkActions, long bulkSizeKB, int flushIntervalSeconds, Integer concurrentRequests, BackoffPolicy backoffPolicy) {
        return this.getBulkProcessorBuilder(bulkProcessorListener, bulkActions, new ByteSizeValue(bulkSizeKB, ByteSizeUnit.KB), TimeValue.timeValueSeconds((long)flushIntervalSeconds), concurrentRequests, backoffPolicy).build();
    }

    public BulkProcessor buildBulkProcessor(BulkProcessor.Listener bulkProcessorListener, int bulkActions, long bulkSizeKB, int flushIntervalSeconds) {
        return this.buildBulkProcessor(bulkProcessorListener, bulkActions, bulkSizeKB, flushIntervalSeconds, null, null);
    }

    public void sendWithBulkProcessor(List<? extends Map<String, Object>> bulkSource, String index) {
        this.sendWithBulkProcessor(bulkSource.stream().map(source -> this.buildIndexRequest(index, null).source(source)).collect(Collectors.toList()));
    }

    public void sendWithBulkProcessor(Map<String, Object> source, String index) {
        this.sendWithBulkProcessor(source, index, null);
    }

    public void sendWithBulkProcessor(Map<String, Object> source, String index, String id) {
        this.sendWithBulkProcessor(this.buildIndexRequest(index, id).source(source));
    }

    public void sendWithBulkProcessorAndObjectMapper(List<Object> bulkObject, String index) {
        this.sendWithBulkProcessor(bulkObject.stream().map(sourceObject -> this.buildIndexRequest(index, null).source(JMElasticsearchUtil.buildSourceByJsonMapper(sourceObject))).collect(Collectors.toList()));
    }

    private IndexRequest buildIndexRequest(String index, String id) {
        return id == null ? new IndexRequest(index) : new IndexRequest(index).id(id);
    }

    public void sendWithBulkProcessorAndObjectMapper(Object object, String index) {
        this.sendWithBulkProcessorAndObjectMapper(object, index, null);
    }

    public void sendWithBulkProcessorAndObjectMapper(Object object, String index, String id) {
        this.sendWithBulkProcessor(this.buildIndexRequest(index, id).source(JMElasticsearchUtil.buildSourceByJsonMapper(object)));
    }

    public void sendWithBulkProcessor(List<IndexRequest> indexRequestList) {
        indexRequestList.forEach(this::sendWithBulkProcessor);
    }

    public void sendWithBulkProcessor(IndexRequest indexRequest) {
        Optional.ofNullable(this.bulkProcessor).orElseGet(() -> this.setAndReturnBulkProcessor(this.getBuilder(this.bulkProcessorListener).build())).add(indexRequest);
    }

    public void closeBulkProcessor() {
        Optional.ofNullable(this.bulkProcessor).filter(JMPredicate.peek(BulkProcessor::flush)).ifPresent(BulkProcessor::close);
    }

    public void sendBulkDataAsync(List<? extends Map<String, Object>> bulkSourceList, String index) {
        this.executeBulkRequestAsync(this.buildBulkIndexRequestBuilder(bulkSourceList.stream().map(source -> ((IndexRequestBuilder)this.jmESClient.prepareIndex().setIndex(index)).setSource(source)).collect(Collectors.toList())));
    }

    public void sendBulkDataAsync(List<? extends Map<String, Object>> bulkSourceList, String index, ActionListener<BulkResponse> bulkResponseActionListener) {
        this.executeBulkRequestAsync(this.buildBulkIndexRequestBuilder(bulkSourceList.stream().map(source -> ((IndexRequestBuilder)this.jmESClient.prepareIndex().setIndex(index)).setSource(source)).collect(Collectors.toList())), bulkResponseActionListener);
    }

    public void sendBulkDataWithObjectMapperAsync(List<Object> objectBulkData, String index) {
        this.executeBulkRequestAsync(this.buildBulkIndexRequestBuilder(objectBulkData.stream().map(sourceObject -> ((IndexRequestBuilder)this.jmESClient.prepareIndex().setIndex(index)).setSource(JMElasticsearchUtil.buildSourceByJsonMapper(sourceObject))).collect(Collectors.toList())));
    }

    public void sendBulkDataWithObjectMapperAsync(List<Object> objectBulkData, String index, ActionListener<BulkResponse> bulkResponseActionListener) {
        this.executeBulkRequestAsync(this.buildBulkIndexRequestBuilder(objectBulkData.stream().map(sourceObject -> ((IndexRequestBuilder)this.jmESClient.prepareIndex().setIndex(index)).setSource(JMElasticsearchUtil.buildSourceByJsonMapper(sourceObject))).collect(Collectors.toList())), bulkResponseActionListener);
    }

    public BulkRequestBuilder buildBulkIndexRequestBuilder(List<IndexRequestBuilder> indexRequestBuilderList) {
        BulkRequestBuilder bulkRequestBuilder = this.jmESClient.prepareBulk();
        for (IndexRequestBuilder indexRequestBuilder : indexRequestBuilderList) {
            bulkRequestBuilder.add(indexRequestBuilder);
        }
        return bulkRequestBuilder;
    }

    public BulkRequestBuilder buildDeleteBulkRequestBuilder(List<DeleteRequestBuilder> deleteRequestBuilderList) {
        BulkRequestBuilder bulkRequestBuilder = this.jmESClient.prepareBulk();
        for (DeleteRequestBuilder deleteRequestBuilder : deleteRequestBuilderList) {
            bulkRequestBuilder.add(deleteRequestBuilder);
        }
        return bulkRequestBuilder;
    }

    public BulkRequestBuilder buildUpdateBulkRequestBuilder(List<UpdateRequestBuilder> updateRequestBuilderList) {
        BulkRequestBuilder bulkRequestBuilder = this.jmESClient.prepareBulk();
        for (UpdateRequestBuilder updateRequestBuilder : updateRequestBuilderList) {
            bulkRequestBuilder.add(updateRequestBuilder);
        }
        return bulkRequestBuilder;
    }

    public void executeBulkRequestAsync(BulkRequestBuilder bulkRequestBuilder) {
        this.executeBulkRequestAsync(bulkRequestBuilder, this.bulkResponseActionListener);
    }

    public void executeBulkRequestAsync(BulkRequestBuilder bulkRequestBuilder, ActionListener<BulkResponse> bulkResponseActionListener) {
        JMLog.info((Logger)log, (String)"executeBulkRequestAsync", (Object[])new Object[]{bulkRequestBuilder, bulkResponseActionListener});
        bulkRequestBuilder.execute(bulkResponseActionListener);
    }

    public BulkResponse executeBulkRequest(BulkRequestBuilder bulkRequestBuilder) {
        JMLog.info((Logger)log, (String)"executeBulkRequest", (Object[])new Object[]{bulkRequestBuilder});
        return (BulkResponse)bulkRequestBuilder.execute().actionGet();
    }

    public boolean deleteBulkDocs(String index) {
        return this.executeBulkRequest(this.buildDeleteBulkRequestBuilder(this.buildAllDeleteRequestBuilderList(index))).hasFailures();
    }

    public BulkResponse deleteBulkDocs(String index, QueryBuilder filterQueryBuilder) {
        return this.executeBulkRequest(this.buildDeleteBulkRequestBuilder(this.buildExtractDeleteRequestBuilderList(index, filterQueryBuilder)));
    }

    public boolean deleteBulkDocs(List<String> indexList, QueryBuilder filterQueryBuilder) {
        return indexList.stream().map(index -> this.deleteBulkDocs((String)index, filterQueryBuilder)).noneMatch(BulkResponse::hasFailures);
    }

    public void deleteBulkDocsAsync(String index) {
        this.executeBulkRequestAsync(this.buildDeleteBulkRequestBuilder(this.buildAllDeleteRequestBuilderList(index)));
    }

    public void deleteBulkDocsAsync(String index, ActionListener<BulkResponse> bulkResponseActionListener) {
        this.executeBulkRequestAsync(this.buildDeleteBulkRequestBuilder(this.buildAllDeleteRequestBuilderList(index)), bulkResponseActionListener);
    }

    public void deleteBulkDocsAsync(String index, QueryBuilder filterQueryBuilder) {
        this.executeBulkRequestAsync(this.buildDeleteBulkRequestBuilder(this.buildExtractDeleteRequestBuilderList(index, filterQueryBuilder)));
    }

    public void deleteBulkDocsAsync(String index, QueryBuilder filterQueryBuilder, ActionListener<BulkResponse> bulkResponseActionListener) {
        this.executeBulkRequestAsync(this.buildDeleteBulkRequestBuilder(this.buildExtractDeleteRequestBuilderList(index, filterQueryBuilder)), bulkResponseActionListener);
    }

    public void deleteBulkDocsAsync(List<String> indexList, QueryBuilder filterQueryBuilder, ActionListener<BulkResponse> bulkResponseActionListener) {
        indexList.forEach(index -> this.deleteBulkDocsAsync((String)index, filterQueryBuilder, bulkResponseActionListener));
    }

    private List<DeleteRequestBuilder> buildAllDeleteRequestBuilderList(String index) {
        return this.buildDeleteRequestBuilderList(index, this.jmESClient.getAllIdList(index));
    }

    private List<DeleteRequestBuilder> buildExtractDeleteRequestBuilderList(String index, QueryBuilder filterQueryBuilder) {
        return this.buildDeleteRequestBuilderList(index, this.jmESClient.extractIdList(index, filterQueryBuilder));
    }

    private List<DeleteRequestBuilder> buildDeleteRequestBuilderList(String index, List<String> idList) {
        return idList.stream().map(id -> ((DeleteRequestBuilder)this.jmESClient.prepareDelete().setIndex(index)).setId(id)).collect(Collectors.toList());
    }
}

