/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.elasticsearch;

import java.util.Objects;
import java.util.function.Consumer;
import kr.jm.utils.JMArrays;
import kr.jm.utils.JMStream;
import kr.jm.utils.elasticsearch.JMElasticsearchUtil;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;

public class JMElasticsearchSearchAndCount {
    private static final int DefaultHitsCount = 10;
    private static long timeoutMillis = 5000L;
    private final Client esClient;
    private int defaultHitsCount;

    public JMElasticsearchSearchAndCount(Client elasticsearchClient) {
        this.esClient = elasticsearchClient;
        this.defaultHitsCount = 10;
    }

    public SearchResponse searchWithTargetCount(SearchRequestBuilder searchRequestBuilder) {
        return this.searchQuery(this.getSearchRequestBuilderWithCount(searchRequestBuilder));
    }

    public SearchResponse searchWithTargetCount(SearchRequestBuilder searchRequestBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.searchWithTargetCount(this.getSearchRequestBuilder(this.getSearchRequestBuilderWithCount(searchRequestBuilder), aggregationBuilders));
    }

    public SearchResponse searchWithTargetCount(boolean isSetExplain, String[] indices, QueryBuilder[] mustConditionQueryBuilders, QueryBuilder[] filterConditionQueryBuilders) {
        return this.searchWithTargetCount(isSetExplain, indices, mustConditionQueryBuilders, filterConditionQueryBuilders, null);
    }

    public SearchResponse searchWithTargetCount(boolean isSetExplain, String[] indices, QueryBuilder[] mustConditionQueryBuilders, QueryBuilder[] filterConditionQueryBuilders, AggregationBuilder[] aggregationBuilders) {
        return this.searchWithTargetCount(this.getSearchRequestBuilder(isSetExplain, indices, mustConditionQueryBuilders, filterConditionQueryBuilders, null), aggregationBuilders);
    }

    public SearchRequestBuilder getSearchRequestBuilder(QueryBuilder queryBuilder, String ... indices) {
        return this.getSearchRequestBuilder(indices, queryBuilder);
    }

    public SearchRequestBuilder getSearchRequestBuilder(QueryBuilder queryBuilder, AggregationBuilder[] aggregationBuilders, String ... indices) {
        return this.getSearchRequestBuilder(indices, queryBuilder, aggregationBuilders);
    }

    public SearchRequestBuilder getSearchRequestBuilder(String[] indices, QueryBuilder queryBuilder) {
        return this.getSearchRequestBuilder(indices, queryBuilder, null);
    }

    public SearchRequestBuilder getSearchRequestBuilder(String[] indices, QueryBuilder queryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.getSearchRequestBuilder(false, indices, queryBuilder, aggregationBuilders);
    }

    public SearchRequestBuilder getSearchRequestBuilder(SearchRequestBuilder searchRequestBuilder, AggregationBuilder[] aggregationBuilders) {
        JMStream.buildStream((Object[])aggregationBuilders).filter(Objects::nonNull).forEach(arg_0 -> ((SearchRequestBuilder)searchRequestBuilder).addAggregation(arg_0));
        return searchRequestBuilder;
    }

    private SearchRequestBuilder getSearchRequestBuilderWithCount(SearchRequestBuilder searchRequestBuilder) {
        return searchRequestBuilder.setSize(Long.valueOf(this.countQuery(searchRequestBuilder)).intValue());
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, String[] indices, QueryBuilder[] mustConditionQueryBuilders, QueryBuilder[] filterConditionQueryBuilders, AggregationBuilder[] aggregationBuilders) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        JMStream.buildStream((Object[])mustConditionQueryBuilders).forEach(queryBuilder -> this.buildQueryBuilder((QueryBuilder)queryBuilder, arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).must(arg_0)));
        JMStream.buildStream((Object[])filterConditionQueryBuilders).forEach(queryBuilder -> this.buildQueryBuilder((QueryBuilder)queryBuilder, arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).filter(arg_0)));
        return this.getSearchRequestBuilder(isSetExplain, indices, (QueryBuilder)boolQueryBuilder, aggregationBuilders);
    }

    private void buildQueryBuilder(QueryBuilder queryBuilder, Consumer<QueryBuilder> builderConsumer) {
        if (Objects.nonNull(queryBuilder)) {
            builderConsumer.accept(queryBuilder);
        }
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, String[] indices) {
        return this.getSearchRequestBuilder(isSetExplain, indices, null);
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, String[] indices, QueryBuilder queryBuilder) {
        return this.getSearchRequestBuilder(isSetExplain, indices, queryBuilder, null);
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, QueryBuilder queryBuilder, String ... indices) {
        return this.getSearchRequestBuilder(isSetExplain, indices, queryBuilder, null);
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, String[] indices, QueryBuilder queryBuilder, AggregationBuilder[] aggregationBuilders) {
        SearchRequestBuilder searchRequestBuilder = this.getSearchRequestBuilder(this.esClient.prepareSearch(indices).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setSize(this.defaultHitsCount).setExplain(isSetExplain), aggregationBuilders);
        this.buildQueryBuilder(queryBuilder, arg_0 -> ((SearchRequestBuilder)searchRequestBuilder).setQuery(arg_0));
        return searchRequestBuilder;
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String[] indices, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.getSearchRequestBuilder(isSetExplain, indices, (QueryBuilder[])JMArrays.buildArray((Object[])new MatchAllQueryBuilder[]{QueryBuilders.matchAllQuery()}), (QueryBuilder[])JMArrays.buildArray((Object[])new QueryBuilder[]{filterQueryBuilder}), aggregationBuilders);
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String[] indices) {
        return this.getSearchRequestBuilderWithMatchAll(isSetExplain, indices, (QueryBuilder)null);
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String[] indices, QueryBuilder filterQueryBuilder) {
        return this.getSearchRequestBuilderWithMatchAll(isSetExplain, indices, filterQueryBuilder, null);
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String index, QueryBuilder filterQueryBuilder) {
        return this.getSearchRequestBuilderWithMatchAll(isSetExplain, (String[])JMArrays.buildArray((Object[])new String[]{index}), filterQueryBuilder);
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String[] indices, AggregationBuilder[] aggregationBuilders) {
        return this.getSearchRequestBuilderWithMatchAll(isSetExplain, indices, null, aggregationBuilders);
    }

    public SearchResponse searchAll(String[] indices, AggregationBuilder[] aggregationBuilders) {
        return this.searchAll(indices, null, aggregationBuilders);
    }

    public SearchResponse searchAll(String ... indices) {
        return this.searchAll(false, indices);
    }

    public SearchResponse searchAll(String index, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.searchAll((String[])JMArrays.buildArray((Object[])new String[]{index}), filterQueryBuilder, aggregationBuilders);
    }

    public SearchResponse searchAll(String index, QueryBuilder filterQueryBuilder) {
        return this.searchAll(index, filterQueryBuilder, null);
    }

    public SearchResponse searchAll(String index, AggregationBuilder[] aggregationBuilders) {
        return this.searchAll(index, null, aggregationBuilders);
    }

    public SearchResponse searchAll(String[] indices, QueryBuilder filterQueryBuilder) {
        return this.searchAll(indices, filterQueryBuilder, null);
    }

    public SearchResponse searchAll(String[] indices, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.searchAll(false, indices, filterQueryBuilder, aggregationBuilders);
    }

    public SearchResponse searchAll(boolean isSetExplain, String[] indices) {
        return this.searchAll(isSetExplain, indices, (QueryBuilder)null);
    }

    public SearchResponse searchAll(boolean isSetExplain, String[] indices, AggregationBuilder[] aggregationBuilders) {
        return this.searchAll(isSetExplain, indices, null, aggregationBuilders);
    }

    public SearchResponse searchAll(boolean isSetExplain, String[] indices, QueryBuilder filterQueryBuilder) {
        return this.searchAll(isSetExplain, indices, filterQueryBuilder, null);
    }

    public SearchResponse searchAll(boolean isSetExplain, String[] indices, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.searchQuery(this.getSearchRequestBuilderWithMatchAll(isSetExplain, indices, filterQueryBuilder, aggregationBuilders));
    }

    public SearchResponse searchAllWithTargetCount(String[] indices, QueryBuilder filterQueryBuilder) {
        return this.searchAllWithTargetCount(indices, filterQueryBuilder, null);
    }

    public SearchResponse searchAllWithTargetCount(String[] indices, AggregationBuilder[] aggregationBuilders) {
        return this.searchAllWithTargetCount(indices, null, aggregationBuilders);
    }

    public SearchResponse searchAllWithTargetCount(String index, QueryBuilder filterQueryBuilder) {
        return this.searchAllWithTargetCount(index, filterQueryBuilder, null);
    }

    public SearchResponse searchAllWithTargetCount(String index, AggregationBuilder[] aggregationBuilders) {
        return this.searchAllWithTargetCount(index, null, aggregationBuilders);
    }

    public SearchResponse searchAllWithTargetCount(String ... indices) {
        return this.searchAllWithTargetCount(indices, (QueryBuilder)null);
    }

    public SearchResponse searchAllWithTargetCount(String index, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.searchAllWithTargetCount((String[])JMArrays.buildArray((Object[])new String[]{index}), filterQueryBuilder, aggregationBuilders);
    }

    public SearchResponse searchAllWithTargetCount(String[] indices, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.searchWithTargetCount(this.getSearchRequestBuilderWithMatchAll(false, indices, filterQueryBuilder), aggregationBuilders);
    }

    public SearchResponse searchQuery(SearchRequestBuilder searchRequestBuilder) {
        return this.searchQuery(searchRequestBuilder, timeoutMillis);
    }

    private SearchResponse searchQuery(String method, SearchRequestBuilder searchRequestBuilder, long timeoutMillis) {
        searchRequestBuilder.setTimeout(TimeValue.timeValueMillis((long)timeoutMillis));
        return (SearchResponse)JMElasticsearchUtil.logRequestQueryAndReturn(method, searchRequestBuilder, searchRequestBuilder.execute(), timeoutMillis);
    }

    public SearchResponse searchQuery(SearchRequestBuilder searchRequestBuilder, long timeoutMillis) {
        return this.searchQuery("searchQuery", searchRequestBuilder, timeoutMillis);
    }

    public long countQuery(SearchRequestBuilder countRequestBuilder) {
        return this.countQuery(countRequestBuilder, timeoutMillis);
    }

    public long countQuery(SearchRequestBuilder countRequestBuilder, long timeoutMillis) {
        countRequestBuilder.setSize(0);
        return this.searchQuery((String)"countQuery", (SearchRequestBuilder)countRequestBuilder, (long)timeoutMillis).getHits().getTotalHits().value;
    }

    public long count(String ... indices) {
        return this.count(indices, (QueryBuilder)null);
    }

    public long count(String[] indices, QueryBuilder filterQueryBuilder) {
        return this.countQuery(this.getSearchRequestBuilderWithMatchAll(false, indices, filterQueryBuilder));
    }

    public static long getTimeoutMillis() {
        return timeoutMillis;
    }

    public static void setTimeoutMillis(long timeoutMillis) {
        JMElasticsearchSearchAndCount.timeoutMillis = timeoutMillis;
    }

    public int getDefaultHitsCount() {
        return this.defaultHitsCount;
    }

    public void setDefaultHitsCount(int defaultHitsCount) {
        this.defaultHitsCount = defaultHitsCount;
    }
}

