/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.elasticsearch;

import java.util.Map;
import kr.jm.utils.elasticsearch.JMElasticsearchUtil;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.XContentType;

public class JMElasticsearchIndex {
    private final Client jmESClient;

    public JMElasticsearchIndex(Client elasticsearchClient) {
        this.jmESClient = elasticsearchClient;
    }

    public IndexResponse indexQuery(IndexRequestBuilder indexRequestBuilder) {
        return (IndexResponse)JMElasticsearchUtil.logRequestQueryAndReturn("indexQuery", indexRequestBuilder, indexRequestBuilder.execute());
    }

    public ActionFuture<IndexResponse> indexQueryAsync(IndexRequestBuilder indexRequestBuilder) {
        return JMElasticsearchUtil.logRequestQuery("indexQueryAsync", indexRequestBuilder, new Object[0]).execute();
    }

    private IndexRequestBuilder buildIndexRequest(String index, String id, String jsonSource) {
        return this.buildIndexRequest(index, id, JMElasticsearchUtil.buildSourceByJsonMapper(jsonSource));
    }

    private IndexRequestBuilder buildIndexRequest(String index, String id, Map<String, Object> source) {
        return this.getPrepareIndex(index, id).setSource(source);
    }

    private IndexRequestBuilder getPrepareIndex(String index, String id) {
        return id == null ? (IndexRequestBuilder)this.jmESClient.prepareIndex().setIndex(index) : ((IndexRequestBuilder)this.jmESClient.prepareIndex().setIndex(index)).setId(id);
    }

    private UpdateRequestBuilder buildPrepareUpsert(String index, String id, String jsonString) {
        return ((UpdateRequestBuilder)this.jmESClient.prepareUpdate().setIndex(index)).setId(id).setDoc(jsonString, XContentType.JSON).setUpsert(new IndexRequest(index).id(id).source(jsonString, XContentType.JSON));
    }

    private UpdateRequestBuilder buildPrepareUpsert(String index, String id, Map<String, Object> source) {
        return ((UpdateRequestBuilder)this.jmESClient.prepareUpdate().setIndex(index)).setId(id).setDoc(source).setUpsert(new IndexRequest(index).id(id).source(source));
    }

    public UpdateResponse upsertQuery(UpdateRequestBuilder updateRequestBuilder) {
        return (UpdateResponse)JMElasticsearchUtil.logRequestQueryAndReturn("upsertQuery", updateRequestBuilder, updateRequestBuilder.execute());
    }

    public ActionFuture<UpdateResponse> upsertQueryAsync(UpdateRequestBuilder updateRequestBuilder) {
        return JMElasticsearchUtil.logRequestQuery("upsertQueryAsync", updateRequestBuilder, new Object[0]).execute();
    }

    public UpdateResponse upsertData(String index, String id, Map<String, Object> source) {
        return this.upsertQuery(this.buildPrepareUpsert(index, id, source));
    }

    public ActionFuture<UpdateResponse> upsertDataAsync(String index, String id, Map<String, Object> source) {
        return this.upsertQueryAsync(this.buildPrepareUpsert(index, id, source));
    }

    public UpdateResponse upsertData(String index, String id, String jsonSource) {
        return this.upsertQuery(this.buildPrepareUpsert(index, id, jsonSource));
    }

    public ActionFuture<UpdateResponse> upsertDataAsync(String index, String id, String jsonSource) {
        return this.upsertQueryAsync(this.buildPrepareUpsert(index, id, jsonSource));
    }

    public UpdateResponse upsertDataWithObjectMapper(String index, String id, Object sourceObject) {
        return this.upsertData(index, id, JMElasticsearchUtil.buildSourceByJsonMapper(sourceObject));
    }

    public ActionFuture<UpdateResponse> upsertDataASyncWithObjectMapper(String index, String id, Object sourceObject) {
        return this.upsertDataAsync(index, id, JMElasticsearchUtil.buildSourceByJsonMapper(sourceObject));
    }

    public IndexResponse sendData(String index, String id, Map<String, Object> source) {
        return this.indexQuery(this.buildIndexRequest(index, id, source));
    }

    public String sendData(String index, Map<String, Object> source) {
        return this.sendData(index, null, source).getId();
    }

    public IndexResponse sendData(String index, String id, String jsonSource) {
        return this.indexQuery(this.buildIndexRequest(index, id, jsonSource));
    }

    public String sendData(String index, String jsonSource) {
        return this.sendData(index, null, jsonSource).getId();
    }

    public IndexResponse sendDataWithObjectMapper(String index, String id, Object sourceObject) {
        return this.sendData(index, id, JMElasticsearchUtil.buildSourceByJsonMapper(sourceObject));
    }

    public String sendDataWithObjectMapper(String index, Object sourceObject) {
        return this.sendDataWithObjectMapper(index, null, sourceObject).getId();
    }

    public ActionFuture<IndexResponse> sendDataAsync(String index, String id, Map<String, Object> source) {
        return this.indexQueryAsync(this.buildIndexRequest(index, id, source));
    }

    public ActionFuture<IndexResponse> sendDataAsync(String index, Map<String, Object> source) {
        return this.indexQueryAsync(this.buildIndexRequest(index, null, source));
    }

    public ActionFuture<IndexResponse> sendDataAsync(String index, String id, String jsonSource) {
        return this.indexQueryAsync(this.buildIndexRequest(index, id, jsonSource));
    }

    public ActionFuture<IndexResponse> sendDataAsync(String index, String jsonSource) {
        return this.indexQueryAsync(this.buildIndexRequest(index, null, jsonSource));
    }

    public ActionFuture<IndexResponse> sendDataAsyncWithObjectMapper(String index, String id, Object sourceObject) {
        return this.indexQueryAsync(this.buildIndexRequest(index, id, JMElasticsearchUtil.buildSourceByJsonMapper(sourceObject)));
    }

    public ActionFuture<IndexResponse> sendDataAsyncWithObjectMapper(String index, Object sourceObject) {
        return this.indexQueryAsync(this.buildIndexRequest(index, null, JMElasticsearchUtil.buildSourceByJsonMapper(sourceObject)));
    }
}

