/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.elasticsearch;

import java.util.Arrays;
import java.util.function.Consumer;
import kr.jm.utils.datastructure.JMArrays;
import kr.jm.utils.elasticsearch.JMElasticsearchUtil;
import kr.jm.utils.helper.JMOptional;
import kr.jm.utils.helper.JMPredicate;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;

public class JMElasticsearchSearchAndCount {
    private static final int DefaultHitsCount = 10;
    private static long timeoutMillis = 5000L;
    private Client esClient;
    private int defaultHitsCount;

    public JMElasticsearchSearchAndCount(Client elasticsearchClient) {
        this.esClient = elasticsearchClient;
        this.defaultHitsCount = 10;
    }

    public SearchResponse searchWithTargetCount(SearchRequestBuilder searchRequestBuilder) {
        return this.searchQuery(this.getSearchRequestBuilderWithCount(searchRequestBuilder));
    }

    public SearchResponse searchWithTargetCount(SearchRequestBuilder searchRequestBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.searchWithTargetCount(this.getSearchRequestBuilder(this.getSearchRequestBuilderWithCount(searchRequestBuilder), aggregationBuilders));
    }

    public SearchResponse searchWithTargetCount(boolean isSetExplain, String[] indices, String[] types, QueryBuilder[] mustConditionQueryBuilders, QueryBuilder[] filterConditionQueryBuilders) {
        return this.searchWithTargetCount(isSetExplain, indices, types, mustConditionQueryBuilders, filterConditionQueryBuilders, null);
    }

    public SearchResponse searchWithTargetCount(boolean isSetExplain, String[] indices, String[] types, QueryBuilder[] mustConditionQueryBuilders, QueryBuilder[] filterConditionQueryBuilders, AggregationBuilder[] aggregationBuilders) {
        return this.searchWithTargetCount(this.getSearchRequestBuilder(isSetExplain, indices, types, mustConditionQueryBuilders, filterConditionQueryBuilders, null), aggregationBuilders);
    }

    public SearchRequestBuilder getSearchRequestBuilder(QueryBuilder queryBuilder, String ... indices) {
        return this.getSearchRequestBuilder(indices, null, queryBuilder);
    }

    public SearchRequestBuilder getSearchRequestBuilder(QueryBuilder queryBuilder, AggregationBuilder[] aggregationBuilders, String ... indices) {
        return this.getSearchRequestBuilder(indices, null, queryBuilder, aggregationBuilders);
    }

    public SearchRequestBuilder getSearchRequestBuilder(String[] indices, String[] types, QueryBuilder queryBuilder) {
        return this.getSearchRequestBuilder(indices, types, queryBuilder, null);
    }

    public SearchRequestBuilder getSearchRequestBuilder(String[] indices, String[] types, QueryBuilder queryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.getSearchRequestBuilder(false, indices, types, queryBuilder, aggregationBuilders);
    }

    public SearchRequestBuilder getSearchRequestBuilder(SearchRequestBuilder searchRequestBuilder, AggregationBuilder[] aggregationBuilders) {
        JMOptional.ifNotNull((Object)aggregationBuilders, array -> Arrays.stream(array).filter(JMPredicate.getIsNotNull()).forEach(arg_0 -> ((SearchRequestBuilder)searchRequestBuilder).addAggregation(arg_0)));
        return searchRequestBuilder;
    }

    private SearchRequestBuilder getSearchRequestBuilderWithCount(SearchRequestBuilder searchRequestBuilder) {
        return searchRequestBuilder.setSize(Long.valueOf(this.countQuery(searchRequestBuilder)).intValue());
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, String[] indices, String[] types, QueryBuilder[] mustConditionQueryBuilders, QueryBuilder[] filterConditionQueryBuilders, AggregationBuilder[] aggregationBuilders) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        JMOptional.ifNotNull((Object)mustConditionQueryBuilders, array -> this.buildQueryBuilder((QueryBuilder[])array, arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).must(arg_0)));
        JMOptional.ifNotNull((Object)filterConditionQueryBuilders, array -> this.buildQueryBuilder((QueryBuilder[])array, arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).filter(arg_0)));
        return this.getSearchRequestBuilder(isSetExplain, indices, types, (QueryBuilder)boolQueryBuilder, aggregationBuilders);
    }

    private void buildQueryBuilder(QueryBuilder[] array, Consumer<QueryBuilder> builderConsumer) {
        Arrays.stream(array).filter(JMPredicate.getIsNotNull()).forEach(builderConsumer);
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, String[] indices) {
        return this.getSearchRequestBuilder(isSetExplain, indices, null);
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, String[] indices, String[] types) {
        return this.getSearchRequestBuilder(isSetExplain, indices, types, null);
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, String[] indices, String[] types, QueryBuilder queryBuilder) {
        return this.getSearchRequestBuilder(isSetExplain, indices, types, queryBuilder, null);
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, QueryBuilder queryBuilder, String ... indices) {
        return this.getSearchRequestBuilder(isSetExplain, indices, null, queryBuilder, null);
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, String[] indices, String[] types, QueryBuilder queryBuilder, AggregationBuilder[] aggregationBuilders) {
        SearchRequestBuilder searchRequestBuilder = this.getSearchRequestBuilder(this.esClient.prepareSearch(indices).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setSize(this.defaultHitsCount).setExplain(isSetExplain), aggregationBuilders);
        JMOptional.ifNotNull((Object)types, arg_0 -> ((SearchRequestBuilder)searchRequestBuilder).setTypes(arg_0));
        JMOptional.ifNotNull((Object)queryBuilder, arg_0 -> ((SearchRequestBuilder)searchRequestBuilder).setQuery(arg_0));
        return searchRequestBuilder;
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String[] indices, String[] types, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.getSearchRequestBuilder(isSetExplain, indices, types, (QueryBuilder[])JMArrays.buildArray((Object[])new MatchAllQueryBuilder[]{QueryBuilders.matchAllQuery()}), (QueryBuilder[])JMArrays.buildArray((Object[])new QueryBuilder[]{filterQueryBuilder}), aggregationBuilders);
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String[] indices, String[] types) {
        return this.getSearchRequestBuilderWithMatchAll(isSetExplain, indices, types, null, null);
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String[] indices) {
        return this.getSearchRequestBuilderWithMatchAll(isSetExplain, indices, null);
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String[] indices, String[] types, QueryBuilder filterQueryBuilder) {
        return this.getSearchRequestBuilderWithMatchAll(isSetExplain, indices, types, filterQueryBuilder, null);
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String index, String type, QueryBuilder filterQueryBuilder) {
        return this.getSearchRequestBuilderWithMatchAll(isSetExplain, (String[])JMArrays.buildArray((Object[])new String[]{index}), (String[])JMArrays.buildArray((Object[])new String[]{type}), filterQueryBuilder);
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String[] indices, String[] types, AggregationBuilder[] aggregationBuilders) {
        return this.getSearchRequestBuilderWithMatchAll(isSetExplain, indices, types, null, aggregationBuilders);
    }

    public SearchResponse searchAll(String[] indices, String[] types, AggregationBuilder[] aggregationBuilders) {
        return this.searchAll(indices, types, null, aggregationBuilders);
    }

    public SearchResponse searchAll(String[] indices, String[] types) {
        return this.searchAll(indices, types, (QueryBuilder)null, (AggregationBuilder[])null);
    }

    public SearchResponse searchAll(String[] indices, String type) {
        return this.searchAll(indices, (String[])JMArrays.buildArray((Object[])new String[]{type}));
    }

    public SearchResponse searchAll(String ... indices) {
        return this.searchAll(false, indices);
    }

    public SearchResponse searchAll(String index, String type, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.searchAll((String[])JMArrays.buildArray((Object[])new String[]{index}), (String[])JMArrays.buildArray((Object[])new String[]{type}), filterQueryBuilder, aggregationBuilders);
    }

    public SearchResponse searchAll(String index, String type, QueryBuilder filterQueryBuilder) {
        return this.searchAll(index, type, filterQueryBuilder, null);
    }

    public SearchResponse searchAll(String index, String type, AggregationBuilder[] aggregationBuilders) {
        return this.searchAll(index, type, null, aggregationBuilders);
    }

    public SearchResponse searchAll(String index, String type) {
        return this.searchAll((String[])JMArrays.buildArray((Object[])new String[]{index}), type);
    }

    public SearchResponse searchAll(String[] indices, String[] types, QueryBuilder filterQueryBuilder) {
        return this.searchAll(indices, types, filterQueryBuilder, null);
    }

    public SearchResponse searchAll(String[] indices, String[] types, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.searchAll(false, indices, types, filterQueryBuilder, aggregationBuilders);
    }

    public SearchResponse searchAll(boolean isSetExplain, String[] indices) {
        return this.searchAll(isSetExplain, indices, null);
    }

    public SearchResponse searchAll(boolean isSetExplain, String[] indices, String[] types) {
        return this.searchAll(isSetExplain, indices, types, null, null);
    }

    public SearchResponse searchAll(boolean isSetExplain, String[] indices, String[] types, AggregationBuilder[] aggregationBuilders) {
        return this.searchAll(isSetExplain, indices, types, null, aggregationBuilders);
    }

    public SearchResponse searchAll(boolean isSetExplain, String[] indices, String[] types, QueryBuilder filterQueryBuilder) {
        return this.searchAll(isSetExplain, indices, types, filterQueryBuilder, null);
    }

    public SearchResponse searchAll(boolean isSetExplain, String[] indices, String[] types, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.searchQuery(this.getSearchRequestBuilderWithMatchAll(isSetExplain, indices, types, filterQueryBuilder, aggregationBuilders));
    }

    public SearchResponse searchAllWithTargetCount(String[] indices, String[] types) {
        return this.searchAllWithTargetCount(indices, types, (QueryBuilder)null, (AggregationBuilder[])null);
    }

    public SearchResponse searchAllWithTargetCount(String[] indices, String[] types, QueryBuilder filterQueryBuilder) {
        return this.searchAllWithTargetCount(indices, types, filterQueryBuilder, null);
    }

    public SearchResponse searchAllWithTargetCount(String[] indices, String[] types, AggregationBuilder[] aggregationBuilders) {
        return this.searchAllWithTargetCount(indices, types, null, aggregationBuilders);
    }

    public SearchResponse searchAllWithTargetCount(String index, String type, QueryBuilder filterQueryBuilder) {
        return this.searchAllWithTargetCount(index, type, filterQueryBuilder, null);
    }

    public SearchResponse searchAllWithTargetCount(String index, String type, AggregationBuilder[] aggregationBuilders) {
        return this.searchAllWithTargetCount(index, type, null, aggregationBuilders);
    }

    public SearchResponse searchAllWithTargetCount(String index, String type) {
        return this.searchAllWithTargetCount(index, type, (QueryBuilder)null, (AggregationBuilder[])null);
    }

    public SearchResponse searchAllWithTargetCount(String ... indices) {
        return this.searchAllWithTargetCount(indices, (String[])null);
    }

    public SearchResponse searchAllWithTargetCount(String index, String type, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.searchAllWithTargetCount((String[])JMArrays.buildArray((Object[])new String[]{index}), (String[])JMArrays.buildArray((Object[])new String[]{type}), filterQueryBuilder, aggregationBuilders);
    }

    public SearchResponse searchAllWithTargetCount(String[] indices, String[] types, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.searchWithTargetCount(this.getSearchRequestBuilderWithMatchAll(false, indices, types, filterQueryBuilder), aggregationBuilders);
    }

    public SearchResponse searchQuery(SearchRequestBuilder searchRequestBuilder) {
        return this.searchQuery(searchRequestBuilder, timeoutMillis);
    }

    private SearchResponse searchQuery(String method, SearchRequestBuilder searchRequestBuilder, long timeoutMillis) {
        searchRequestBuilder.setTimeout(TimeValue.timeValueMillis((long)timeoutMillis));
        return (SearchResponse)JMElasticsearchUtil.logRequestQueryAndReturn(method, searchRequestBuilder, searchRequestBuilder.execute(), timeoutMillis);
    }

    public SearchResponse searchQuery(SearchRequestBuilder searchRequestBuilder, long timeoutMillis) {
        return this.searchQuery("searchQuery", searchRequestBuilder, timeoutMillis);
    }

    public long countQuery(SearchRequestBuilder countRequestBuilder) {
        return this.countQuery(countRequestBuilder, timeoutMillis);
    }

    public long countQuery(SearchRequestBuilder countRequestBuilder, long timeoutMillis) {
        countRequestBuilder.setSize(0);
        return this.searchQuery("countQuery", countRequestBuilder, timeoutMillis).getHits().getTotalHits();
    }

    public long count(String ... indices) {
        return this.count(indices, (String[])null);
    }

    public long count(String[] indices, String[] types) {
        return this.count(indices, types, (QueryBuilder)null);
    }

    public long count(String[] indices, String[] types, QueryBuilder filterQueryBuilder) {
        return this.countQuery(this.getSearchRequestBuilderWithMatchAll(false, indices, types, filterQueryBuilder));
    }

    public static long getTimeoutMillis() {
        return timeoutMillis;
    }

    public static void setTimeoutMillis(long timeoutMillis) {
        JMElasticsearchSearchAndCount.timeoutMillis = timeoutMillis;
    }

    public int getDefaultHitsCount() {
        return this.defaultHitsCount;
    }

    public void setDefaultHitsCount(int defaultHitsCount) {
        this.defaultHitsCount = defaultHitsCount;
    }
}

