/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.elasticsearch;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kr.jm.utils.elasticsearch.JMElasticsearchBulk;
import kr.jm.utils.elasticsearch.JMElasticsearchDelete;
import kr.jm.utils.elasticsearch.JMElasticsearchIndex;
import kr.jm.utils.elasticsearch.JMElasticsearchSearchAndCount;
import kr.jm.utils.elasticsearch.JMElasticsearchUtil;
import kr.jm.utils.enums.OS;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMLog;
import kr.jm.utils.helper.JMString;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequestBuilder;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequestBuilder;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMElasticsearchClient
extends PreBuiltTransportClient {
    private static final Logger log = LoggerFactory.getLogger(JMElasticsearchClient.class);
    private static final String NODE_NAME = "node.name";
    private static final String CLIENT_TRANSPORT_IGNORE_CLUSTER_NAME = "client.transport.ignore_cluster_name";
    private static final String CLUSTER_NAME = "cluster.name";
    private static final String CLIENT_TRANSPORT_SNIFF = "client.transport.sniff";
    private Settings settings;
    private JMElasticsearchBulk jmESBulk;
    private JMElasticsearchIndex jmESIndex;
    private JMElasticsearchSearchAndCount jmESSearchAndCount;
    private JMElasticsearchDelete jmESDelete;

    public JMElasticsearchClient() {
        this(JMString.buildIpOrHostnamePortPair((String)OS.getHostname(), (int)9300));
    }

    public JMElasticsearchClient(String elasticsearchConnect) {
        this(elasticsearchConnect, OS.getHostname());
    }

    public JMElasticsearchClient(String elasticsearchConnect, boolean clientTransportSniff) {
        this(elasticsearchConnect, OS.getHostname(), clientTransportSniff);
    }

    public JMElasticsearchClient(String elasticsearchConnect, boolean clientTransportSniff, String clusterName) {
        this(elasticsearchConnect, OS.getHostname(), clientTransportSniff, clusterName);
    }

    public JMElasticsearchClient(String elasticsearchConnect, String nodeName) {
        this(elasticsearchConnect, nodeName, true);
    }

    public JMElasticsearchClient(String elasticsearchConnect, String nodeName, boolean clientTransportSniff) {
        this(elasticsearchConnect, nodeName, clientTransportSniff, null);
    }

    public JMElasticsearchClient(String elasticsearchConnect, String nodeName, boolean clientTransportSniff, String clusterName) {
        this(elasticsearchConnect, JMElasticsearchClient.getSettingsBuilder(nodeName, clientTransportSniff, clusterName).build());
    }

    public JMElasticsearchClient(String elasticsearchConnect, Settings settings) {
        super(settings, new Class[0]);
        this.settings = settings;
        try {
            for (String ipPort : elasticsearchConnect.split(",")) {
                String[] separatedIpPort = ipPort.split(":");
                this.addTransportAddress(new TransportAddress(InetAddress.getByName(separatedIpPort[0]), Integer.parseInt(separatedIpPort[1])));
            }
        }
        catch (Exception e) {
            JMExceptionManager.handleExceptionAndThrowRuntimeEx((Logger)log, (Throwable)e, (String)"JMElasticsearchClient", (Object[])new Object[]{elasticsearchConnect, settings});
        }
        JMLog.info((Logger)log, (String)"initElasticsearchClient", (Object[])new Object[]{elasticsearchConnect, settings});
        this.jmESBulk = new JMElasticsearchBulk(this);
        this.jmESIndex = new JMElasticsearchIndex((Client)this);
        this.jmESSearchAndCount = new JMElasticsearchSearchAndCount((Client)this);
        this.jmESDelete = new JMElasticsearchDelete((Client)this);
    }

    public static Settings.Builder getSettingsBuilder(String nodeName, boolean clientTransportSniff, String clusterName) {
        boolean isNullClusterName = Objects.isNull(clusterName);
        Settings.Builder builder = Settings.builder().put(NODE_NAME, nodeName).put(CLIENT_TRANSPORT_SNIFF, clientTransportSniff).put(CLIENT_TRANSPORT_IGNORE_CLUSTER_NAME, isNullClusterName);
        if (!isNullClusterName) {
            builder.put(CLUSTER_NAME, clusterName);
        }
        return builder;
    }

    public boolean isExists(String index) {
        IndicesExistsRequestBuilder indicesExistsRequestBuilder = this.admin().indices().prepareExists(new String[]{index});
        return ((IndicesExistsResponse)JMElasticsearchUtil.logRequestQueryAndReturn("isExists", indicesExistsRequestBuilder, indicesExistsRequestBuilder.execute())).isExists();
    }

    public boolean create(String index) {
        CreateIndexRequestBuilder createIndexRequestBuilder = this.admin().indices().prepareCreate(index);
        return ((CreateIndexResponse)JMElasticsearchUtil.logRequestQueryAndReturn("create", createIndexRequestBuilder, createIndexRequestBuilder.execute())).isAcknowledged();
    }

    public List<String> extractIdList(SearchResponse searchResponse) {
        return Arrays.stream(searchResponse.getHits().getHits()).map(SearchHit::getId).collect(Collectors.toList());
    }

    public List<String> getAllIdList(String index, String type) {
        return this.extractIdList(this.searchAll(index, type));
    }

    public List<String> extractIdList(String index, String type, QueryBuilder filterQueryBuilder) {
        return this.extractIdList(this.searchAllWithTargetCount(index, type, filterQueryBuilder));
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> getMappingsResponse(String ... indices) {
        GetMappingsRequestBuilder getMappingsRequestBuilder = this.admin().indices().prepareGetMappings(indices);
        return ((GetMappingsResponse)JMElasticsearchUtil.logRequestQueryAndReturn("getMappingsResponse", getMappingsRequestBuilder, getMappingsRequestBuilder.execute())).getMappings();
    }

    public Map<String, IndexStats> getAllIndicesStats() {
        IndicesStatsRequestBuilder indicesStatsRequestBuilder = this.admin().indices().prepareStats(new String[0]).all();
        return ((IndicesStatsResponse)JMElasticsearchUtil.logRequestQueryAndReturn("getAllIndicesStats", indicesStatsRequestBuilder, indicesStatsRequestBuilder.execute())).getIndices();
    }

    public Set<String> getAllIndices() {
        return this.getAllIndicesStats().keySet();
    }

    public List<String> getFilteredIndexList(String containedString) {
        return this.getAllIndices().stream().filter(index -> index.contains(containedString)).collect(Collectors.toList());
    }

    public GetResponse getQuery(GetRequestBuilder getRequestBuilder) {
        return (GetResponse)JMElasticsearchUtil.logRequestQueryAndReturn("getQuery", getRequestBuilder, getRequestBuilder.execute());
    }

    public UpdateResponse updateQuery(UpdateRequestBuilder updateRequestBuilder) {
        return (UpdateResponse)JMElasticsearchUtil.logRequestQueryAndReturn("updateQuery", updateRequestBuilder, updateRequestBuilder.execute());
    }

    public Optional<Map<String, ?>> getMappings(String index, String type) {
        try {
            return Optional.of(((MappingMetaData)((ImmutableOpenMap)this.getMappingsResponse(index).get((Object)index)).get((Object)type)).getSourceAsMap());
        }
        catch (Exception e) {
            return JMExceptionManager.handleExceptionAndReturnEmptyOptional((Logger)log, (Throwable)e, (String)"getMappings", (Object[])new Object[]{index, type});
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setBulkProcessor(int bulkActions, long bulkSizeKB, int flushIntervalSeconds) {
        this.jmESBulk.setBulkProcessor(bulkActions, bulkSizeKB, flushIntervalSeconds);
    }

    public void setBulkProcessor(BulkProcessor.Listener bulkProcessorListener, int bulkActions, long bulkSizeKB, int flushIntervalSeconds) {
        this.jmESBulk.setBulkProcessor(bulkProcessorListener, bulkActions, bulkSizeKB, flushIntervalSeconds);
    }

    public BulkProcessor.Builder getBulkProcessorBuilder(BulkProcessor.Listener bulkProcessorListener, Integer bulkActions, ByteSizeValue byteSizeValue, TimeValue flushInterval, Integer concurrentRequests, BackoffPolicy backoffPolicy) {
        return this.jmESBulk.getBulkProcessorBuilder(bulkProcessorListener, bulkActions, byteSizeValue, flushInterval, concurrentRequests, backoffPolicy);
    }

    public BulkProcessor buildBulkProcessor(BulkProcessor.Listener bulkProcessorListener, int bulkActions, long bulkSizeKB, int flushIntervalSeconds, Integer concurrentRequests, BackoffPolicy backoffPolicy) {
        return this.jmESBulk.buildBulkProcessor(bulkProcessorListener, bulkActions, bulkSizeKB, flushIntervalSeconds, concurrentRequests, backoffPolicy);
    }

    public BulkProcessor buildBulkProcessor(BulkProcessor.Listener bulkProcessorListener, int bulkActions, long bulkSizeKB, int flushIntervalSeconds) {
        return this.jmESBulk.buildBulkProcessor(bulkProcessorListener, bulkActions, bulkSizeKB, flushIntervalSeconds);
    }

    public void sendWithBulkProcessor(List<? extends Map<String, ?>> bulkSource, String index, String type) {
        this.jmESBulk.sendWithBulkProcessor(bulkSource, index, type);
    }

    public void sendWithBulkProcessor(Map<String, ?> source, String index, String type) {
        this.jmESBulk.sendWithBulkProcessor(source, index, type);
    }

    public void sendWithBulkProcessor(Map<String, ?> source, String index, String type, String id) {
        this.jmESBulk.sendWithBulkProcessor(source, index, type, id);
    }

    public void sendWithBulkProcessorAndObjectMapper(List<Object> bulkObject, String index, String type) {
        this.jmESBulk.sendWithBulkProcessorAndObjectMapper(bulkObject, index, type);
    }

    public void sendWithBulkProcessorAndObjectMapper(Object object, String index, String type) {
        this.jmESBulk.sendWithBulkProcessorAndObjectMapper(object, index, type);
    }

    public void sendWithBulkProcessorAndObjectMapper(Object object, String index, String type, String id) {
        this.jmESBulk.sendWithBulkProcessorAndObjectMapper(object, index, type, id);
    }

    public void sendWithBulkProcessor(List<IndexRequest> indexRequestList) {
        this.jmESBulk.sendWithBulkProcessor(indexRequestList);
    }

    public void sendWithBulkProcessor(IndexRequest indexRequest) {
        this.jmESBulk.sendWithBulkProcessor(indexRequest);
    }

    public void closeBulkProcessor() {
        this.jmESBulk.closeBulkProcessor();
    }

    public void sendBulkDataAsync(List<? extends Map<String, ?>> bulkSourceList, String index, String type) {
        this.jmESBulk.sendBulkDataAsync(bulkSourceList, index, type);
    }

    public void sendBulkDataAsync(List<? extends Map<String, ?>> bulkSourceList, String index, String type, ActionListener<BulkResponse> bulkResponseActionListener) {
        this.jmESBulk.sendBulkDataAsync(bulkSourceList, index, type, bulkResponseActionListener);
    }

    public void sendBulkDataWithObjectMapperAsync(List<Object> objectBulkData, String index, String type) {
        this.jmESBulk.sendBulkDataWithObjectMapperAsync(objectBulkData, index, type);
    }

    public void sendBulkDataWithObjectMapperAsync(List<Object> objectBulkData, String index, String type, ActionListener<BulkResponse> bulkResponseActionListener) {
        this.jmESBulk.sendBulkDataWithObjectMapperAsync(objectBulkData, index, type, bulkResponseActionListener);
    }

    public BulkRequestBuilder buildBulkIndexRequestBuilder(List<IndexRequestBuilder> indexRequestBuilderList) {
        return this.jmESBulk.buildBulkIndexRequestBuilder(indexRequestBuilderList);
    }

    public BulkRequestBuilder buildDeleteBulkRequestBuilder(List<DeleteRequestBuilder> deleteRequestBuilderList) {
        return this.jmESBulk.buildDeleteBulkRequestBuilder(deleteRequestBuilderList);
    }

    public BulkRequestBuilder buildUpdateBulkRequestBuilder(List<UpdateRequestBuilder> updateRequestBuilderList) {
        return this.jmESBulk.buildUpdateBulkRequestBuilder(updateRequestBuilderList);
    }

    public void executeBulkRequestAsync(BulkRequestBuilder bulkRequestBuilder) {
        this.jmESBulk.executeBulkRequestAsync(bulkRequestBuilder);
    }

    public void executeBulkRequestAsync(BulkRequestBuilder bulkRequestBuilder, ActionListener<BulkResponse> bulkResponseActionListener) {
        this.jmESBulk.executeBulkRequestAsync(bulkRequestBuilder, bulkResponseActionListener);
    }

    public BulkResponse executeBulkRequest(BulkRequestBuilder bulkRequestBuilder) {
        return this.jmESBulk.executeBulkRequest(bulkRequestBuilder);
    }

    public boolean deleteBulkDocs(String index, String type) {
        return this.jmESBulk.deleteBulkDocs(index, type);
    }

    public BulkResponse deleteBulkDocs(String index, String type, QueryBuilder filterQueryBuilder) {
        return this.jmESBulk.deleteBulkDocs(index, type, filterQueryBuilder);
    }

    public boolean deleteBulkDocs(List<String> indexList, List<String> typeList, QueryBuilder filterQueryBuilder) {
        return this.jmESBulk.deleteBulkDocs(indexList, typeList, filterQueryBuilder);
    }

    public void deleteBulkDocsAsync(String index, String type) {
        this.jmESBulk.deleteBulkDocsAsync(index, type);
    }

    public void deleteBulkDocsAsync(String index, String type, ActionListener<BulkResponse> bulkResponseActionListener) {
        this.jmESBulk.deleteBulkDocsAsync(index, type, bulkResponseActionListener);
    }

    public void deleteBulkDocsAsync(String index, String type, QueryBuilder filterQueryBuilder) {
        this.jmESBulk.deleteBulkDocsAsync(index, type, filterQueryBuilder);
    }

    public void deleteBulkDocsAsync(List<String> indexList, List<String> typeList, QueryBuilder filterQueryBuilder) {
        this.jmESBulk.deleteBulkDocsAsync(indexList, typeList, filterQueryBuilder);
    }

    public void deleteBulkDocsAsync(String index, String type, QueryBuilder filterQueryBuilder, ActionListener<BulkResponse> bulkResponseActionListener) {
        this.jmESBulk.deleteBulkDocsAsync(index, type, filterQueryBuilder, bulkResponseActionListener);
    }

    public void deleteBulkDocsAsync(List<String> indexList, List<String> typeList, QueryBuilder filterQueryBuilder, ActionListener<BulkResponse> bulkResponseActionListener) {
        this.jmESBulk.deleteBulkDocsAsync(indexList, typeList, filterQueryBuilder, bulkResponseActionListener);
    }

    public IndexResponse indexQuery(IndexRequestBuilder indexRequestBuilder) {
        return this.jmESIndex.indexQuery(indexRequestBuilder);
    }

    public ActionFuture<IndexResponse> indexQueryAsync(IndexRequestBuilder indexRequestBuilder) {
        return this.jmESIndex.indexQueryAsync(indexRequestBuilder);
    }

    public UpdateResponse upsertQuery(UpdateRequestBuilder updateRequestBuilder) {
        return this.jmESIndex.upsertQuery(updateRequestBuilder);
    }

    public ActionFuture<UpdateResponse> upsertQueryAsync(UpdateRequestBuilder updateRequestBuilder) {
        return this.jmESIndex.upsertQueryAsync(updateRequestBuilder);
    }

    public UpdateResponse upsertData(Map<String, ?> source, String index, String type, String id) {
        return this.jmESIndex.upsertData(source, index, type, id);
    }

    public ActionFuture<UpdateResponse> upsertDataAsync(Map<String, ?> source, String index, String type, String id) {
        return this.jmESIndex.upsertDataAsync(source, index, type, id);
    }

    public UpdateResponse upsertData(String jsonSource, String index, String type, String id) {
        return this.jmESIndex.upsertData(jsonSource, index, type, id);
    }

    public ActionFuture<UpdateResponse> upsertDataAsync(String jsonSource, String index, String type, String id) {
        return this.jmESIndex.upsertDataAsync(jsonSource, index, type, id);
    }

    public UpdateResponse upsertDataWithObjectMapper(Object sourceObject, String index, String type, String id) {
        return this.jmESIndex.upsertDataWithObjectMapper(sourceObject, index, type, id);
    }

    public ActionFuture<UpdateResponse> upsertDataASyncWithObjectMapper(Object sourceObject, String index, String type, String id) {
        return this.jmESIndex.upsertDataASyncWithObjectMapper(sourceObject, index, type, id);
    }

    public IndexResponse sendData(Map<String, ?> source, String index, String type, String id) {
        return this.jmESIndex.sendData(source, index, type, id);
    }

    public String sendData(Map<String, ?> source, String index, String type) {
        return this.jmESIndex.sendData(source, index, type);
    }

    public IndexResponse sendData(String jsonSource, String index, String type, String id) {
        return this.jmESIndex.sendData(jsonSource, index, type, id);
    }

    public String sendData(String jsonSource, String index, String type) {
        return this.jmESIndex.sendData(jsonSource, index, type);
    }

    public IndexResponse sendDataWithObjectMapper(Object sourceObject, String index, String type, String id) {
        return this.jmESIndex.sendDataWithObjectMapper(sourceObject, index, type, id);
    }

    public String sendDataWithObjectMapper(Object sourceObject, String index, String type) {
        return this.jmESIndex.sendDataWithObjectMapper(sourceObject, index, type);
    }

    public ActionFuture<IndexResponse> sendDataAsync(Map<String, ?> source, String index, String type, String id) {
        return this.jmESIndex.sendDataAsync(source, index, type, id);
    }

    public ActionFuture<IndexResponse> sendDataAsync(Map<String, ?> source, String index, String type) {
        return this.jmESIndex.sendDataAsync(source, index, type);
    }

    public ActionFuture<IndexResponse> sendDataAsync(String jsonSource, String index, String type, String id) {
        return this.jmESIndex.sendDataAsync(jsonSource, index, type, id);
    }

    public ActionFuture<IndexResponse> sendDataAsync(String jsonSource, String index, String type) {
        return this.jmESIndex.sendDataAsync(jsonSource, index, type);
    }

    public ActionFuture<IndexResponse> sendDataAsyncWithObjectMapper(Object sourceObject, String index, String type, String id) {
        return this.jmESIndex.sendDataAsyncWithObjectMapper(sourceObject, index, type, id);
    }

    public ActionFuture<IndexResponse> sendDataAsyncWithObjectMapper(Object sourceObject, String index, String type) {
        return this.jmESIndex.sendDataAsyncWithObjectMapper(sourceObject, index, type);
    }

    public SearchResponse searchWithTargetCount(SearchRequestBuilder searchRequestBuilder) {
        return this.jmESSearchAndCount.searchWithTargetCount(searchRequestBuilder);
    }

    public SearchResponse searchWithTargetCount(SearchRequestBuilder searchRequestBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchWithTargetCount(searchRequestBuilder, aggregationBuilders);
    }

    public SearchResponse searchWithTargetCount(boolean isSetExplain, String[] indices, String[] types, QueryBuilder[] mustConditionQueryBuilders, QueryBuilder[] filterConditionQueryBuilders) {
        return this.jmESSearchAndCount.searchWithTargetCount(isSetExplain, indices, types, mustConditionQueryBuilders, filterConditionQueryBuilders);
    }

    public SearchResponse searchWithTargetCount(boolean isSetExplain, String[] indices, String[] types, QueryBuilder[] mustConditionQueryBuilders, QueryBuilder[] filterConditionQueryBuilders, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchWithTargetCount(isSetExplain, indices, types, mustConditionQueryBuilders, filterConditionQueryBuilders, aggregationBuilders);
    }

    public SearchRequestBuilder getSearchRequestBuilder(QueryBuilder queryBuilder, String ... indices) {
        return this.jmESSearchAndCount.getSearchRequestBuilder(queryBuilder, indices);
    }

    public SearchRequestBuilder getSearchRequestBuilder(QueryBuilder queryBuilder, AggregationBuilder[] aggregationBuilders, String ... indices) {
        return this.jmESSearchAndCount.getSearchRequestBuilder(queryBuilder, aggregationBuilders, indices);
    }

    public SearchRequestBuilder getSearchRequestBuilder(String[] indices, String[] types, QueryBuilder queryBuilder) {
        return this.jmESSearchAndCount.getSearchRequestBuilder(indices, types, queryBuilder);
    }

    public SearchRequestBuilder getSearchRequestBuilder(String[] indices, String[] types, QueryBuilder queryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.getSearchRequestBuilder(indices, types, queryBuilder, aggregationBuilders);
    }

    public SearchRequestBuilder getSearchRequestBuilder(SearchRequestBuilder searchRequestBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.getSearchRequestBuilder(searchRequestBuilder, aggregationBuilders);
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, String[] indices, String[] types, QueryBuilder[] mustConditionQueryBuilders, QueryBuilder[] filterConditionQueryBuilders, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.getSearchRequestBuilder(isSetExplain, indices, types, mustConditionQueryBuilders, filterConditionQueryBuilders, aggregationBuilders);
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, String[] indices) {
        return this.jmESSearchAndCount.getSearchRequestBuilder(isSetExplain, indices);
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, String[] indices, String[] types) {
        return this.jmESSearchAndCount.getSearchRequestBuilder(isSetExplain, indices, types);
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, String[] indices, String[] types, QueryBuilder queryBuilder) {
        return this.jmESSearchAndCount.getSearchRequestBuilder(isSetExplain, indices, types, queryBuilder);
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, QueryBuilder queryBuilder, String ... indices) {
        return this.jmESSearchAndCount.getSearchRequestBuilder(isSetExplain, queryBuilder, indices);
    }

    public SearchRequestBuilder getSearchRequestBuilder(boolean isSetExplain, String[] indices, String[] types, QueryBuilder queryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.getSearchRequestBuilder(isSetExplain, indices, types, queryBuilder, aggregationBuilders);
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String[] indices, String[] types, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.getSearchRequestBuilderWithMatchAll(isSetExplain, indices, types, filterQueryBuilder, aggregationBuilders);
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String[] indices, String[] types) {
        return this.jmESSearchAndCount.getSearchRequestBuilderWithMatchAll(isSetExplain, indices, types);
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String[] indices) {
        return this.jmESSearchAndCount.getSearchRequestBuilderWithMatchAll(isSetExplain, indices);
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String[] indices, String[] types, QueryBuilder filterQueryBuilder) {
        return this.jmESSearchAndCount.getSearchRequestBuilderWithMatchAll(isSetExplain, indices, types, filterQueryBuilder);
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String index, String type, QueryBuilder filterQueryBuilder) {
        return this.jmESSearchAndCount.getSearchRequestBuilderWithMatchAll(isSetExplain, index, type, filterQueryBuilder);
    }

    public SearchRequestBuilder getSearchRequestBuilderWithMatchAll(boolean isSetExplain, String[] indices, String[] types, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.getSearchRequestBuilderWithMatchAll(isSetExplain, indices, types, aggregationBuilders);
    }

    public SearchResponse searchAll(String[] indices, String[] types, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchAll(indices, types, aggregationBuilders);
    }

    public SearchResponse searchAll(String[] indices, String[] types) {
        return this.jmESSearchAndCount.searchAll(indices, types);
    }

    public SearchResponse searchAll(String[] indices, String type) {
        return this.jmESSearchAndCount.searchAll(indices, type);
    }

    public SearchResponse searchAll(String ... indices) {
        return this.jmESSearchAndCount.searchAll(indices);
    }

    public SearchResponse searchAll(String index, String type, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchAll(index, type, filterQueryBuilder, aggregationBuilders);
    }

    public SearchResponse searchAll(String index, String type, QueryBuilder filterQueryBuilder) {
        return this.jmESSearchAndCount.searchAll(index, type, filterQueryBuilder);
    }

    public SearchResponse searchAll(String index, String type, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchAll(index, type, aggregationBuilders);
    }

    public SearchResponse searchAll(String index, String type) {
        return this.jmESSearchAndCount.searchAll(index, type);
    }

    public SearchResponse searchAll(String[] indices, String[] types, QueryBuilder filterQueryBuilder) {
        return this.jmESSearchAndCount.searchAll(indices, types, filterQueryBuilder);
    }

    public SearchResponse searchAll(String[] indices, String[] types, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchAll(indices, types, filterQueryBuilder, aggregationBuilders);
    }

    public SearchResponse searchAll(boolean isSetExplain, String[] indices) {
        return this.jmESSearchAndCount.searchAll(isSetExplain, indices);
    }

    public SearchResponse searchAll(boolean isSetExplain, String[] indices, String[] types) {
        return this.jmESSearchAndCount.searchAll(isSetExplain, indices, types);
    }

    public SearchResponse searchAll(boolean isSetExplain, String[] indices, String[] types, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchAll(isSetExplain, indices, types, aggregationBuilders);
    }

    public SearchResponse searchAll(boolean isSetExplain, String[] indices, String[] types, QueryBuilder filterQueryBuilder) {
        return this.jmESSearchAndCount.searchAll(isSetExplain, indices, types, filterQueryBuilder);
    }

    public SearchResponse searchAll(boolean isSetExplain, String[] indices, String[] types, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchAll(isSetExplain, indices, types, filterQueryBuilder, aggregationBuilders);
    }

    public SearchResponse searchAllWithTargetCount(String[] indices, String[] types) {
        return this.jmESSearchAndCount.searchAllWithTargetCount(indices, types);
    }

    public SearchResponse searchAllWithTargetCount(String[] indices, String[] types, QueryBuilder filterQueryBuilder) {
        return this.jmESSearchAndCount.searchAllWithTargetCount(indices, types, filterQueryBuilder);
    }

    public SearchResponse searchAllWithTargetCount(String[] indices, String[] types, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchAllWithTargetCount(indices, types, aggregationBuilders);
    }

    public SearchResponse searchAllWithTargetCount(String index, String type, QueryBuilder filterQueryBuilder) {
        return this.jmESSearchAndCount.searchAllWithTargetCount(index, type, filterQueryBuilder);
    }

    public SearchResponse searchAllWithTargetCount(String index, String type, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchAllWithTargetCount(index, type, aggregationBuilders);
    }

    public SearchResponse searchAllWithTargetCount(String index, String type) {
        return this.jmESSearchAndCount.searchAllWithTargetCount(index, type);
    }

    public SearchResponse searchAllWithTargetCount(String ... indices) {
        return this.jmESSearchAndCount.searchAllWithTargetCount(indices);
    }

    public SearchResponse searchAllWithTargetCount(String index, String type, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchAllWithTargetCount(index, type, filterQueryBuilder, aggregationBuilders);
    }

    public SearchResponse searchAllWithTargetCount(String[] indices, String[] types, QueryBuilder filterQueryBuilder, AggregationBuilder[] aggregationBuilders) {
        return this.jmESSearchAndCount.searchAllWithTargetCount(indices, types, filterQueryBuilder, aggregationBuilders);
    }

    public SearchResponse searchQuery(SearchRequestBuilder searchRequestBuilder) {
        return this.jmESSearchAndCount.searchQuery(searchRequestBuilder);
    }

    public SearchResponse searchQuery(SearchRequestBuilder searchRequestBuilder, long timeoutMillis) {
        return this.jmESSearchAndCount.searchQuery(searchRequestBuilder, timeoutMillis);
    }

    public long countQuery(SearchRequestBuilder countRequestBuilder) {
        return this.jmESSearchAndCount.countQuery(countRequestBuilder);
    }

    public long countQuery(SearchRequestBuilder countRequestBuilder, long timeoutMillis) {
        return this.jmESSearchAndCount.countQuery(countRequestBuilder, timeoutMillis);
    }

    public long count(String ... indices) {
        return this.jmESSearchAndCount.count(indices);
    }

    public long count(String[] indices, String[] types) {
        return this.jmESSearchAndCount.count(indices, types);
    }

    public long count(String[] indices, String[] types, QueryBuilder filterQueryBuilder) {
        return this.jmESSearchAndCount.count(indices, types, filterQueryBuilder);
    }

    public int getDefaultHitsCount() {
        return this.jmESSearchAndCount.getDefaultHitsCount();
    }

    public void setDefaultHitsCount(int defaultHitsCount) {
        this.jmESSearchAndCount.setDefaultHitsCount(defaultHitsCount);
    }

    public DeleteResponse deleteQuery(DeleteRequestBuilder deleteRequestBuilder) {
        return this.jmESDelete.deleteQuery(deleteRequestBuilder);
    }

    public AcknowledgedResponse deleteIndices(String ... indices) {
        return this.jmESDelete.deleteIndices(indices);
    }

    public DeleteResponse deleteDoc(String index, String type, String id) {
        return this.jmESDelete.deleteDoc(index, type, id);
    }
}

