package kim.jeonghyeon.db

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.Long
import kotlin.String

interface UserQueries : Transacter {
  fun <T : Any> selectAll(mapper: (
    id: Long,
    signId: String,
    password: String?,
    authType: String,
    oauthName: String?,
    extra: String?
  ) -> T): Query<T>

  fun selectAll(): Query<User>

  fun <T : Any> selectOneById(id: Long, mapper: (
    id: Long,
    signId: String,
    password: String?,
    authType: String,
    oauthName: String?,
    extra: String?
  ) -> T): Query<T>

  fun selectOneById(id: Long): Query<User>

  fun <T : Any> selectOneBySignIdAndAuthType(
    signId: String,
    authType: String,
    oauthName: String?,
    mapper: (
      id: Long,
      signId: String,
      password: String?,
      authType: String,
      oauthName: String?,
      extra: String?
    ) -> T
  ): Query<T>

  fun selectOneBySignIdAndAuthType(
    signId: String,
    authType: String,
    oauthName: String?
  ): Query<User>

  fun insert(
    signId: String,
    password: String?,
    authType: String,
    oauthName: String?,
    extra: String?
  )
}
