package kim.jeonghyeon.db

import com.squareup.sqldelight.Transacter
import com.squareup.sqldelight.db.SqlDriver
import kim.jeonghyeon.db.kotlinsimplearchitectureclient.newInstance
import kim.jeonghyeon.db.kotlinsimplearchitectureclient.schema

interface SimpleDB : Transacter {
  val preferenceForAllQueries: PreferenceForAllQueries

  val preferencePerUserQueries: PreferencePerUserQueries

  val userQueries: UserQueries

  companion object {
    val Schema: SqlDriver.Schema
      get() = SimpleDB::class.schema

    operator fun invoke(driver: SqlDriver): SimpleDB = SimpleDB::class.newInstance(driver)}
}
