package kim.jeonghyeon.db.kotlinsimplearchitectureclient

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.TransacterImpl
import com.squareup.sqldelight.db.SqlCursor
import com.squareup.sqldelight.db.SqlDriver
import com.squareup.sqldelight.internal.copyOnWriteList
import kim.jeonghyeon.db.PreferenceForAll
import kim.jeonghyeon.db.PreferenceForAllQueries
import kim.jeonghyeon.db.PreferencePerUser
import kim.jeonghyeon.db.PreferencePerUserQueries
import kim.jeonghyeon.db.SimpleDB
import kim.jeonghyeon.db.User
import kim.jeonghyeon.db.UserQueries
import kotlin.Any
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.collections.MutableList
import kotlin.jvm.JvmField
import kotlin.reflect.KClass

internal val KClass<SimpleDB>.schema: SqlDriver.Schema
  get() = SimpleDBImpl.Schema

internal fun KClass<SimpleDB>.newInstance(driver: SqlDriver): SimpleDB = SimpleDBImpl(driver)

private class SimpleDBImpl(
  driver: SqlDriver
) : TransacterImpl(driver), SimpleDB {
  override val preferenceForAllQueries: PreferenceForAllQueriesImpl =
      PreferenceForAllQueriesImpl(this, driver)

  override val preferencePerUserQueries: PreferencePerUserQueriesImpl =
      PreferencePerUserQueriesImpl(this, driver)

  override val userQueries: UserQueriesImpl = UserQueriesImpl(this, driver)

  object Schema : SqlDriver.Schema {
    override val version: Int
      get() = 1

    override fun create(driver: SqlDriver) {
      driver.execute(null, """
          |CREATE TABLE preferencePerUser (
          |  key TEXT NOT NULL,
          |  id INTEGER NOT NULL,
          |  value TEXT,
          |  PRIMARY KEY (key, id)
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE user (
          |  id INTEGER PRIMARY KEY AUTOINCREMENT,
          |  signId TEXT NOT NULL,
          |  password TEXT,
          |  authType TEXT NOT NULL,
          |  oauthName TEXT,
          |  extra TEXT
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE preferenceForAll (
          |  key TEXT PRIMARY KEY,
          |  value TEXT
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE INDEX idx_user_signId
          |ON user (signId)
          """.trimMargin(), 0)
    }

    override fun migrate(
      driver: SqlDriver,
      oldVersion: Int,
      newVersion: Int
    ) {
    }
  }
}

private class PreferencePerUserQueriesImpl(
  private val database: SimpleDBImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), PreferencePerUserQueries {
  internal val get: MutableList<Query<*>> = copyOnWriteList()

  override fun <T : Any> get(
    key: String,
    id: Long,
    mapper: (
      key: String,
      id: Long,
      value: String?
    ) -> T
  ): Query<T> = GetQuery(key, id) { cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getLong(1)!!,
      cursor.getString(2)
    )
  }

  override fun get(key: String, id: Long): Query<PreferencePerUser> = get(key, id,
      ::PreferencePerUser)

  override fun set(
    key: String,
    id: Long,
    value: String?
  ) {
    driver.execute(1783138810, """
    |REPLACE INTO preferencePerUser(key, id, value)
    |VALUES (?, ?, ?)
    """.trimMargin(), 3) {
      bindString(1, key)
      bindLong(2, id)
      bindString(3, value)
    }
    notifyQueries(1783138810, {database.preferencePerUserQueries.get})
  }

  override fun delete(key: String, id: Long) {
    driver.execute(903196947, """
    |DELETE FROM preferencePerUser
    |WHERE key = ? AND id = ?
    """.trimMargin(), 2) {
      bindString(1, key)
      bindLong(2, id)
    }
    notifyQueries(903196947, {database.preferencePerUserQueries.get})
  }

  override fun deleteAll(id: Long) {
    driver.execute(-829795442, """
    |DELETE FROM preferencePerUser
    |WHERE id = ?
    """.trimMargin(), 1) {
      bindLong(1, id)
    }
    notifyQueries(-829795442, {database.preferencePerUserQueries.get})
  }

  private inner class GetQuery<out T : Any>(
    @JvmField
    val key: String,
    @JvmField
    val id: Long,
    mapper: (SqlCursor) -> T
  ) : Query<T>(get, mapper) {
    override fun execute(): SqlCursor = driver.executeQuery(1783127278, """
    |SELECT *
    |FROM preferencePerUser
    |WHERE key = ? AND id = ?
    """.trimMargin(), 2) {
      bindString(1, key)
      bindLong(2, id)
    }

    override fun toString(): String = "PreferencePerUser.sq:get"
  }
}

private class UserQueriesImpl(
  private val database: SimpleDBImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), UserQueries {
  internal val selectAll: MutableList<Query<*>> = copyOnWriteList()

  internal val selectOneById: MutableList<Query<*>> = copyOnWriteList()

  internal val selectOneBySignIdAndAuthType: MutableList<Query<*>> = copyOnWriteList()

  override fun <T : Any> selectAll(mapper: (
    id: Long,
    signId: String,
    password: String?,
    authType: String,
    oauthName: String?,
    extra: String?
  ) -> T): Query<T> = Query(1079137465, selectAll, driver, "User.sq", "selectAll", """
  |SELECT *
  |FROM user
  """.trimMargin()) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2),
      cursor.getString(3)!!,
      cursor.getString(4),
      cursor.getString(5)
    )
  }

  override fun selectAll(): Query<User> = selectAll(::User)

  override fun <T : Any> selectOneById(id: Long, mapper: (
    id: Long,
    signId: String,
    password: String?,
    authType: String,
    oauthName: String?,
    extra: String?
  ) -> T): Query<T> = SelectOneByIdQuery(id) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2),
      cursor.getString(3)!!,
      cursor.getString(4),
      cursor.getString(5)
    )
  }

  override fun selectOneById(id: Long): Query<User> = selectOneById(id, ::User)

  override fun <T : Any> selectOneBySignIdAndAuthType(
    signId: String,
    authType: String,
    oauthName: String?,
    mapper: (
      id: Long,
      signId: String,
      password: String?,
      authType: String,
      oauthName: String?,
      extra: String?
    ) -> T
  ): Query<T> = SelectOneBySignIdAndAuthTypeQuery(signId, authType, oauthName) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2),
      cursor.getString(3)!!,
      cursor.getString(4),
      cursor.getString(5)
    )
  }

  override fun selectOneBySignIdAndAuthType(
    signId: String,
    authType: String,
    oauthName: String?
  ): Query<User> = selectOneBySignIdAndAuthType(signId, authType, oauthName, ::User)

  override fun insert(
    signId: String,
    password: String?,
    authType: String,
    oauthName: String?,
    extra: String?
  ) {
    driver.execute(473679237, """
    |INSERT INTO user(signId, password, authType, oauthName, extra)
    |VALUES (?, ?, ?, ?, ?)
    """.trimMargin(), 5) {
      bindString(1, signId)
      bindString(2, password)
      bindString(3, authType)
      bindString(4, oauthName)
      bindString(5, extra)
    }
    notifyQueries(473679237, {database.userQueries.selectAll + database.userQueries.selectOneById +
        database.userQueries.selectOneBySignIdAndAuthType})
  }

  private inner class SelectOneByIdQuery<out T : Any>(
    @JvmField
    val id: Long,
    mapper: (SqlCursor) -> T
  ) : Query<T>(selectOneById, mapper) {
    override fun execute(): SqlCursor = driver.executeQuery(1492478576, """
    |SELECT *
    |FROM user
    |WHERE id = ?
    """.trimMargin(), 1) {
      bindLong(1, id)
    }

    override fun toString(): String = "User.sq:selectOneById"
  }

  private inner class SelectOneBySignIdAndAuthTypeQuery<out T : Any>(
    @JvmField
    val signId: String,
    @JvmField
    val authType: String,
    @JvmField
    val oauthName: String?,
    mapper: (SqlCursor) -> T
  ) : Query<T>(selectOneBySignIdAndAuthType, mapper) {
    override fun execute(): SqlCursor = driver.executeQuery(null, """
    |SELECT *
    |FROM user
    |WHERE signId = ? AND authType = ? AND oauthName ${ if (oauthName == null) "IS" else "=" } ?
    """.trimMargin(), 3) {
      bindString(1, signId)
      bindString(2, authType)
      bindString(3, oauthName)
    }

    override fun toString(): String = "User.sq:selectOneBySignIdAndAuthType"
  }
}

private class PreferenceForAllQueriesImpl(
  private val database: SimpleDBImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), PreferenceForAllQueries {
  internal val get: MutableList<Query<*>> = copyOnWriteList()

  override fun <T : Any> get(key: String, mapper: (key: String, value: String?) -> T): Query<T> =
      GetQuery(key) { cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getString(1)
    )
  }

  override fun get(key: String): Query<PreferenceForAll> = get(key, ::PreferenceForAll)

  override fun set(key: String, value: String?) {
    driver.execute(-652343410, """
    |REPLACE INTO preferenceForAll(key, value)
    |VALUES (?, ?)
    """.trimMargin(), 2) {
      bindString(1, key)
      bindString(2, value)
    }
    notifyQueries(-652343410, {database.preferenceForAllQueries.get})
  }

  override fun delete(key: String) {
    driver.execute(334912255, """
    |DELETE FROM preferenceForAll
    |WHERE key = ?
    """.trimMargin(), 1) {
      bindString(1, key)
    }
    notifyQueries(334912255, {database.preferenceForAllQueries.get})
  }

  private inner class GetQuery<out T : Any>(
    @JvmField
    val key: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(get, mapper) {
    override fun execute(): SqlCursor = driver.executeQuery(-652354942, """
    |SELECT *
    |FROM preferenceForAll
    |WHERE key = ?
    """.trimMargin(), 1) {
      bindString(1, key)
    }

    override fun toString(): String = "PreferenceForAll.sq:get"
  }
}
