package kim.jeonghyeon.db

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.Long
import kotlin.String

interface PreferencePerUserQueries : Transacter {
  fun <T : Any> get(
    key: String,
    id: Long,
    mapper: (
      key: String,
      id: Long,
      value: String?
    ) -> T
  ): Query<T>

  fun get(key: String, id: Long): Query<PreferencePerUser>

  fun set(
    key: String,
    id: Long,
    value: String?
  )

  fun delete(key: String, id: Long)

  fun deleteAll(id: Long)
}
