/*
 * Decompiled with CFR 0.152.
 */
package kim.jeonghyeon.androidlibrary.util;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.content.Context;
import java.util.ArrayList;
import java.util.List;
import kim.jeonghyeon.androidlibrary.util.ValidationUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lkim/jeonghyeon/androidlibrary/util/SystemUtil;", "", "()V", "getEmailList", "", "", "context", "Landroid/content/Context;", "kotlin-simple-architecture_release"})
public final class SystemUtil {
    @NotNull
    public static final SystemUtil INSTANCE;

    @SuppressLint(value={"MissingPermission"})
    @NotNull
    public final List<String> getEmailList(@NotNull Context context) {
        Account[] accounts;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ArrayList<String> emailList = new ArrayList<String>();
        AccountManager accountManager = AccountManager.get((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)accountManager, (String)"AccountManager.get(context)");
        Account[] accountArray = accountManager.getAccounts();
        Intrinsics.checkNotNullExpressionValue((Object)accountArray, (String)"AccountManager.get(context).accounts");
        for (Account account : accounts = accountArray) {
            String string = account.name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"account.name");
            if (!ValidationUtil.INSTANCE.isValidEmail(string)) continue;
            emailList.add(account.name);
        }
        return emailList;
    }

    private SystemUtil() {
    }

    static {
        SystemUtil systemUtil;
        INSTANCE = systemUtil = new SystemUtil();
    }
}

