/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.MainFrame;
import org.apache.jmeter.gui.util.JMeterToolBar;
import org.jmeterplugins.repository.PluginIcon;
import org.jmeterplugins.repository.PluginManager;
import org.jmeterplugins.repository.PluginManagerDialog;
import org.jmeterplugins.repository.logging.LoggingHooker;
import org.jmeterplugins.repository.util.ComponentFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManagerMenuItem
extends JMenuItem
implements ActionListener {
    private static final long serialVersionUID = -8708638472918746046L;
    private static final Logger log = LoggerFactory.getLogger(PluginManagerMenuItem.class);
    private static PluginManagerDialog dialog;
    private final PluginManager mgr;

    public PluginManagerMenuItem() {
        super("Plugins Manager");
        this.addActionListener(this);
        this.mgr = new PluginManager();
        LoggingHooker hooker = new LoggingHooker(this.mgr);
        hooker.hook();
        final JButton toolbarButton = this.getToolbarButton();
        this.addToolbarIcon(toolbarButton);
        this.setIcon(PluginIcon.getPluginsIcon(false));
        new Thread("repo-downloader-thread"){

            @Override
            public void run() {
                try {
                    PluginManagerMenuItem.this.mgr.load();
                }
                catch (Throwable e) {
                    log.warn("Failed to load plugin updates info", e);
                }
                if (PluginManagerMenuItem.this.mgr.hasAnyUpdates()) {
                    PluginManagerMenuItem.this.setText("Plugins Manager (has upgrades)");
                    log.info("Plugins Manager has upgrades: " + Arrays.toString(PluginManagerMenuItem.this.mgr.getUpgradablePlugins().toArray()));
                }
                boolean hasAnyUpdates = PluginManagerMenuItem.this.mgr.hasAnyUpdates();
                PluginManagerMenuItem.this.setIcon(PluginIcon.getPluginsIcon(hasAnyUpdates));
                toolbarButton.setIcon(PluginIcon.getIcon22Px(hasAnyUpdates));
                toolbarButton.setToolTipText(hasAnyUpdates ? "Plugins Manager (has upgrades)" : "Plugins Manager");
            }
        }.start();
    }

    private void addToolbarIcon(final Component toolbarButton) {
        GuiPackage instance = GuiPackage.getInstance();
        if (instance != null) {
            final MainFrame mf = instance.getMainFrame();
            final ComponentFinder<JMeterToolBar> finder = new ComponentFinder<JMeterToolBar>(JMeterToolBar.class);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JMeterToolBar toolbar = null;
                    while (toolbar == null) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            log.debug("Did not add btn to toolbar", (Throwable)e);
                        }
                        log.debug("Searching for toolbar");
                        toolbar = (JMeterToolBar)finder.findComponentIn((Container)mf);
                    }
                    int pos = toolbar.getComponents().length - 1;
                    toolbarButton.setSize(toolbar.getComponent(pos).getSize());
                    toolbar.add(toolbarButton, pos + 1);
                }
            });
        }
    }

    private JButton getToolbarButton() {
        boolean hasAnyUpdates = this.mgr.hasAnyUpdates();
        JButton button = new JButton(PluginIcon.getIcon22Px(hasAnyUpdates));
        button.setToolTipText(hasAnyUpdates ? "Plugins Manager (has upgrades)" : "Plugins Manager");
        button.addActionListener(this);
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (dialog == null) {
            dialog = new PluginManagerDialog(this.mgr);
        }
        dialog.pack();
        dialog.setVisible(true);
    }
}

