/*
 * Decompiled with CFR 0.152.
 */
package ke.tang.ruler;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.DrawableRes;
import android.view.View;
import java.util.UUID;
import java.util.WeakHashMap;
import ke.tang.ruler.ClickableMarker;

public class DrawableMarker
extends ClickableMarker {
    private static WeakHashMap<String, Drawable> sDrawableCaches = new WeakHashMap();
    private transient Drawable mDrawable;
    @DrawableRes
    private int mDrawableRes;
    private int mValue;
    private String mDrawableCacheKey = UUID.randomUUID().toString();
    public static final Parcelable.Creator<DrawableMarker> CREATOR = new Parcelable.Creator<DrawableMarker>(){

        public DrawableMarker createFromParcel(Parcel source) {
            return new DrawableMarker(source);
        }

        public DrawableMarker[] newArray(int size) {
            return new DrawableMarker[size];
        }
    };

    public DrawableMarker(@DrawableRes int res, int value) {
        this.mDrawableRes = res;
        this.mValue = value;
    }

    public DrawableMarker(Drawable drawable, int value) {
        this.mDrawable = drawable;
        this.mValue = value;
    }

    @Override
    public void onDraw(Canvas canvas) {
        if (null != this.mDrawable) {
            this.mDrawable.setBounds(0, 0, this.mDrawable.getIntrinsicWidth(), this.mDrawable.getIntrinsicHeight());
            this.mDrawable.draw(canvas);
        }
    }

    @Override
    public void onAttach(View v) {
        super.onAttach(v);
        if (0 != this.mDrawableRes) {
            this.mDrawable = v.getContext().getResources().getDrawable(this.mDrawableRes);
        }
    }

    @Override
    public void getBounds(Rect rect) {
        if (null != this.mDrawable) {
            rect.set(0, 0, this.mDrawable.getIntrinsicWidth(), this.mDrawable.getIntrinsicHeight());
        }
    }

    @Override
    public int value() {
        return this.mValue;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mDrawableRes);
        dest.writeInt(this.mValue);
        dest.writeString(this.mDrawableCacheKey);
        if (0 == this.mDrawableRes && null != this.mDrawable) {
            sDrawableCaches.put(this.mDrawableCacheKey, this.mDrawable);
        }
    }

    protected DrawableMarker(Parcel in) {
        this.mDrawableRes = in.readInt();
        this.mValue = in.readInt();
        this.mDrawableCacheKey = in.readString();
        if (0 == this.mDrawableRes) {
            this.mDrawable = sDrawableCaches.get(this.mDrawableCacheKey);
            sDrawableCaches.remove(this.mDrawableCacheKey);
        }
    }
}

