/*
 * Decompiled with CFR 0.152.
 */
package ke.tang.ruler;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import ke.tang.ruler.Marker;
import ke.tang.ruler.MathUtils;
import ke.tang.ruler.OnRulerValueChangeListener;
import ke.tang.ruler.OverScroller;
import ke.tang.ruler.R;
import ke.tang.ruler.RulerValueFormatter;

public class RulerView
extends View {
    public static final int MAX_VALUE = 10000;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PINCH = 1;
    private static final int STATE_SCROLL = 2;
    private static final int STATE_FLING = 3;
    private static final int STATE_RESET = 4;
    private int mStepWidth;
    private RulerValueFormatter mRulerValueFormatter;
    private ColorStateList mScaleColor;
    private ColorStateList mRulerColor;
    private int mSectionScaleCount;
    private Drawable mIndicator;
    private int mScaleMinHeight;
    private int mScaleMaxHeight;
    private int mScaleSize;
    private int mRulerSize;
    @IntRange(from=0L, to=10000L)
    private int mMaxValue;
    @IntRange(from=0L, to=10000L)
    private int mMinValue;
    @IntRange(from=0L, to=10000L)
    private int mValue;
    private float mTextSize;
    private ColorStateList mTextColor;
    private OnRulerValueChangeListener mOnRulerValueChangeListener;
    private OverScroller mScroller;
    private int mContentOffset;
    private int mMaxContentOffset;
    private int mMinContentOffset;
    private Paint mRulerPaint = new Paint(1);
    private TextPaint mLabelPaint = new TextPaint(1);
    private float mLastX;
    private float mDownX;
    private float mDownDistance;
    private float mLastDistance;
    private Paint.FontMetrics mFontMetrics;
    private VelocityTracker mVelocityTracker = VelocityTracker.obtain();
    private int mState = 0;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private int mTouchSlop;
    private List<Marker> mMarkers = new ArrayList<Marker>();
    private Comparator<Marker> mMarkerComparator = new Comparator<Marker>(){

        @Override
        public int compare(Marker o1, Marker o2) {
            int value2;
            int value1 = o1.value();
            if (value1 > (value2 = o2.value())) {
                return 1;
            }
            if (value1 < value2) {
                return -1;
            }
            return 0;
        }
    };
    private Rect mTempRect = new Rect();
    private RectF mTempRectF = new RectF();
    private int mMarkerHeight;

    public RulerView(Context context) {
        this(context, null);
    }

    public RulerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.rulerViewStyle);
    }

    public RulerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mScroller = new OverScroller(context);
        this.mScroller.setFriction(0.005f);
        this.setWillNotDraw(false);
        this.mMinimumVelocity = ViewConfiguration.get((Context)context).getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = ViewConfiguration.get((Context)context).getScaledMaximumFlingVelocity();
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        Resources resources = context.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RulerView, defStyleAttr, R.style.Widget_RulerView);
        this.mStepWidth = a.getDimensionPixelOffset(R.styleable.RulerView_stepWidth, (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)displayMetrics));
        String valueFormatterClassName = a.getString(R.styleable.RulerView_rulerValueFormatter);
        if (!TextUtils.isEmpty((CharSequence)valueFormatterClassName)) {
            try {
                Class<?> valueFormatterClass = Class.forName(valueFormatterClassName);
                if (!RulerValueFormatter.class.isAssignableFrom(valueFormatterClass)) {
                    throw new IllegalArgumentException(valueFormatterClassName + "\u7c7b\u5fc5\u987b\u5b9e\u73b0RulerValueFormatter");
                }
                Constructor<?> constructor = valueFormatterClass.getConstructor(new Class[0]);
                this.mRulerValueFormatter = (RulerValueFormatter)constructor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(valueFormatterClassName + "\u7c7b\u5fc5\u987b\u5305\u542b\u9ed8\u8ba4\u6784\u9020\u51fd\u6570");
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.setScaleColor(a.getColor(R.styleable.RulerView_scaleColor, -16777216));
        this.setRulerColor(a.getColor(R.styleable.RulerView_rulerColor, -16777216));
        this.mSectionScaleCount = a.getInt(R.styleable.RulerView_sectionScaleCount, 10);
        this.mIndicator = a.getDrawable(R.styleable.RulerView_indicator);
        this.mScaleMinHeight = a.getDimensionPixelSize(R.styleable.RulerView_scaleMinHeight, (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)displayMetrics));
        this.mScaleMaxHeight = a.getDimensionPixelSize(R.styleable.RulerView_scaleMaxHeight, (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)displayMetrics));
        this.mRulerSize = a.getDimensionPixelSize(R.styleable.RulerView_rulerSize, (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)displayMetrics));
        this.mScaleSize = a.getDimensionPixelSize(R.styleable.RulerView_scaleSize, (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)displayMetrics));
        this.mMaxValue = a.getInt(R.styleable.RulerView_maxValue, 10000);
        this.mMinValue = a.getInt(R.styleable.RulerView_minValue, 0);
        if (this.mMaxValue < this.mMinValue) {
            throw new IllegalArgumentException("\u6700\u5927\u503c\u4e0d\u80fd\u5c0f\u4e8e\u6700\u5c0f\u503c");
        }
        this.mValue = a.getInt(R.styleable.RulerView_value, this.mMinValue);
        if (this.mValue > this.mMaxValue || this.mValue < this.mMinValue) {
            throw new IllegalArgumentException("\u503c\u9700\u8981\u4ecb\u4e8e\u6700\u5c0f\u503c(" + this.mMinValue + ")\u548c\u6700\u5927\u503c(" + this.mMaxValue + ")\u4e4b\u95f4");
        }
        this.mLabelPaint.setTextAlign(Paint.Align.CENTER);
        this.setTextSize(a.getDimension(R.styleable.RulerView_android_textSize, TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)displayMetrics)));
        this.setTextColor(a.getColorStateList(R.styleable.RulerView_android_textColor));
        this.setValue(this.mValue);
        a.recycle();
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            this.mContentOffset = this.mScroller.getCurrX();
            this.mValue = this.getValueForContentOffset(this.mContentOffset);
            this.notifyValueChanged();
            this.invalidate();
        } else if (this.needScrollToRoundValuePosition()) {
            this.scrollToRoundedValue();
        } else if (3 == this.mState || 4 == this.mState) {
            this.mState = 0;
        }
    }

    private void notifyValueChanged() {
        if (null != this.mOnRulerValueChangeListener) {
            this.mOnRulerValueChangeListener.onRulerValueChanged(this.mValue, null != this.mRulerValueFormatter ? this.mRulerValueFormatter.formatValue(this.mValue) : String.valueOf(this.mValue));
        }
    }

    private void scrollToRoundedValue() {
        int roundedValue = this.getRoundedValue(this.mContentOffset);
        this.mScroller.abortAnimation();
        this.mScroller.startScroll(this.mContentOffset, 0, this.getContentOffsetForValue(roundedValue) - this.mContentOffset, 0, 800);
        this.invalidate();
    }

    private int getRoundedValue(int offset) {
        return Math.max(this.mMinValue, Math.min(Math.round((float)offset * 1.0f / (float)this.mStepWidth), this.mMaxValue));
    }

    private boolean needScrollToRoundValuePosition() {
        float currentValue = (float)this.mContentOffset * 1.0f / (float)this.mStepWidth;
        int roundedValue = Math.round(currentValue);
        return currentValue != (float)roundedValue && (4 == this.mState || 3 == this.mState);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int targetHeight = 0;
        targetHeight += this.mRulerSize;
        targetHeight += Math.max(this.mScaleMaxHeight, this.mScaleMinHeight);
        targetHeight = (int)((float)targetHeight + (this.mFontMetrics.bottom - this.mFontMetrics.top));
        if (null != this.mIndicator) {
            targetHeight = Math.max(this.mIndicator.getIntrinsicHeight(), targetHeight);
        }
        targetHeight += this.getPaddingTop() + this.getPaddingBottom();
        if (!this.mMarkers.isEmpty()) {
            int maxMarkerHeight = 0;
            for (Marker marker : this.mMarkers) {
                marker.getBounds(this.mTempRect);
                maxMarkerHeight = Math.max(maxMarkerHeight, this.mTempRect.height());
            }
            targetHeight += maxMarkerHeight;
            this.mMarkerHeight = maxMarkerHeight;
        }
        this.setMeasuredDimension(RulerView.resolveSize((int)(this.getSuggestedMinimumWidth() + this.getPaddingLeft() + this.getPaddingRight()), (int)widthMeasureSpec), RulerView.resolveSize((int)targetHeight, (int)heightMeasureSpec));
    }

    protected void onDraw(Canvas canvas) {
        String label;
        float right;
        float left;
        float centerX;
        int scalePosition;
        int index;
        int contentOffset = this.mContentOffset;
        int maxContentOffset = this.mMaxContentOffset;
        int minContentOffset = this.mMinContentOffset;
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int width = this.getWidth();
        int height = this.getHeight();
        int rulerHeight = height - this.mMarkerHeight;
        int insetWidth = width - paddingLeft - paddingRight;
        int halfInsetWidth = insetWidth / 2;
        float scaleSize = this.mScaleSize;
        float rulerSize = this.mRulerSize;
        int maxScaleCount = this.mMaxValue;
        int minScaleCount = this.mMinValue;
        int[] drawableState = this.getDrawableState();
        this.mRulerPaint.setColor(this.mScaleColor.isStateful() ? this.mScaleColor.getColorForState(drawableState, -16777216) : this.mScaleColor.getDefaultColor());
        if (null != this.mTextColor) {
            this.mLabelPaint.setColor(this.mTextColor.getColorForState(drawableState, -16777216));
        }
        float fontY = (float)(rulerHeight - this.getPaddingBottom()) - rulerSize - (float)this.mScaleMaxHeight - this.mFontMetrics.bottom;
        int count = contentOffset / this.mStepWidth;
        for (index = Math.min(count, maxScaleCount); index >= minScaleCount; --index) {
            scalePosition = index * this.mStepWidth;
            centerX = paddingLeft + halfInsetWidth + scalePosition - contentOffset;
            left = centerX - scaleSize / 2.0f;
            right = centerX + scaleSize / 2.0f;
            label = null != this.mRulerValueFormatter ? this.mRulerValueFormatter.formatValue(index) : String.valueOf(index);
            float labelRight = centerX + this.mLabelPaint.measureText(label) / 2.0f;
            if (!(labelRight > 0.0f)) break;
            if (0 == index % this.mSectionScaleCount || index == maxScaleCount || index == minScaleCount) {
                canvas.drawRect(left, (float)rulerHeight - rulerSize - (float)paddingBottom - (float)this.mScaleMaxHeight, right, (float)rulerHeight - rulerSize - (float)paddingBottom, this.mRulerPaint);
                canvas.drawText(label, centerX, fontY, (Paint)this.mLabelPaint);
                continue;
            }
            canvas.drawRect(left, (float)rulerHeight - rulerSize - (float)paddingBottom - (float)this.mScaleMinHeight, right, (float)rulerHeight - rulerSize - (float)paddingBottom, this.mRulerPaint);
        }
        for (index = Math.max(minScaleCount, count); index <= maxScaleCount; ++index) {
            scalePosition = index * this.mStepWidth;
            centerX = paddingLeft + halfInsetWidth + scalePosition - contentOffset;
            left = centerX - scaleSize / 2.0f;
            right = centerX + scaleSize / 2.0f;
            label = null != this.mRulerValueFormatter ? this.mRulerValueFormatter.formatValue(index) : String.valueOf(index);
            float labelLeft = centerX - this.mLabelPaint.measureText(label) / 2.0f;
            if (!(labelLeft < (float)width)) break;
            if (0 == index % this.mSectionScaleCount || index == maxScaleCount || index == minScaleCount) {
                canvas.drawRect(left, (float)rulerHeight - rulerSize - (float)paddingBottom - (float)this.mScaleMaxHeight, right, (float)rulerHeight - rulerSize - (float)paddingBottom, this.mRulerPaint);
                canvas.drawText(label, centerX, fontY, (Paint)this.mLabelPaint);
                continue;
            }
            canvas.drawRect(left, (float)rulerHeight - rulerSize - (float)paddingBottom - (float)this.mScaleMinHeight, right, (float)rulerHeight - rulerSize - (float)paddingBottom, this.mRulerPaint);
        }
        this.mRulerPaint.setColor(this.mRulerColor.isStateful() ? this.mRulerColor.getColorForState(drawableState, -16777216) : this.mRulerColor.getDefaultColor());
        canvas.drawRect((float)Math.max(0, paddingLeft + halfInsetWidth - contentOffset + minContentOffset), (float)(rulerHeight - paddingBottom) - rulerSize, (float)Math.min(width, width - paddingRight - halfInsetWidth + maxContentOffset - contentOffset), (float)(rulerHeight - paddingBottom), this.mRulerPaint);
        if (!this.mMarkers.isEmpty()) {
            for (Marker marker : this.mMarkers) {
                int scalePosition2 = marker.value() * this.mStepWidth;
                marker.getBounds(this.mTempRect);
                float centerX2 = paddingLeft + halfInsetWidth + scalePosition2 - contentOffset;
                float left2 = centerX2 - (float)(this.mTempRect.width() / 2);
                float right2 = centerX2 + (float)(this.mTempRect.width() / 2);
                float x = left2;
                float y = height - this.mMarkerHeight;
                marker.setX(x);
                marker.setY(y);
                if (!(right2 > 0.0f) && !(left2 < (float)width)) continue;
                canvas.save();
                canvas.translate(x, y);
                marker.onDraw(canvas);
                canvas.restore();
            }
        }
        if (null != this.mIndicator) {
            Drawable indicator = this.mIndicator;
            if (indicator.isStateful()) {
                indicator.setState(drawableState);
            }
            indicator.setBounds(paddingLeft + halfInsetWidth - indicator.getIntrinsicWidth() / 2, paddingTop, paddingLeft + halfInsetWidth + indicator.getIntrinsicWidth() / 2, rulerHeight - paddingBottom);
            indicator.draw(canvas);
        }
    }

    private int getValueForContentOffset(int contentOffset) {
        return Math.max(Math.min(Math.round((float)contentOffset * 1.0f / (float)this.mStepWidth), this.mMaxValue), this.mMinValue);
    }

    private int getContentOffsetForValue(int relativeValue) {
        try {
            return MathUtils.multiplyExact(relativeValue, this.mStepWidth);
        }
        catch (Exception e) {
            return Integer.MAX_VALUE;
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        boolean result = super.onTouchEvent(event);
        int pointerCount = event.getPointerCount();
        int width = this.getWidth();
        switch (event.getActionMasked()) {
            case 0: {
                this.resetStateAndAbortScroll();
                this.mDownX = x;
                break;
            }
            case 5: {
                if (pointerCount <= 1) break;
                this.mDownDistance = this.getMaxDistanceOfPointers(event);
                break;
            }
            case 6: {
                break;
            }
            case 2: {
                if (pointerCount > 1) {
                    float currentDistance = this.getMaxDistanceOfPointers(event);
                    if (1 != this.mState && 2 != this.mState && Math.abs(currentDistance - this.mDownDistance) > (float)this.mTouchSlop) {
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                        this.mState = 1;
                    }
                    if (1 == this.mState) {
                        float dDistance = currentDistance - this.mLastDistance;
                        this.mStepWidth = Math.max(1, (int)((float)this.mStepWidth + dDistance / 2.0f));
                        this.mValue = Math.max(this.mMinValue, Math.min(this.mValue, this.mMaxValue));
                        this.mContentOffset = this.getContentOffsetForValue(this.mValue);
                        this.mMaxContentOffset = this.getContentOffsetForValue(this.mMaxValue);
                        this.mMinContentOffset = this.getContentOffsetForValue(this.mMinValue);
                        this.invalidate();
                    }
                    this.mLastDistance = currentDistance;
                    break;
                }
                float dx = x - this.mLastX;
                if (2 != this.mState && 1 != this.mState && Math.abs(x - this.mDownX) > (float)this.mTouchSlop) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                    this.mState = 2;
                }
                if (2 != this.mState) break;
                if ((float)this.mContentOffset - dx < (float)this.mMinContentOffset || (float)this.mContentOffset - dx > (float)this.mMaxContentOffset) {
                    dx /= 2.0f;
                }
                this.mContentOffset = (int)((float)this.mContentOffset - dx);
                this.mValue = this.getValueForContentOffset(this.mContentOffset);
                this.notifyValueChanged();
                this.invalidate();
                break;
            }
            case 1: {
                this.getParent().requestDisallowInterceptTouchEvent(false);
                switch (this.mState) {
                    case 0: {
                        if (!this.mMarkers.isEmpty()) {
                            for (Marker marker : this.mMarkers) {
                                marker.getBounds(this.mTempRect);
                                this.mTempRectF.set(this.mTempRect);
                                this.mTempRectF.offset(marker.getX(), marker.getY());
                                if (!this.mTempRectF.contains(x, y)) continue;
                                marker.performClick();
                                break;
                            }
                        }
                    }
                    case 1: {
                        this.mState = 4;
                        this.scrollToRoundedValue();
                        break;
                    }
                    default: {
                        this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                        float velocityX = this.mVelocityTracker.getXVelocity();
                        if (this.mContentOffset < this.mMinContentOffset) {
                            this.mState = 4;
                            this.mScroller.springBack(this.mContentOffset, 0, this.mMinContentOffset, this.mMaxContentOffset, 0, 0);
                            break;
                        }
                        if (this.mContentOffset > this.mMaxContentOffset) {
                            this.mState = 4;
                            this.mScroller.springBack(this.mContentOffset, 0, this.mMinContentOffset, this.mMaxContentOffset, 0, 0);
                            break;
                        }
                        if (Math.abs(velocityX) > (float)this.mMinimumVelocity) {
                            this.mState = 3;
                            int resolvedVelocityX = (int)(-velocityX);
                            int flingOffset = (int)this.mScroller.getSplineFlingDistance(resolvedVelocityX);
                            int targetOffset = this.mContentOffset + flingOffset;
                            if (targetOffset >= this.mMinContentOffset && targetOffset <= this.mMaxContentOffset) {
                                resolvedVelocityX = this.mScroller.getSplineFlingVelocity(this.getContentOffsetForValue(this.getValueForContentOffset(targetOffset)) - this.mContentOffset);
                            }
                            this.mScroller.fling(this.mContentOffset, 0, resolvedVelocityX, 0, this.mMinContentOffset, this.mMaxContentOffset, 0, 0, (int)((float)width / 8.0f), 0);
                            break;
                        }
                        this.mState = 4;
                        this.scrollToRoundedValue();
                    }
                }
                this.invalidate();
            }
            case 3: {
                this.mVelocityTracker.clear();
            }
        }
        this.mVelocityTracker.addMovement(event);
        this.mLastX = event.getX();
        return true;
    }

    private float getMaxDistanceOfPointers(MotionEvent event) {
        int pointerCount = event.getPointerCount();
        float maxX = 0.0f;
        float minX = 0.0f;
        for (int index = 0; index < pointerCount; ++index) {
            float currentX = event.getX(index);
            maxX = Math.max(currentX, maxX);
            minX = Math.min(currentX, minX);
        }
        return Math.abs(maxX - minX);
    }

    public void setTextSize(float textSize) {
        this.mTextSize = textSize;
        this.mLabelPaint.setTextSize(textSize);
        this.mFontMetrics = this.mLabelPaint.getFontMetrics();
        this.requestLayout();
        this.invalidate();
    }

    public void setTextColor(@ColorInt int color) {
        this.setTextColor(ColorStateList.valueOf((int)color));
    }

    public void setScaleColor(@ColorInt int color) {
        this.setScaleColor(ColorStateList.valueOf((int)color));
    }

    public void setScaleColor(ColorStateList color) {
        this.mScaleColor = color;
        this.invalidate();
    }

    public void setRulerColor(@ColorInt int color) {
        this.setRulerColor(ColorStateList.valueOf((int)color));
    }

    public void setRulerColor(ColorStateList color) {
        this.mRulerColor = color;
        this.invalidate();
    }

    public void setRulerValueFormatter(RulerValueFormatter rulerValueFormatter) {
        this.mRulerValueFormatter = rulerValueFormatter;
        this.notifyValueChanged();
        this.invalidate();
    }

    public void setValue(@IntRange(from=0L, to=10000L) int value) {
        this.mValue = Math.max(this.mMinValue, Math.min(value, this.mMaxValue));
        this.mContentOffset = this.getContentOffsetForValue(this.mValue);
        this.mMaxContentOffset = this.getContentOffsetForValue(this.mMaxValue);
        this.mMinContentOffset = this.getContentOffsetForValue(this.mMinValue);
        this.resetStateAndAbortScroll();
        this.invalidate();
        this.notifyValueChanged();
    }

    private void resetStateAndAbortScroll() {
        this.mState = 0;
        this.mScroller.abortAnimation();
    }

    public int getValue() {
        return this.mValue;
    }

    public String getFormatValue() {
        return null != this.mRulerValueFormatter ? this.mRulerValueFormatter.formatValue(this.mValue) : String.valueOf(this.mValue);
    }

    public void setOnRulerValueChangeListener(OnRulerValueChangeListener onRulerValueChangeListener) {
        this.mOnRulerValueChangeListener = onRulerValueChangeListener;
    }

    public void setTextColor(ColorStateList color) {
        this.mTextColor = color;
        this.invalidate();
    }

    public void setTextColorResource(@ColorRes int res) {
        this.setTextColor(res > 0 ? this.getResources().getColorStateList(res) : ColorStateList.valueOf((int)-16777216));
    }

    public void setRulerColorResource(@ColorRes int res) {
        this.setRulerColor(res > 0 ? this.getResources().getColorStateList(res) : ColorStateList.valueOf((int)-16777216));
    }

    public void setScaleColorResource(@ColorRes int res) {
        this.setScaleColor(res > 0 ? this.getResources().getColorStateList(res) : ColorStateList.valueOf((int)-16777216));
    }

    public void setIndicator(@DrawableRes int res) {
        this.setIndicator(res > 0 ? this.getResources().getDrawable(res) : null);
    }

    public void setIndicator(Drawable indicator) {
        if (null != this.mIndicator) {
            this.mIndicator.setCallback(null);
        }
        this.mIndicator = indicator;
        if (null != indicator) {
            indicator.setCallback((Drawable.Callback)this);
        }
        this.invalidate();
    }

    public void setMaxValue(@IntRange(from=0L, to=10000L) int maxValue) {
        if (maxValue < this.mMinValue) {
            throw new IllegalArgumentException("\u6700\u5927\u503c: " + maxValue + " \u4e0d\u80fd\u5c0f\u4e8e\u6700\u5c0f\u503c: " + this.mMinValue);
        }
        this.mMaxValue = maxValue;
        this.setValue(this.mValue);
    }

    public void setMinValue(@IntRange(from=0L, to=10000L) int minValue) {
        if (minValue > this.mMaxValue) {
            throw new IllegalArgumentException("\u6700\u5c0f\u503c: " + minValue + " \u4e0d\u80fd\u5927\u4e8e\u6700\u5927\u503c: " + this.mMaxValue);
        }
        this.mMinValue = minValue;
        this.setValue(this.mValue);
    }

    public void setScaleSize(int scaleSize) {
        this.mScaleSize = Math.max(0, scaleSize);
        this.requestLayout();
        this.invalidate();
    }

    public void setRulerSize(int rulerSize) {
        this.mRulerSize = Math.max(0, rulerSize);
        this.requestLayout();
        this.invalidate();
    }

    public void setStepWidth(int stepWidth) {
        this.mStepWidth = Math.max(1, stepWidth);
        this.setValue(this.mValue);
    }

    public void setSectionScaleCount(int sectionScaleCount) {
        this.mSectionScaleCount = Math.max(0, sectionScaleCount);
        this.invalidate();
    }

    public void setScaleMinHeight(int scaleMinHeight) {
        this.mScaleMinHeight = scaleMinHeight;
        this.requestLayout();
        this.invalidate();
    }

    public void setScaleMaxHeight(int scaleMaxHeight) {
        this.mScaleMaxHeight = scaleMaxHeight;
        this.requestLayout();
        this.invalidate();
    }

    @ViewDebug.ExportedProperty(category="custom")
    public int getStepWidth() {
        return this.mStepWidth;
    }

    @ViewDebug.ExportedProperty(category="custom")
    public ColorStateList getScaleColor() {
        return this.mScaleColor;
    }

    @ViewDebug.ExportedProperty(category="custom")
    public ColorStateList getRulerColor() {
        return this.mRulerColor;
    }

    @ViewDebug.ExportedProperty(category="custom")
    public int getSectionScaleCount() {
        return this.mSectionScaleCount;
    }

    @ViewDebug.ExportedProperty(category="custom")
    public Drawable getIndicator() {
        return this.mIndicator;
    }

    @ViewDebug.ExportedProperty(category="custom")
    public int getScaleMinHeight() {
        return this.mScaleMinHeight;
    }

    @ViewDebug.ExportedProperty(category="custom")
    public int getScaleMaxHeight() {
        return this.mScaleMaxHeight;
    }

    @ViewDebug.ExportedProperty(category="custom")
    public int getScaleSize() {
        return this.mScaleSize;
    }

    @ViewDebug.ExportedProperty(category="custom")
    public int getRulerSize() {
        return this.mRulerSize;
    }

    @ViewDebug.ExportedProperty(category="custom")
    public int getMaxValue() {
        return this.mMaxValue;
    }

    @ViewDebug.ExportedProperty(category="custom")
    public int getMinValue() {
        return this.mMinValue;
    }

    @ViewDebug.ExportedProperty(category="custom")
    public float getTextSize() {
        return this.mTextSize;
    }

    @ViewDebug.ExportedProperty(category="custom")
    public ColorStateList getTextColor() {
        return this.mTextColor;
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        return super.verifyDrawable(who) || who == this.mIndicator;
    }

    public void addMarker(Marker marker) {
        this.mMarkers.add(marker);
        Collections.sort(this.mMarkers, this.mMarkerComparator);
        this.requestLayout();
        this.invalidate();
    }

    public void removeMarker(Marker marker) {
        this.mMarkers.remove(marker);
        this.requestLayout();
        this.invalidate();
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mStepWidth = savedState.mStepWidth;
        this.mScaleColor = savedState.mScaleColor;
        this.mRulerColor = savedState.mRulerColor;
        this.mSectionScaleCount = savedState.mSectionScaleCount;
        this.mScaleMinHeight = savedState.mScaleMinHeight;
        this.mScaleMaxHeight = savedState.mScaleMaxHeight;
        this.mScaleSize = savedState.mScaleSize;
        this.mRulerSize = savedState.mRulerSize;
        this.mMaxValue = savedState.mMaxValue;
        this.mMinValue = savedState.mMinValue;
        this.mValue = savedState.mValue;
        this.setTextSize(savedState.mTextSize);
        this.mTextColor = savedState.mTextColor;
        this.mState = savedState.mState;
        this.mContentOffset = savedState.mContentOffset;
        this.mMaxContentOffset = savedState.mMaxContentOffset;
        this.mMinContentOffset = savedState.mMinContentOffset;
        this.mMarkers = savedState.mMarkers;
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        SavedState state = new SavedState(super.onSaveInstanceState());
        state.mStepWidth = this.mStepWidth;
        state.mScaleColor = this.mScaleColor;
        state.mRulerColor = this.mRulerColor;
        state.mSectionScaleCount = this.mSectionScaleCount;
        state.mScaleMinHeight = this.mScaleMinHeight;
        state.mScaleMaxHeight = this.mScaleMaxHeight;
        state.mScaleSize = this.mScaleSize;
        state.mRulerSize = this.mRulerSize;
        state.mMaxValue = this.mMaxValue;
        state.mMinValue = this.mMinValue;
        state.mValue = this.mValue;
        state.mTextSize = this.mTextSize;
        state.mTextColor = this.mTextColor;
        state.mState = this.mState;
        state.mContentOffset = this.mContentOffset;
        state.mMaxContentOffset = this.mMaxContentOffset;
        state.mMinContentOffset = this.mMinContentOffset;
        state.mMarkers = this.mMarkers;
        return state;
    }

    private static class SavedState
    extends View.BaseSavedState {
        private int mStepWidth;
        private ColorStateList mScaleColor;
        private ColorStateList mRulerColor;
        private int mSectionScaleCount;
        private int mScaleMinHeight;
        private int mScaleMaxHeight;
        private int mScaleSize;
        private int mRulerSize;
        private int mMaxValue;
        private int mMinValue;
        private int mValue;
        private float mTextSize;
        private ColorStateList mTextColor;
        private int mState;
        private int mContentOffset;
        private int mMaxContentOffset;
        private int mMinContentOffset;
        private List<Marker> mMarkers;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.mStepWidth = source.readInt();
            this.mScaleColor = (ColorStateList)source.readParcelable(ColorStateList.class.getClassLoader());
            this.mRulerColor = (ColorStateList)source.readParcelable(ColorStateList.class.getClassLoader());
            this.mSectionScaleCount = source.readInt();
            this.mScaleMinHeight = source.readInt();
            this.mScaleMaxHeight = source.readInt();
            this.mScaleSize = source.readInt();
            this.mRulerSize = source.readInt();
            this.mMaxValue = source.readInt();
            this.mMinValue = source.readInt();
            this.mValue = source.readInt();
            this.mTextSize = source.readFloat();
            this.mTextColor = (ColorStateList)source.readParcelable(ColorStateList.class.getClassLoader());
            this.mState = source.readInt();
            this.mContentOffset = source.readInt();
            this.mMaxContentOffset = source.readInt();
            this.mMinContentOffset = source.readInt();
            this.mMarkers = source.readArrayList(Marker.class.getClassLoader());
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.mStepWidth);
            out.writeParcelable((Parcelable)this.mScaleColor, 0);
            out.writeParcelable((Parcelable)this.mRulerColor, 0);
            out.writeInt(this.mSectionScaleCount);
            out.writeInt(this.mScaleMinHeight);
            out.writeInt(this.mScaleMaxHeight);
            out.writeInt(this.mScaleSize);
            out.writeInt(this.mRulerSize);
            out.writeInt(this.mMaxValue);
            out.writeInt(this.mMinValue);
            out.writeInt(this.mValue);
            out.writeFloat(this.mTextSize);
            out.writeParcelable((Parcelable)this.mTextColor, 0);
            out.writeInt(this.mState);
            out.writeInt(this.mContentOffset);
            out.writeInt(this.mMaxContentOffset);
            out.writeInt(this.mMinContentOffset);
            out.writeList(this.mMarkers);
        }
    }
}

