/*
 * Decompiled with CFR 0.152.
 */
package ke.tang.ruler;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import ke.tang.ruler.ClickableMarker;

public class DrawableMarker
extends ClickableMarker {
    private Drawable mDrawable;
    private int mValue;

    public DrawableMarker(Context context, @DrawableRes int res, int value) {
        this(context.getResources().getDrawable(res), value);
    }

    public DrawableMarker(Drawable drawable, int value) {
        this.mDrawable = drawable;
        this.mValue = value;
    }

    @Override
    public void onDraw(Canvas canvas) {
        if (null != this.mDrawable) {
            this.mDrawable.setBounds(0, 0, this.mDrawable.getIntrinsicWidth(), this.mDrawable.getIntrinsicHeight());
            this.mDrawable.draw(canvas);
        }
    }

    @Override
    public void getBounds(Rect rect) {
        if (null != this.mDrawable) {
            rect.set(0, 0, this.mDrawable.getIntrinsicWidth(), this.mDrawable.getIntrinsicHeight());
        }
    }

    @Override
    public int value() {
        return this.mValue;
    }
}

