/*
 * Decompiled with CFR 0.152.
 */
package mobi.upod.timedurationpicker;

public class TimeDurationUtil {
    public static final int MILLIS_PER_SECOND = 1000;
    public static final int MILLIS_PER_MINUTE = 60000;
    public static final int MILLIS_PER_HOUR = 3600000;

    public static int hoursOf(long duration) {
        return (int)duration / 3600000;
    }

    public static int minutesOf(long duration) {
        return (int)duration / 60000;
    }

    public static int minutesInHourOf(long duration) {
        return (int)(duration - (long)(TimeDurationUtil.hoursOf(duration) * 3600000)) / 60000;
    }

    public static int secondsOf(long duration) {
        return (int)duration / 1000;
    }

    public static int secondsInMinuteOf(long duration) {
        return (int)(duration - (long)(TimeDurationUtil.hoursOf(duration) * 3600000) - (long)(TimeDurationUtil.minutesInHourOf(duration) * 60000)) / 1000;
    }

    public static long durationOf(int hours, int minutes, int seconds) {
        return hours * 3600000 + minutes * 60000 + seconds * 1000;
    }

    public static String formatHoursMinutesSeconds(long duration) {
        return String.format("%d:%02d:%02d", TimeDurationUtil.hoursOf(duration), TimeDurationUtil.minutesInHourOf(duration), TimeDurationUtil.secondsInMinuteOf(duration));
    }

    public static String formatMinutesSeconds(long duration) {
        return String.format("%d:%02d", TimeDurationUtil.minutesOf(duration), TimeDurationUtil.secondsInMinuteOf(duration));
    }

    public static String formatSeconds(long duration) {
        return String.format("%d", TimeDurationUtil.secondsInMinuteOf(duration));
    }
}

