/*
 * Decompiled with CFR 0.152.
 */
package mobi.upod.timedurationpicker;

import android.app.AlertDialog;
import android.content.Context;
import android.content.res.TypedArray;
import android.preference.DialogPreference;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import mobi.upod.timedurationpicker.R;
import mobi.upod.timedurationpicker.TimeDurationPicker;
import mobi.upod.timedurationpicker.TimeDurationUtil;

public class TimeDurationPickerPreference
extends DialogPreference {
    public static final String PLACEHOLDER_HOURS_MINUTES_SECONDS = "${h:mm:ss}";
    public static final String PLACEHOLDER_MINUTES_SECONDS = "${m:ss}";
    public static final String PLACEHOLDER_SECONDS = "${s}";
    private long duration = 0L;
    private TimeDurationPicker picker = null;
    private String summaryTemplate;

    public TimeDurationPickerPreference(Context context) {
        this(context, null);
    }

    public TimeDurationPickerPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setPositiveButtonText(17039370);
        this.setNegativeButtonText(0x1040000);
    }

    public void setDuration(long duration) {
        this.duration = duration;
        this.persistLong(duration);
        this.notifyDependencyChange(this.shouldDisableDependents());
        this.notifyChanged();
    }

    public long getDuration() {
        return this.duration;
    }

    public TimeDurationPicker getTimeDurationPicker() {
        return this.picker;
    }

    private void updateDescription() {
        if (this.summaryTemplate == null) {
            this.summaryTemplate = this.getSummary().toString();
        }
        String summary = this.summaryTemplate.replace(PLACEHOLDER_HOURS_MINUTES_SECONDS, TimeDurationUtil.formatHoursMinutesSeconds(this.duration)).replace(PLACEHOLDER_MINUTES_SECONDS, TimeDurationUtil.formatMinutesSeconds(this.duration).replace(PLACEHOLDER_SECONDS, TimeDurationUtil.formatSeconds(this.duration)));
        this.setSummary(summary);
    }

    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
        super.onPrepareDialogBuilder(builder.setTitle(null).setIcon(null));
    }

    protected View onCreateDialogView() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        this.picker = this.initPicker((TimeDurationPicker)inflater.inflate(R.layout.time_duration_picker_dialog, null));
        return this.picker;
    }

    protected TimeDurationPicker initPicker(TimeDurationPicker timePicker) {
        return timePicker;
    }

    protected void onBindDialogView(View v) {
        super.onBindDialogView(v);
        this.picker.setDuration(this.duration);
    }

    protected void onDialogClosed(boolean positiveResult) {
        super.onDialogClosed(positiveResult);
        if (positiveResult) {
            long newDuration = this.picker.getDuration();
            if (!this.callChangeListener(newDuration)) {
                return;
            }
            this.setDuration(newDuration);
            this.updateDescription();
        }
    }

    protected Object onGetDefaultValue(TypedArray a, int index) {
        return (long)a.getInt(index, 0);
    }

    protected void onSetInitialValue(boolean restorePersistedValue, Object defaultValue) {
        long duration = restorePersistedValue ? this.getPersistedLong(0L) : Long.parseLong(defaultValue.toString());
        this.setDuration(duration);
        this.updateDescription();
    }
}

