/*
 * Decompiled with CFR 0.152.
 */
package mobi.upod.timedurationpicker;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import mobi.upod.timedurationpicker.R;
import mobi.upod.timedurationpicker.TimeDurationPicker;

public class TimeDurationPickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener {
    private static final String DURATION = "duration";
    private final TimeDurationPicker durationInputView;
    private final OnDurationSetListener durationSetListener;

    public TimeDurationPickerDialog(Context context, OnDurationSetListener listener, long duration) {
        super(context);
        this.durationSetListener = listener;
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View view = inflater.inflate(R.layout.time_duration_picker_dialog, null);
        this.setView(view);
        this.setButton(-1, context.getString(17039370), this);
        this.setButton(-2, context.getString(0x1040000), this);
        this.durationInputView = (TimeDurationPicker)view;
        this.durationInputView.setDuration(duration);
    }

    public TimeDurationPickerDialog(Context context, OnDurationSetListener listener, long duration, int timeUnits) {
        this(context, listener, duration);
        this.durationInputView.setTimeUnits(timeUnits);
    }

    public TimeDurationPicker getDurationInput() {
        return this.durationInputView;
    }

    public void setDuration(long duration) {
        this.durationInputView.setDuration(duration);
    }

    public void onClick(DialogInterface dialog, int which) {
        switch (which) {
            case -1: {
                if (this.durationSetListener == null) break;
                this.durationSetListener.onDurationSet(this.durationInputView, this.durationInputView.getDuration());
                break;
            }
            case -2: {
                this.cancel();
            }
        }
    }

    public Bundle onSaveInstanceState() {
        Bundle state = super.onSaveInstanceState();
        state.putLong(DURATION, this.durationInputView.getDuration());
        return state;
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        long duration = savedInstanceState.getLong(DURATION);
        this.durationInputView.setDuration(duration);
    }

    public static interface OnDurationSetListener {
        public void onDurationSet(TimeDurationPicker var1, long var2);
    }
}

