/*
 * Decompiled with CFR 0.152.
 */
package mobi.upod.timedurationpicker;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import mobi.upod.timedurationpicker.R;
import mobi.upod.timedurationpicker.TimeDurationUtil;

public class TimeDurationPicker
extends FrameLayout {
    public static final int HH_MM_SS = 0;
    public static final int HH_MM = 1;
    public static final int MM_SS = 2;
    private int timeUnits = 0;
    private final TimeDurationString input = new TimeDurationString();
    private final View displayRow;
    private final View durationView;
    private final TextView hoursView;
    private final TextView minutesView;
    private final TextView secondsView;
    private final TextView[] displayViews;
    private final TextView[] unitLabelViews;
    private final ImageButton backspaceButton;
    private final ImageButton clearButton;
    private final View separatorView;
    private final View numPad;
    private final Button[] numPadButtons;
    private final Button numPadMeasureButton;
    private OnDurationChangedListener changeListener = null;
    private TextView secondsLabel;
    private TextView hoursLabel;
    private TextView minutesLabel;

    public TimeDurationPicker(Context context) {
        this(context, null);
    }

    public TimeDurationPicker(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.timeDurationPickerStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeDurationPicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TimeDurationPicker.inflate((Context)context, (int)R.layout.time_duration_picker, (ViewGroup)this);
        this.displayRow = this.findViewById(R.id.displayRow);
        this.durationView = this.findViewById(R.id.duration);
        this.hoursView = (TextView)this.findViewById(R.id.hours);
        this.minutesView = (TextView)this.findViewById(R.id.minutes);
        this.secondsView = (TextView)this.findViewById(R.id.seconds);
        this.displayViews = new TextView[]{this.hoursView, this.minutesView, this.secondsView};
        this.hoursLabel = (TextView)this.findViewById(R.id.hoursLabel);
        this.minutesLabel = (TextView)this.findViewById(R.id.minutesLabel);
        this.secondsLabel = (TextView)this.findViewById(R.id.secondsLabel);
        this.unitLabelViews = new TextView[]{this.hoursLabel, this.minutesLabel, this.secondsLabel};
        this.backspaceButton = (ImageButton)this.findViewById(R.id.backspace);
        this.clearButton = (ImageButton)this.findViewById(R.id.clear);
        this.separatorView = this.findViewById(R.id.separator);
        this.numPad = this.findViewById(R.id.numPad);
        this.numPadMeasureButton = (Button)this.findViewById(R.id.numPadMeasure);
        this.numPadButtons = new Button[]{(Button)this.findViewById(R.id.numPad1), (Button)this.findViewById(R.id.numPad2), (Button)this.findViewById(R.id.numPad3), (Button)this.findViewById(R.id.numPad4), (Button)this.findViewById(R.id.numPad5), (Button)this.findViewById(R.id.numPad6), (Button)this.findViewById(R.id.numPad7), (Button)this.findViewById(R.id.numPad8), (Button)this.findViewById(R.id.numPad9), (Button)this.findViewById(R.id.numPad0), (Button)this.findViewById(R.id.numPad00)};
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TimeDurationPicker, defStyleAttr, 0);
        try {
            this.applyPadding(attributes, R.styleable.TimeDurationPicker_numPadButtonPadding, (View[])this.numPadButtons);
            this.applyTextAppearance(context, attributes, R.styleable.TimeDurationPicker_textAppearanceDisplay, this.displayViews);
            this.applyTextAppearance(context, attributes, R.styleable.TimeDurationPicker_textAppearanceButton, (TextView[])this.numPadButtons);
            this.applyTextAppearance(context, attributes, R.styleable.TimeDurationPicker_textAppearanceUnit, this.unitLabelViews);
            this.applyIcon(attributes, R.styleable.TimeDurationPicker_backspaceIcon, (ImageView)this.backspaceButton);
            this.applyIcon(attributes, R.styleable.TimeDurationPicker_clearIcon, (ImageView)this.clearButton);
            this.applyBackgroundColor(attributes, R.styleable.TimeDurationPicker_separatorColor, this.separatorView);
            this.applyBackgroundColor(attributes, R.styleable.TimeDurationPicker_durationDisplayBackground, this.displayRow);
            this.applyUnits(attributes, R.styleable.TimeDurationPicker_timeUnits);
        }
        finally {
            attributes.recycle();
        }
        this.updateUnits();
        this.backspaceButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TimeDurationPicker.this.onBackspace();
            }
        });
        this.clearButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TimeDurationPicker.this.onClear();
            }
        });
        View.OnClickListener numberClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                TimeDurationPicker.this.onNumberClick(((Button)v).getText());
            }
        };
        for (Button button : this.numPadButtons) {
            button.setOnClickListener(numberClickListener);
        }
        this.updateHoursMinutesSeconds();
    }

    private void updateUnits() {
        this.hoursView.setVisibility(this.timeUnits == 0 || this.timeUnits == 1 ? 0 : 8);
        this.hoursLabel.setVisibility(this.timeUnits == 0 || this.timeUnits == 1 ? 0 : 8);
        this.secondsView.setVisibility(this.timeUnits == 0 || this.timeUnits == 2 ? 0 : 8);
        this.secondsLabel.setVisibility(this.timeUnits == 0 || this.timeUnits == 2 ? 0 : 8);
        this.input.updateTimeUnits(this.timeUnits);
    }

    private void applyUnits(TypedArray attrs, int attributeIndex) {
        if (attrs.hasValue(attributeIndex)) {
            this.timeUnits = attrs.getInt(attributeIndex, 0);
        }
    }

    public long getDuration() {
        return this.input.getDuration();
    }

    public void setDuration(long millis) {
        this.input.setDuration(millis);
        this.updateHoursMinutesSeconds();
    }

    public void setTimeUnits(int timeUnits) {
        this.timeUnits = timeUnits;
        this.updateUnits();
    }

    public void setOnDurationChangeListener(OnDurationChangedListener listener) {
        this.changeListener = listener;
    }

    public void setDisplayTextAppearance(int resId) {
        this.applyTextAppearance(this.getContext(), resId, this.displayViews);
    }

    public void setUnitTextAppearance(int resId) {
        this.applyTextAppearance(this.getContext(), resId, this.unitLabelViews);
    }

    public void setButtonTextAppearance(int resId) {
        this.applyTextAppearance(this.getContext(), resId, (TextView[])this.numPadButtons);
    }

    public void setBackspaceIcon(Drawable icon) {
        this.backspaceButton.setImageDrawable(icon);
    }

    public void setClearIcon(Drawable icon) {
        this.clearButton.setImageDrawable(icon);
    }

    public void setSeparatorColor(int color) {
        this.separatorView.setBackgroundColor(color);
    }

    public void setDurationDisplayBackgroundColor(int color) {
        this.displayRow.setBackgroundColor(color);
    }

    public void setNumPadButtonPadding(int padding) {
        this.applyPadding(padding, (View[])this.numPadButtons);
    }

    private void applyPadding(TypedArray attrs, int attributeIndex, View[] targetViews) {
        int padding = attrs.getDimensionPixelSize(attributeIndex, -1);
        if (padding > -1) {
            this.applyPadding(padding, targetViews);
        }
    }

    private void applyPadding(int padding, View[] targetViews) {
        for (View view : targetViews) {
            view.setPadding(padding, padding, padding, padding);
        }
    }

    private void applyTextAppearance(Context context, TypedArray attrs, int attributeIndex, TextView[] targetViews) {
        int id2 = attrs.getResourceId(attributeIndex, 0);
        if (id2 != 0) {
            this.applyTextAppearance(context, id2, targetViews);
        }
    }

    private void applyTextAppearance(Context context, int resId, TextView[] targetViews) {
        for (TextView view : targetViews) {
            view.setTextAppearance(context, resId);
        }
    }

    private void applyIcon(TypedArray attrs, int attributeIndex, ImageView targetView) {
        Drawable icon = attrs.getDrawable(attributeIndex);
        if (icon != null) {
            targetView.setImageDrawable(icon);
        }
    }

    private void applyBackgroundColor(TypedArray attrs, int attributeIndex, View targetView) {
        if (attrs.hasValue(attributeIndex)) {
            int color = attrs.getColor(attributeIndex, 0);
            targetView.setBackgroundColor(color);
        }
    }

    private void applyLeftMargin(int margin, View ... targetViews) {
        for (View view : targetViews) {
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)view.getLayoutParams();
            params.setMargins(margin, params.topMargin, params.rightMargin, params.bottomMargin);
            view.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    private void onBackspace() {
        this.input.popDigit();
        this.updateHoursMinutesSeconds();
    }

    private void onClear() {
        this.input.clear();
        this.updateHoursMinutesSeconds();
    }

    private void onNumberClick(CharSequence digits) {
        this.input.pushNumber(digits);
        this.updateHoursMinutesSeconds();
    }

    private void updateHoursMinutesSeconds() {
        this.hoursView.setText((CharSequence)this.input.getHoursString());
        this.minutesView.setText((CharSequence)this.input.getMinutesString());
        this.secondsView.setText((CharSequence)this.input.getSecondsString());
        this.fireDurationChangeListener();
    }

    private void fireDurationChangeListener() {
        if (this.changeListener != null) {
            this.changeListener.onDurationChanged(this, this.input.getDuration());
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int touchableSize = this.getContext().getResources().getDimensionPixelSize(R.dimen.touchable);
        int dummyMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.hoursView.measure(dummyMeasureSpec, dummyMeasureSpec);
        TextView unitLabelView = this.unitLabelViews[2];
        unitLabelView.measure(dummyMeasureSpec, dummyMeasureSpec);
        int unitSpacing = Math.max(this.hoursView.getMeasuredWidth() / 3, (int)(1.2f * (float)unitLabelView.getMeasuredWidth()));
        this.applyLeftMargin(unitSpacing, new View[]{this.minutesView, this.secondsView});
        this.durationView.measure(dummyMeasureSpec, dummyMeasureSpec);
        int minDisplayWidth = this.durationView.getMeasuredWidth() + 2 * touchableSize;
        int minDisplayHeight = Math.max(this.durationView.getMeasuredHeight(), touchableSize);
        this.numPadMeasureButton.measure(dummyMeasureSpec, dummyMeasureSpec);
        int minNumPadButtonSize = Math.max(Math.max(this.numPadMeasureButton.getMeasuredHeight(), this.numPadMeasureButton.getMeasuredWidth()), touchableSize);
        int minNumPadWidth = 3 * minNumPadButtonSize;
        int minNumPadHeight = 4 * minNumPadButtonSize;
        int minWidth = Math.max(minDisplayWidth, minNumPadWidth);
        int minHeight = minDisplayHeight + minNumPadHeight;
        int availableWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int availableHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int preferredWidth = widthMode == 0x40000000 ? availableWidth : minWidth;
        int preferredHeight = heightMode == 0x40000000 ? availableHeight : minHeight;
        int displayRowWidth = Math.max(minDisplayWidth, preferredWidth);
        int displayRowHeight = minDisplayHeight;
        this.displayRow.measure(View.MeasureSpec.makeMeasureSpec((int)displayRowWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)displayRowHeight, (int)0x40000000));
        int numPadWidth = Math.max(minNumPadHeight, displayRowWidth);
        int numPadHeight = Math.max(minNumPadHeight, preferredHeight - displayRowHeight);
        this.numPad.measure(View.MeasureSpec.makeMeasureSpec((int)numPadWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)numPadHeight, (int)0x40000000));
        int width = Math.max(displayRowWidth, numPadWidth);
        int height = displayRowHeight + numPadHeight;
        this.setMeasuredDimension(width, height);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int width = right - left;
        int displayRowWidth = this.displayRow.getMeasuredWidth();
        int displayRowHeight = this.displayRow.getMeasuredHeight();
        int displayRowX = (width - displayRowWidth) / 2;
        this.displayRow.layout(displayRowX, 0, displayRowX + displayRowWidth, displayRowHeight);
        int numPadWidth = this.numPad.getMeasuredWidth();
        int numPadHeight = this.numPad.getMeasuredHeight();
        int numPadX = (width - numPadWidth) / 2;
        int numPadY = displayRowHeight;
        this.numPad.layout(numPadX, numPadY, numPadX + numPadWidth, numPadY + numPadHeight);
    }

    protected Parcelable onSaveInstanceState() {
        return new SavedState(super.onSaveInstanceState(), this.input.getInputString());
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            throw new IllegalArgumentException("Expected state of class " + SavedState.class.getName() + " but received state of class " + state.getClass().getName());
        }
        SavedState savedStated = (SavedState)state;
        super.onRestoreInstanceState(savedStated.getSuperState());
        this.input.clear();
        this.input.pushNumber(savedStated.durationInput);
        this.updateHoursMinutesSeconds();
    }

    public static class SavedState
    extends View.BaseSavedState {
        final String durationInput;

        public SavedState(Parcelable superState, String durationInput) {
            super(superState);
            this.durationInput = durationInput;
        }

        public SavedState(Parcel source) {
            super(source);
            this.durationInput = source.readString();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.durationInput);
        }
    }

    private static class TimeDurationString {
        private int timeUnits;
        private int maxDigits = 6;
        private long duration = 0L;
        private final StringBuilder input = new StringBuilder(this.maxDigits);

        public TimeDurationString() {
            this.padWithZeros();
        }

        private void updateTimeUnits(int timeUnits) {
            this.timeUnits = timeUnits;
            this.setMaxDigits(timeUnits);
        }

        private void setMaxDigits(int timeUnits) {
            this.maxDigits = timeUnits == 0 ? 6 : 4;
            this.setDuration(this.duration);
        }

        public void pushNumber(CharSequence digits) {
            for (int i = 0; i < digits.length(); ++i) {
                this.pushDigit(digits.charAt(i));
            }
        }

        public void pushDigit(char digit) {
            if (!Character.isDigit(digit)) {
                throw new IllegalArgumentException("Only numbers are allowed");
            }
            this.removeLeadingZeros();
            if (this.input.length() < this.maxDigits && (this.input.length() > 0 || digit != '0')) {
                this.input.append(digit);
            }
            this.padWithZeros();
        }

        public void popDigit() {
            if (this.input.length() > 0) {
                this.input.deleteCharAt(this.input.length() - 1);
            }
            this.padWithZeros();
        }

        public void clear() {
            this.input.setLength(0);
            this.padWithZeros();
        }

        public String getHoursString() {
            return this.timeUnits == 0 || this.timeUnits == 1 ? this.input.substring(0, 2) : "00";
        }

        public String getMinutesString() {
            if (this.timeUnits == 0 || this.timeUnits == 1) {
                return this.input.substring(2, 4);
            }
            if (this.timeUnits == 2) {
                return this.input.substring(0, 2);
            }
            return "00";
        }

        public String getSecondsString() {
            if (this.timeUnits == 0) {
                return this.input.substring(4, 6);
            }
            if (this.timeUnits == 2) {
                return this.input.substring(2, 4);
            }
            return "00";
        }

        public String getInputString() {
            return this.input.toString();
        }

        public long getDuration() {
            int hours = Integer.parseInt(this.getHoursString());
            int minutes = Integer.parseInt(this.getMinutesString());
            int seconds = Integer.parseInt(this.getSecondsString());
            return TimeDurationUtil.durationOf(hours, minutes, seconds);
        }

        public void setDuration(long millis) {
            this.duration = millis;
            this.setDuration(TimeDurationUtil.hoursOf(millis), this.timeUnits == 2 ? (long)TimeDurationUtil.minutesOf(millis) : (long)TimeDurationUtil.minutesInHourOf(millis), TimeDurationUtil.secondsInMinuteOf(millis));
        }

        private void setDuration(long hours, long minutes, long seconds) {
            if (hours > 99L || minutes > 99L) {
                this.setDurationString("99", "99", "99");
            } else {
                this.setDurationString(this.stringFragment(hours), this.stringFragment(minutes), this.stringFragment(seconds));
            }
        }

        private void setDurationString(String hours, String minutes, String seconds) {
            this.input.setLength(0);
            if (this.timeUnits == 1 || this.timeUnits == 0) {
                this.input.append(hours);
            }
            this.input.append(minutes);
            if (this.timeUnits == 0 || this.timeUnits == 2) {
                this.input.append(seconds);
            }
        }

        private void removeLeadingZeros() {
            while (this.input.length() > 0 && this.input.charAt(0) == '0') {
                this.input.deleteCharAt(0);
            }
        }

        private void padWithZeros() {
            while (this.input.length() < this.maxDigits) {
                this.input.insert(0, '0');
            }
        }

        private String stringFragment(long value) {
            return (value < 10L ? "0" : "") + Long.toString(value);
        }
    }

    public static interface OnDurationChangedListener {
        public void onDurationChanged(TimeDurationPicker var1, long var2);
    }
}

