/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.misc;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.misc.TypeConversions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.el.ELException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanOperations {
    private static final Set<Class<? extends Number>> SIMPLE_INTEGER_TYPES = new HashSet<Class<? extends Number>>();
    private static final Set<Class<? extends Number>> SIMPLE_FLOAT_TYPES = new HashSet<Class<? extends Number>>();

    private static final BigDecimal toBigDecimal(Object object) {
        return TypeConversions.coerceToNumber(object, BigDecimal.class);
    }

    private static final BigInteger toBigInteger(Object object) {
        return TypeConversions.coerceToNumber(object, BigInteger.class);
    }

    private static final long toLong(Object object) {
        return TypeConversions.coerceToNumber(object, Long.class);
    }

    private static final double toDouble(Object object) {
        return TypeConversions.coerceToNumber(object, Double.class);
    }

    private static final String toString(Object object) {
        return TypeConversions.coerceToString(object);
    }

    private static final boolean toBoolean(Object object) {
        return TypeConversions.coerceToBoolean(object);
    }

    private static final Enum toEnum(Object object, Class<? extends Enum> clazz) {
        return TypeConversions.coerceToEnum(object, clazz);
    }

    private static final boolean lt0(Object object, Object object2) {
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = object2.getClass();
        if (BigDecimal.class.isAssignableFrom(clazz) || BigDecimal.class.isAssignableFrom(clazz2)) {
            return BooleanOperations.toBigDecimal(object).compareTo(BooleanOperations.toBigDecimal(object2)) < 0;
        }
        if (SIMPLE_FLOAT_TYPES.contains(clazz) || SIMPLE_FLOAT_TYPES.contains(clazz2)) {
            return BooleanOperations.toDouble(object) < BooleanOperations.toDouble(object2);
        }
        if (BigInteger.class.isAssignableFrom(clazz) || BigInteger.class.isAssignableFrom(clazz2)) {
            return BooleanOperations.toBigInteger(object).compareTo(BooleanOperations.toBigInteger(object2)) < 0;
        }
        if (SIMPLE_INTEGER_TYPES.contains(clazz) || SIMPLE_INTEGER_TYPES.contains(clazz2)) {
            return BooleanOperations.toLong(object) < BooleanOperations.toLong(object2);
        }
        if (clazz == String.class || clazz2 == String.class) {
            return BooleanOperations.toString(object).compareTo(BooleanOperations.toString(object2)) < 0;
        }
        if (object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2) < 0;
        }
        if (object2 instanceof Comparable) {
            return ((Comparable)object2).compareTo(object) > 0;
        }
        throw new ELException(LocalMessages.get("error.compare.types", object.getClass(), object2.getClass()));
    }

    private static final boolean gt0(Object object, Object object2) {
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = object2.getClass();
        if (BigDecimal.class.isAssignableFrom(clazz) || BigDecimal.class.isAssignableFrom(clazz2)) {
            return BooleanOperations.toBigDecimal(object).compareTo(BooleanOperations.toBigDecimal(object2)) > 0;
        }
        if (SIMPLE_FLOAT_TYPES.contains(clazz) || SIMPLE_FLOAT_TYPES.contains(clazz2)) {
            return BooleanOperations.toDouble(object) > BooleanOperations.toDouble(object2);
        }
        if (BigInteger.class.isAssignableFrom(clazz) || BigInteger.class.isAssignableFrom(clazz2)) {
            return BooleanOperations.toBigInteger(object).compareTo(BooleanOperations.toBigInteger(object2)) > 0;
        }
        if (SIMPLE_INTEGER_TYPES.contains(clazz) || SIMPLE_INTEGER_TYPES.contains(clazz2)) {
            return BooleanOperations.toLong(object) > BooleanOperations.toLong(object2);
        }
        if (clazz == String.class || clazz2 == String.class) {
            return BooleanOperations.toString(object).compareTo(BooleanOperations.toString(object2)) > 0;
        }
        if (object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2) > 0;
        }
        if (object2 instanceof Comparable) {
            return ((Comparable)object2).compareTo(object) < 0;
        }
        throw new ELException(LocalMessages.get("error.compare.types", object.getClass(), object2.getClass()));
    }

    public static final boolean lt(Object object, Object object2) {
        if (object == object2) {
            return false;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return BooleanOperations.lt0(object, object2);
    }

    public static final boolean gt(Object object, Object object2) {
        if (object == object2) {
            return false;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return BooleanOperations.gt0(object, object2);
    }

    public static final boolean ge(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return !BooleanOperations.lt0(object, object2);
    }

    public static final boolean le(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return !BooleanOperations.gt0(object, object2);
    }

    public static final boolean eq(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = object2.getClass();
        if (BigDecimal.class.isAssignableFrom(clazz) || BigDecimal.class.isAssignableFrom(clazz2)) {
            return BooleanOperations.toBigDecimal(object).equals(BooleanOperations.toBigDecimal(object2));
        }
        if (SIMPLE_FLOAT_TYPES.contains(clazz) || SIMPLE_FLOAT_TYPES.contains(clazz2)) {
            return BooleanOperations.toDouble(object) == BooleanOperations.toDouble(object2);
        }
        if (BigInteger.class.isAssignableFrom(clazz) || BigInteger.class.isAssignableFrom(clazz2)) {
            return BooleanOperations.toBigInteger(object).equals(BooleanOperations.toBigInteger(object2));
        }
        if (SIMPLE_INTEGER_TYPES.contains(clazz) || SIMPLE_INTEGER_TYPES.contains(clazz2)) {
            return BooleanOperations.toLong(object) == BooleanOperations.toLong(object2);
        }
        if (clazz == Boolean.class || clazz2 == Boolean.class) {
            return BooleanOperations.toBoolean(object) == BooleanOperations.toBoolean(object2);
        }
        if (object instanceof Enum) {
            return object == BooleanOperations.toEnum(object2, ((Enum)object).getClass());
        }
        if (object2 instanceof Enum) {
            return BooleanOperations.toEnum(object, ((Enum)object2).getClass()) == object2;
        }
        if (clazz == String.class || clazz2 == String.class) {
            return BooleanOperations.toString(object).equals(BooleanOperations.toString(object2));
        }
        return object.equals(object2);
    }

    public static final boolean ne(Object object, Object object2) {
        return !BooleanOperations.eq(object, object2);
    }

    public static final boolean and(Object object, Object object2) {
        return BooleanOperations.toBoolean(object) && BooleanOperations.toBoolean(object2);
    }

    public static final boolean or(Object object, Object object2) {
        return BooleanOperations.toBoolean(object) || BooleanOperations.toBoolean(object2);
    }

    public static final boolean not(Object object) {
        return !BooleanOperations.toBoolean(object);
    }

    public static final boolean empty(Object object) {
        if (object == null || "".equals(object)) {
            return true;
        }
        if (object instanceof Object[]) {
            return ((Object[])object).length == 0;
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        return false;
    }

    static {
        SIMPLE_INTEGER_TYPES.add(Byte.class);
        SIMPLE_INTEGER_TYPES.add(Short.class);
        SIMPLE_INTEGER_TYPES.add(Integer.class);
        SIMPLE_INTEGER_TYPES.add(Long.class);
        SIMPLE_FLOAT_TYPES.add(Float.class);
        SIMPLE_FLOAT_TYPES.add(Double.class);
    }
}

