/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.ExpressionNode;
import de.odysseus.el.tree.NodePrinter;
import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.TreeBuilder;
import de.odysseus.el.tree.TreeStore;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.FunctionMapper;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.VariableMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeMethodExpression
extends MethodExpression {
    private static final long serialVersionUID = 1L;
    private final TreeBuilder builder;
    private final Bindings bindings;
    private final String expr;
    private final Class<?> type;
    private final Class[] types;
    private final boolean deferred;
    private final boolean is_void;
    private transient ExpressionNode node;
    private String structure;

    public TreeMethodExpression(TreeStore treeStore, FunctionMapper functionMapper, VariableMapper variableMapper, String string, Class<?> clazz, Class<?>[] classArray) {
        Tree tree = treeStore.get(string);
        this.builder = treeStore.getBuilder();
        this.bindings = tree.bind(functionMapper, variableMapper);
        this.expr = string;
        this.type = clazz == Void.TYPE ? null : clazz;
        this.types = classArray;
        this.node = tree.getRoot();
        this.deferred = tree.isDeferred();
        boolean bl = this.is_void = clazz == Void.TYPE;
        if (this.node.isLiteralText()) {
            if (clazz == Void.TYPE) {
                throw new ELException(LocalMessages.get("error.method.literal.void", string));
            }
        } else {
            if (!this.node.isLeftValue()) {
                throw new ELException(LocalMessages.get("error.method.invalid", string));
            }
            if (classArray == null) {
                throw new ELException(LocalMessages.get("error.method.notypes", new Object[0]));
            }
        }
    }

    private String getStructuralId() {
        if (this.structure == null) {
            this.structure = this.node.getStructuralId(this.bindings);
        }
        return this.structure;
    }

    public MethodInfo getMethodInfo(ELContext eLContext) throws ELException {
        return this.node.getMethodInfo(this.bindings, eLContext, this.is_void ? Void.TYPE : this.type, this.types);
    }

    public String getExpressionString() {
        return this.expr;
    }

    public Object invoke(ELContext eLContext, Object[] objectArray) throws ELException {
        return this.node.invoke(this.bindings, eLContext, this.is_void ? Void.TYPE : this.type, this.types, objectArray);
    }

    public boolean isLiteralText() {
        return this.node.isLiteralText();
    }

    public boolean isDeferred() {
        return this.deferred;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == ((Object)((Object)this)).getClass()) {
            TreeMethodExpression treeMethodExpression = (TreeMethodExpression)((Object)object);
            if (!this.builder.equals(treeMethodExpression.builder)) {
                return false;
            }
            if (this.type != treeMethodExpression.type) {
                if (this.type != null && treeMethodExpression.type != null) {
                    return false;
                }
                if (this.isLiteralText() ? this.type != Object.class && treeMethodExpression.type != Object.class : this.type != null && treeMethodExpression.is_void || treeMethodExpression.type != null && this.is_void) {
                    return false;
                }
            }
            if (!this.isLiteralText() && !Arrays.equals(this.types, treeMethodExpression.types)) {
                return false;
            }
            return this.getStructuralId().equals(treeMethodExpression.getStructuralId()) && this.bindings.equals(treeMethodExpression.bindings);
        }
        return false;
    }

    public int hashCode() {
        return this.getStructuralId().hashCode();
    }

    public String toString() {
        return "TreeMethodExpression(" + this.expr + ")";
    }

    public void dump(PrintWriter printWriter) {
        NodePrinter.dump(printWriter, this.node);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.node = this.builder.build(this.expr).getRoot();
        }
        catch (ELException eLException) {
            throw new IOException(eLException.getMessage());
        }
    }
}

