/*
 * Decompiled with CFR 0.152.
 */
package jsc.kit.wheel.dialog;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;
import jsc.kit.wheel.base.IWheel;

public class DateItem
implements IWheel {
    public static final int TYPE_YEAR = 0;
    public static final int TYPE_MONTH = 1;
    public static final int TYPE_DAY = 2;
    public static final int TYPE_HOUR = 3;
    public static final int TYPE_MINUTE = 4;
    private int type;
    private int value;

    public DateItem() {
    }

    public DateItem(int value) {
        this(0, value);
    }

    public DateItem(int type, int value) {
        this.type = type;
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    @Override
    public String getShowText() {
        return String.format(Locale.CHINA, this.getFormatStringByType(), this.value < 10 ? "0" + this.value : "" + this.value);
    }

    private String getFormatStringByType() {
        String result = "";
        switch (this.type) {
            case 0: {
                result = "%s\u5e74";
                break;
            }
            case 1: {
                result = "%s\u6708";
                break;
            }
            case 2: {
                result = "%s\u65e5";
                break;
            }
            case 3: {
                result = "%s\u65f6";
                break;
            }
            case 4: {
                result = "%s\u5206";
            }
        }
        return result;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DateType {
    }
}

