/*
 * Decompiled with CFR 0.152.
 */
package jsc.kit.wheel.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.List;
import jsc.kit.wheel.R;
import jsc.kit.wheel.base.IWheel;
import jsc.kit.wheel.base.WheelItemView;

public class ColumnWheelDialog<T0 extends IWheel, T1 extends IWheel, T2 extends IWheel, T3 extends IWheel, T4 extends IWheel>
extends Dialog {
    private TextView tvTitle;
    private TextView tvCancel;
    private TextView tvOK;
    private WheelItemView wheelItemView0;
    private WheelItemView wheelItemView1;
    private WheelItemView wheelItemView2;
    private WheelItemView wheelItemView3;
    private WheelItemView wheelItemView4;
    private T0[] items0;
    private T1[] items1;
    private T2[] items2;
    private T3[] items3;
    private T4[] items4;
    private CharSequence clickTipsWhenIsScrolling = "Scrolling, wait a minute.";
    private OnClickCallBack<T0, T1, T2, T3, T4> cancelCallBack = null;
    private OnClickCallBack<T0, T1, T2, T3, T4> okCallBack = null;
    private boolean isViewInitialized = false;

    public ColumnWheelDialog(@NonNull Context context) {
        this(context, R.style.WheelDialog);
    }

    private ColumnWheelDialog(@NonNull Context context, int themeResId) {
        super(context, themeResId);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        if (this.getWindow() != null) {
            this.getWindow().setGravity(80);
            this.getWindow().setBackgroundDrawable(null);
            this.getWindow().getDecorView().setBackgroundColor(0);
        }
        this.setContentView(R.layout.wheel_dialog_base);
        this.initView();
    }

    private void initView() {
        this.isViewInitialized = true;
        LinearLayout lyPickerContainer = (LinearLayout)this.findViewById(R.id.wheel_id_picker_container);
        this.wheelItemView0 = new WheelItemView(lyPickerContainer.getContext());
        lyPickerContainer.addView((View)this.wheelItemView0, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        this.wheelItemView1 = new WheelItemView(lyPickerContainer.getContext());
        lyPickerContainer.addView((View)this.wheelItemView1, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        this.wheelItemView2 = new WheelItemView(lyPickerContainer.getContext());
        lyPickerContainer.addView((View)this.wheelItemView2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        this.wheelItemView3 = new WheelItemView(lyPickerContainer.getContext());
        lyPickerContainer.addView((View)this.wheelItemView3, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        this.wheelItemView4 = new WheelItemView(lyPickerContainer.getContext());
        lyPickerContainer.addView((View)this.wheelItemView4, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        this.tvTitle = (TextView)this.findViewById(R.id.wheel_id_title_bar_title);
        this.tvCancel = (TextView)this.findViewById(R.id.wheel_id_title_bar_cancel);
        this.tvOK = (TextView)this.findViewById(R.id.wheel_id_title_bar_ok);
        this.tvCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ColumnWheelDialog.this.cancelCallBack == null) {
                    ColumnWheelDialog.this.dismiss();
                    return;
                }
                if (!ColumnWheelDialog.this.cancelCallBack.callBack(v, ColumnWheelDialog.this.wheelItemView0.isShown() ? ColumnWheelDialog.this.items0[ColumnWheelDialog.this.wheelItemView0.getSelectedIndex()] : null, ColumnWheelDialog.this.wheelItemView1.isShown() ? ColumnWheelDialog.this.items1[ColumnWheelDialog.this.wheelItemView1.getSelectedIndex()] : null, ColumnWheelDialog.this.wheelItemView2.isShown() ? ColumnWheelDialog.this.items2[ColumnWheelDialog.this.wheelItemView2.getSelectedIndex()] : null, ColumnWheelDialog.this.wheelItemView3.isShown() ? ColumnWheelDialog.this.items3[ColumnWheelDialog.this.wheelItemView3.getSelectedIndex()] : null, ColumnWheelDialog.this.wheelItemView4.isShown() ? ColumnWheelDialog.this.items4[ColumnWheelDialog.this.wheelItemView4.getSelectedIndex()] : null)) {
                    ColumnWheelDialog.this.dismiss();
                }
            }
        });
        this.tvOK.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ColumnWheelDialog.this.okCallBack == null) {
                    ColumnWheelDialog.this.dismiss();
                    return;
                }
                if (ColumnWheelDialog.this.isScrolling()) {
                    if (!TextUtils.isEmpty((CharSequence)ColumnWheelDialog.this.clickTipsWhenIsScrolling)) {
                        Toast.makeText((Context)v.getContext(), (CharSequence)ColumnWheelDialog.this.clickTipsWhenIsScrolling, (int)0).show();
                    }
                    return;
                }
                if (!ColumnWheelDialog.this.okCallBack.callBack(v, ColumnWheelDialog.this.wheelItemView0.isShown() ? ColumnWheelDialog.this.items0[ColumnWheelDialog.this.wheelItemView0.getSelectedIndex()] : null, ColumnWheelDialog.this.wheelItemView1.isShown() ? ColumnWheelDialog.this.items1[ColumnWheelDialog.this.wheelItemView1.getSelectedIndex()] : null, ColumnWheelDialog.this.wheelItemView2.isShown() ? ColumnWheelDialog.this.items2[ColumnWheelDialog.this.wheelItemView2.getSelectedIndex()] : null, ColumnWheelDialog.this.wheelItemView3.isShown() ? ColumnWheelDialog.this.items3[ColumnWheelDialog.this.wheelItemView3.getSelectedIndex()] : null, ColumnWheelDialog.this.wheelItemView4.isShown() ? ColumnWheelDialog.this.items4[ColumnWheelDialog.this.wheelItemView4.getSelectedIndex()] : null)) {
                    ColumnWheelDialog.this.dismiss();
                }
            }
        });
    }

    public void show() {
        super.show();
        if (this.getWindow() != null) {
            this.getWindow().setLayout(-1, -2);
        }
    }

    public void setClickTipsWhenIsScrolling(CharSequence clickTipsWhenIsScrolling) {
        this.clickTipsWhenIsScrolling = clickTipsWhenIsScrolling;
    }

    public void setTitle(CharSequence title) {
        this.ensureIsViewInitialized();
        this.tvTitle.setText(title);
    }

    public void setOKButton(CharSequence ok, OnClickCallBack<T0, T1, T2, T3, T4> okCallBack) {
        this.ensureIsViewInitialized();
        this.tvOK.setText(ok);
        this.okCallBack = okCallBack;
    }

    public void setCancelButton(CharSequence cancel, OnClickCallBack<T0, T1, T2, T3, T4> cancelCallBack) {
        this.ensureIsViewInitialized();
        this.tvCancel.setText(cancel);
        this.cancelCallBack = cancelCallBack;
    }

    public void setItems(T0[] items0, T1[] items1, T2[] items2, T3[] items3, T4[] items4) {
        this.setItems((IWheel[])items0, (IWheel[])items1, (IWheel[])items2, (IWheel[])items3, (IWheel[])items4, -1);
    }

    public void setItems(T0[] items0, T1[] items1, T2[] items2, T3[] items3, T4[] items4, int totalOffsetX) {
        this.ensureIsViewInitialized();
        if (totalOffsetX == -1) {
            totalOffsetX = this.getContext().getResources().getDimensionPixelSize(R.dimen.wheel_picker_total_offset_x);
        }
        this.items0 = items0;
        this.items1 = items1;
        this.items2 = items2;
        this.items3 = items3;
        this.items4 = items4;
        this.updateShowPicker(this.wheelItemView0, (IWheel[])items0);
        this.updateShowPicker(this.wheelItemView1, (IWheel[])items1);
        this.updateShowPicker(this.wheelItemView2, (IWheel[])items2);
        this.updateShowPicker(this.wheelItemView3, (IWheel[])items3);
        this.updateShowPicker(this.wheelItemView4, (IWheel[])items4);
        this.updateOffsetX(totalOffsetX);
    }

    public void setSelected(int selected0, int selected1, int selected2, int selected3, int selected4) {
        this.executeSelected(this.wheelItemView0, selected0);
        this.executeSelected(this.wheelItemView1, selected1);
        this.executeSelected(this.wheelItemView2, selected2);
        this.executeSelected(this.wheelItemView3, selected3);
        this.executeSelected(this.wheelItemView4, selected4);
    }

    private boolean isScrolling() {
        return this.isScrolling(this.wheelItemView0) || this.isScrolling(this.wheelItemView1) || this.isScrolling(this.wheelItemView2) || this.isScrolling(this.wheelItemView3) || this.isScrolling(this.wheelItemView4);
    }

    private void ensureIsViewInitialized() {
        if (!this.isViewInitialized) {
            throw new IllegalStateException("View wasn't initialized, call show() first.");
        }
    }

    private void updateShowPicker(WheelItemView wheelItemView, IWheel[] items) {
        boolean hide = items == null || items.length == 0;
        wheelItemView.setVisibility(hide ? 8 : 0);
        if (!hide) {
            wheelItemView.setItems(items);
        }
    }

    private void executeSelected(WheelItemView view, int selectedIndex) {
        if (view.isShown()) {
            view.setSelectedIndex(selectedIndex);
        }
    }

    private void updateOffsetX(int totalOffsetX) {
        ArrayList<WheelItemView> views = new ArrayList<WheelItemView>();
        this.addVisibleView(views, this.wheelItemView0);
        this.addVisibleView(views, this.wheelItemView1);
        this.addVisibleView(views, this.wheelItemView2);
        this.addVisibleView(views, this.wheelItemView3);
        this.addVisibleView(views, this.wheelItemView4);
        for (int i = 0; i < views.size(); ++i) {
            ((WheelItemView)views.get(i)).setTotalOffsetX(0);
        }
        if (views.size() > 2) {
            ((WheelItemView)views.get(0)).setTotalOffsetX(totalOffsetX);
            ((WheelItemView)views.get(views.size() - 1)).setTotalOffsetX(-totalOffsetX);
        }
    }

    private void addVisibleView(List<WheelItemView> views, WheelItemView v) {
        if (v.isShown()) {
            views.add(v);
        }
    }

    private boolean isScrolling(WheelItemView view) {
        return view.isShown() && view.isScrolling();
    }

    public static interface OnClickCallBack<D0, D1, D2, D3, D4> {
        public boolean callBack(View var1, @Nullable D0 var2, @Nullable D1 var3, @Nullable D2 var4, @Nullable D3 var5, @Nullable D4 var6);
    }
}

