/*
 * Decompiled with CFR 0.152.
 */
package jsc.kit.wheel.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.TextView;
import jsc.kit.wheel.R;
import jsc.kit.wheel.base.IWheel;
import jsc.kit.wheel.base.WheelItemView;
import jsc.kit.wheel.dialog.WheelDialogInterface;

public class OneColumnWheelDialog<T extends IWheel>
extends Dialog {
    private TextView tvTitle;
    private TextView tvCancel;
    private TextView tvOK;
    private WheelItemView wheelItemView;
    private T[] items;
    private WheelDialogInterface<T> negativeDialogInterface = null;
    private WheelDialogInterface<T> positiveDialogInterface = null;

    public OneColumnWheelDialog(@NonNull Context context) {
        this(context, R.style.WheelDialog);
    }

    private OneColumnWheelDialog(@NonNull Context context, int themeResId) {
        super(context, themeResId);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        if (this.getWindow() != null) {
            this.getWindow().setGravity(80);
            this.getWindow().setBackgroundDrawable(null);
            this.getWindow().getDecorView().setBackgroundColor(0);
        }
        this.setContentView(R.layout.wheel_dialog_one_column);
        this.tvTitle = (TextView)this.findViewById(R.id.tv_title);
        this.tvCancel = (TextView)this.findViewById(R.id.tv_cancel);
        this.tvOK = (TextView)this.findViewById(R.id.tv_ok);
        this.wheelItemView = (WheelItemView)this.findViewById(R.id.wheel_item_view);
        this.tvCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (OneColumnWheelDialog.this.wheelItemView.isScrolling()) {
                    return;
                }
                if (OneColumnWheelDialog.this.negativeDialogInterface == null) {
                    OneColumnWheelDialog.this.dismiss();
                    return;
                }
                if (OneColumnWheelDialog.this.negativeDialogInterface.onClick(0, OneColumnWheelDialog.this.wheelItemView.getSelectedIndex(), OneColumnWheelDialog.this.items[OneColumnWheelDialog.this.wheelItemView.getSelectedIndex()])) {
                    OneColumnWheelDialog.this.dismiss();
                }
            }
        });
        this.tvOK.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (OneColumnWheelDialog.this.wheelItemView.isScrolling()) {
                    return;
                }
                if (OneColumnWheelDialog.this.positiveDialogInterface == null) {
                    OneColumnWheelDialog.this.dismiss();
                    return;
                }
                if (OneColumnWheelDialog.this.positiveDialogInterface.onClick(1, OneColumnWheelDialog.this.wheelItemView.getSelectedIndex(), OneColumnWheelDialog.this.items[OneColumnWheelDialog.this.wheelItemView.getSelectedIndex()])) {
                    OneColumnWheelDialog.this.dismiss();
                }
            }
        });
    }

    public void show() {
        super.show();
        if (this.getWindow() != null) {
            this.getWindow().setLayout(-1, -2);
        }
    }

    private void ensureIsShowing() {
        if (!this.isShowing()) {
            throw new IllegalStateException("Call show() first.");
        }
    }

    public void setTitle(CharSequence title) {
        this.ensureIsShowing();
        this.tvTitle.setText(title);
    }

    public void setPositiveButton(CharSequence positive, WheelDialogInterface<T> positiveDialogInterface) {
        this.ensureIsShowing();
        this.tvOK.setText(positive);
        this.positiveDialogInterface = positiveDialogInterface;
    }

    public void setNegativeButton(CharSequence negative, WheelDialogInterface<T> negativeDialogInterface) {
        this.ensureIsShowing();
        this.tvCancel.setText(negative);
        this.negativeDialogInterface = negativeDialogInterface;
    }

    public void setItems(T[] items) {
        this.ensureIsShowing();
        this.items = items;
        this.wheelItemView.setItems((IWheel[])items);
    }

    public void setSelectedIndex(int index) {
        this.ensureIsShowing();
        this.wheelItemView.setSelectedIndex(index);
    }
}

