/*
 * Decompiled with CFR 0.152.
 */
package jsc.kit.cameramask;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import jsc.kit.cameramask.R;

public class ScannerBarView
extends ViewGroup {
    private ImageView scannerBar;
    private ObjectAnimator animator = null;

    public ScannerBarView(Context context) {
        super(context);
        this.initView(context);
        this.init(context, null, 0);
    }

    public ScannerBarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
        this.init(context, attrs, 0);
    }

    public ScannerBarView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
        this.init(context, attrs, defStyleAttr);
    }

    private void initView(Context context) {
        this.scannerBar = new ImageView(context);
        this.scannerBar.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.addView((View)this.scannerBar, new ViewGroup.LayoutParams(-1, -2));
    }

    public void init(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ScannerBarView, defStyleAttr, 0);
        this.scannerBar.setImageResource(a.getResourceId(R.styleable.ScannerBarView_sbvSrc, R.drawable.camera_mask_scanner_bar));
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.getChildCount() > 0) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                child.layout(0, 0 - child.getMeasuredHeight(), child.getMeasuredWidth(), 0);
            }
        }
    }

    public void setScannerBarImageResource(@DrawableRes int drawable2) {
        this.scannerBar.setImageResource(drawable2);
        this.executeRequestLayout();
    }

    public void setScannerBarImageBitmap(Bitmap bitmap) {
        this.scannerBar.setImageBitmap(bitmap);
        this.executeRequestLayout();
    }

    public void start() {
        if (this.animator == null) {
            this.animator = ObjectAnimator.ofFloat((Object)this.scannerBar, (Property)View.TRANSLATION_Y, (float[])new float[]{0.0f, this.getHeight() + this.scannerBar.getHeight()});
            this.animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.animator.setDuration(2000L);
            this.animator.setRepeatCount(-1);
            this.animator.start();
        }
    }

    public void pause() {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.pause();
        }
    }

    public void resume() {
        if (this.animator != null && this.animator.isPaused()) {
            this.animator.resume();
        }
    }

    public void stop() {
        this.scannerBar.setTranslationY(0.0f);
        if (this.animator != null && this.animator.isStarted()) {
            this.animator.cancel();
            this.animator = null;
        }
    }

    public boolean isRunning() {
        return this.animator != null && this.animator.isRunning();
    }

    private void executeRequestLayout() {
        boolean needRestart = this.isRunning();
        this.stop();
        this.requestLayout();
        if (needRestart) {
            this.start();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.executeRequestLayout();
    }

    protected void onDetachedFromWindow() {
        this.stop();
        super.onDetachedFromWindow();
    }
}

