/*
 * Decompiled with CFR 0.152.
 */
package jsc.kit.cameramask;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import jsc.kit.cameramask.R;

public class CameraLensView
extends View {
    public static final int CAMERA_LENS_SHAPE_SQUARE = 0;
    public static final int CAMERA_LENS_SHAPE_CIRCULAR = 1;
    public static final int BELOW_CAMERA_LENS = 0;
    public static final int ABOVE_CAMERA_LENS = 1;
    protected Paint paint = new Paint(1);
    private Xfermode xfermode = new PorterDuffXfermode(PorterDuff.Mode.CLEAR);
    private RectF rectF = new RectF();
    private Rect cameraLensRect = new Rect();
    private Matrix cameraLensMatrix = new Matrix();
    private Bitmap cameraLensBitmap;
    private int cameraLensShape;
    private int maskColor;
    private int boxBorderColor;
    private int boxBorderWidth;
    private Path boxAnglePath;
    private int boxAngleColor;
    private int boxAngleBorderWidth;
    private int boxAngleLength;
    private int cameraLensTopMargin;
    private float cameraLensSizeRatio;
    protected TextPaint textPaint = new TextPaint(1);
    protected StaticLayout textStaticLayout;
    private String text;
    private boolean textMathParent;
    private int textLocation;
    private int textVerticalMargin;
    private int textLeftMargin;
    private int textRightMargin;
    private Runnable r = new Runnable(){

        @Override
        public void run() {
            CameraLensView.this.updateStaticLayout();
            CameraLensView.this.invalidate();
        }
    };

    public CameraLensView(@NonNull Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public CameraLensView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public CameraLensView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public CameraLensView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr);
    }

    public void init(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        int resId;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CameraLensView, defStyleAttr, 0);
        this.cameraLensTopMargin = a.getDimensionPixelSize(R.styleable.CameraLensView_clvCameraLensTopMargin, 0);
        if (a.hasValue(R.styleable.CameraLensView_clvCameraLens) && (resId = a.getResourceId(R.styleable.CameraLensView_clvCameraLens, -1)) != -1) {
            this.cameraLensBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)resId);
        }
        this.cameraLensShape = a.getInt(R.styleable.CameraLensView_clvCameraLensShape, 0);
        this.boxBorderColor = a.getColor(R.styleable.CameraLensView_clvBoxBorderColor, -1711276033);
        this.boxBorderWidth = a.getDimensionPixelSize(R.styleable.CameraLensView_clvBoxBorderWidth, 2);
        this.boxAngleColor = a.getColor(R.styleable.CameraLensView_clvBoxAngleColor, -256);
        int defaultScannerBoxAngleBorderWidth = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.boxAngleBorderWidth = a.getDimensionPixelSize(R.styleable.CameraLensView_clvBoxAngleBorderWidth, defaultScannerBoxAngleBorderWidth);
        int defaultScannerBoxAngleLength = (int)TypedValue.applyDimension((int)1, (float)16.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.boxAngleLength = a.getDimensionPixelSize(R.styleable.CameraLensView_clvBoxAngleLength, defaultScannerBoxAngleLength);
        this.maskColor = a.getColor(R.styleable.CameraLensView_clvMaskColor, -1728053248);
        this.cameraLensSizeRatio = a.getFloat(R.styleable.CameraLensView_clvCameraLensSizeRatio, 0.6f);
        if (this.cameraLensSizeRatio < 0.3f) {
            this.cameraLensSizeRatio = 0.3f;
        }
        if (this.cameraLensSizeRatio > 1.0f) {
            this.cameraLensSizeRatio = 1.0f;
        }
        this.text = a.getString(R.styleable.CameraLensView_clvText);
        int textColor = a.getColor(R.styleable.CameraLensView_clvTextColor, -1);
        int defaultTextSize = (int)(TypedValue.applyDimension((int)2, (float)12.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()) + 0.5f);
        float textSize = a.getDimension(R.styleable.CameraLensView_clvTextSize, (float)defaultTextSize);
        this.textMathParent = a.getBoolean(R.styleable.CameraLensView_clvTextMathParent, false);
        this.textLocation = a.getInt(R.styleable.CameraLensView_clvTextLocation, 0);
        this.textVerticalMargin = a.getDimensionPixelSize(R.styleable.CameraLensView_clvTextVerticalMargin, 0);
        this.textLeftMargin = a.getDimensionPixelSize(R.styleable.CameraLensView_clvTextLeftMargin, 0);
        this.textRightMargin = a.getDimensionPixelSize(R.styleable.CameraLensView_clvTextRightMargin, 0);
        a.recycle();
        this.textPaint.setColor(textColor);
        this.textPaint.setTextSize(textSize);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.initCameraLensSize(this.getMeasuredWidth());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawMask(canvas, this.cameraLensShape);
        float translateX = 0.0f;
        float translateY = 0.0f;
        if (this.cameraLensBitmap != null) {
            translateX = this.cameraLensRect.left;
            translateY = this.cameraLensTopMargin;
            float scale = (float)this.cameraLensRect.width() * 1.0f / (float)this.cameraLensBitmap.getWidth();
            this.cameraLensMatrix.setScale(scale, scale);
            canvas.save();
            canvas.translate(translateX, translateY);
            canvas.drawBitmap(this.cameraLensBitmap, this.cameraLensMatrix, null);
            canvas.translate(-translateX, -translateY);
            canvas.restore();
        } else {
            this.paint.setStyle(Paint.Style.STROKE);
            switch (this.cameraLensShape) {
                case 0: {
                    if (this.boxAnglePath == null) {
                        this.boxAnglePath = new Path();
                    }
                    this.paint.setStrokeWidth((float)this.boxBorderWidth);
                    this.paint.setColor(this.boxBorderColor);
                    canvas.drawRect(this.cameraLensRect, this.paint);
                    this.paint.setStrokeWidth((float)this.boxAngleBorderWidth);
                    this.paint.setColor(this.boxAngleColor);
                    this.boxAnglePath.reset();
                    this.boxAnglePath.moveTo((float)this.cameraLensRect.left, (float)(this.cameraLensRect.top + this.boxAngleLength));
                    this.boxAnglePath.lineTo((float)this.cameraLensRect.left, (float)this.cameraLensRect.top);
                    this.boxAnglePath.lineTo((float)(this.cameraLensRect.left + this.boxAngleLength), (float)this.cameraLensRect.top);
                    canvas.drawPath(this.boxAnglePath, this.paint);
                    this.boxAnglePath.reset();
                    this.boxAnglePath.moveTo((float)(this.cameraLensRect.right - this.boxAngleLength), (float)this.cameraLensRect.top);
                    this.boxAnglePath.lineTo((float)this.cameraLensRect.right, (float)this.cameraLensRect.top);
                    this.boxAnglePath.lineTo((float)this.cameraLensRect.right, (float)(this.cameraLensRect.top + this.boxAngleLength));
                    canvas.drawPath(this.boxAnglePath, this.paint);
                    this.boxAnglePath.reset();
                    this.boxAnglePath.moveTo((float)this.cameraLensRect.right, (float)(this.cameraLensRect.bottom - this.boxAngleLength));
                    this.boxAnglePath.lineTo((float)this.cameraLensRect.right, (float)this.cameraLensRect.bottom);
                    this.boxAnglePath.lineTo((float)(this.cameraLensRect.right - this.boxAngleLength), (float)this.cameraLensRect.bottom);
                    canvas.drawPath(this.boxAnglePath, this.paint);
                    this.boxAnglePath.reset();
                    this.boxAnglePath.moveTo((float)(this.cameraLensRect.left + this.boxAngleLength), (float)this.cameraLensRect.bottom);
                    this.boxAnglePath.lineTo((float)this.cameraLensRect.left, (float)this.cameraLensRect.bottom);
                    this.boxAnglePath.lineTo((float)this.cameraLensRect.left, (float)(this.cameraLensRect.bottom - this.boxAngleLength));
                    canvas.drawPath(this.boxAnglePath, this.paint);
                    break;
                }
                case 1: {
                    this.paint.setStrokeWidth((float)this.boxBorderWidth);
                    this.paint.setColor(this.boxBorderColor);
                    float cx = (float)this.cameraLensRect.left + (float)this.cameraLensRect.width() / 2.0f;
                    float cy = (float)this.cameraLensRect.top + (float)this.cameraLensRect.height() / 2.0f;
                    float radius = (float)this.cameraLensRect.width() / 2.0f - (float)this.boxBorderWidth / 2.0f;
                    canvas.drawCircle(cx, cy, radius, this.paint);
                    this.paint.setStrokeWidth((float)this.boxAngleBorderWidth);
                    this.paint.setColor(this.boxAngleColor);
                    float halfBoxAngleBorderWidth = (float)this.boxAngleBorderWidth / 16.0f;
                    this.rectF.set(cx - radius - halfBoxAngleBorderWidth, cy - radius - halfBoxAngleBorderWidth, cx + radius + halfBoxAngleBorderWidth, cy + radius + halfBoxAngleBorderWidth);
                    float angle = (float)((double)(this.boxAngleLength * 180) / (Math.PI * (double)radius));
                    float startAngle = 225.0f - angle / 2.0f;
                    canvas.drawArc(this.rectF, startAngle, angle, false, this.paint);
                    startAngle = 315.0f - angle / 2.0f;
                    canvas.drawArc(this.rectF, startAngle, angle, false, this.paint);
                    startAngle = 45.0f - angle / 2.0f;
                    canvas.drawArc(this.rectF, startAngle, angle, false, this.paint);
                    startAngle = 135.0f - angle / 2.0f;
                    canvas.drawArc(this.rectF, startAngle, angle, false, this.paint);
                }
            }
        }
        if (this.textStaticLayout != null) {
            canvas.save();
            translateX = this.textMathParent ? 0.0f : (float)this.cameraLensRect.left;
            translateY = this.textLocation == 0 ? (float)(this.cameraLensRect.bottom + this.textVerticalMargin) : (float)(this.cameraLensRect.top - this.textVerticalMargin - this.textStaticLayout.getHeight());
            canvas.translate(translateX += (float)this.textLeftMargin, translateY);
            this.textStaticLayout.draw(canvas);
            canvas.translate(-translateX, -translateY);
            canvas.restore();
        }
    }

    private void initCameraLensSize(int width) {
        int cameraLensSize = (int)((float)width * this.cameraLensSizeRatio);
        int left = (width - cameraLensSize) / 2;
        this.cameraLensRect.set(left, this.cameraLensTopMargin, left + cameraLensSize, this.cameraLensTopMargin + cameraLensSize);
        this.updateStaticLayout();
    }

    private void drawMask(Canvas canvas, int maskShape) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas mCanvas = new Canvas(bitmap);
        this.paint.setColor(this.maskColor);
        this.paint.setStyle(Paint.Style.FILL);
        mCanvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.paint);
        this.paint.setXfermode(this.xfermode);
        switch (maskShape) {
            case 0: {
                mCanvas.drawRect(this.cameraLensRect, this.paint);
                break;
            }
            case 1: {
                float radius = (float)this.cameraLensRect.height() / 2.0f;
                mCanvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.cameraLensRect.top + radius, radius, this.paint);
            }
        }
        this.paint.setXfermode(null);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
    }

    private void executeInvalidateDelay() {
        this.removeCallbacks(this.r);
        this.postDelayed(this.r, 10L);
    }

    private void updateStaticLayout() {
        if (this.text == null || this.text.trim().length() == 0) {
            this.textStaticLayout = null;
            return;
        }
        int textWidth = this.textMathParent ? this.getWidth() : this.cameraLensRect.width();
        textWidth = textWidth - this.textLeftMargin - this.textRightMargin;
        this.textStaticLayout = Build.VERSION.SDK_INT >= 23 ? StaticLayout.Builder.obtain((CharSequence)this.text, (int)0, (int)this.text.length(), (TextPaint)this.textPaint, (int)textWidth).setAlignment(Layout.Alignment.ALIGN_CENTER).setLineSpacing(0.0f, 1.0f).build() : new StaticLayout((CharSequence)this.text, this.textPaint, textWidth, Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, true);
    }

    public Bitmap cropCameraLensRectBitmap(Bitmap src, boolean withRatio) {
        if (src == null) {
            return null;
        }
        int sw = src.getWidth();
        int sh = src.getHeight();
        if (!withRatio) {
            return Bitmap.createBitmap((Bitmap)src, (int)this.cameraLensRect.left, (int)this.cameraLensRect.top, (int)this.cameraLensRect.width(), (int)this.cameraLensRect.height());
        }
        int l = sw * this.cameraLensRect.left / this.getWidth();
        int t = sh * this.cameraLensRect.top / this.getHeight();
        int r = sw * this.cameraLensRect.right / this.getWidth();
        int b = sh * this.cameraLensRect.bottom / this.getHeight();
        return Bitmap.createBitmap((Bitmap)src, (int)l, (int)t, (int)(r - l), (int)(b - t));
    }

    @NonNull
    public Rect getCameraLensRect() {
        return this.cameraLensRect;
    }

    public Bitmap getCameraLensBitmap() {
        return this.cameraLensBitmap;
    }

    public void setCameraLensBitmap(Bitmap cameraLensBitmap) {
        this.cameraLensBitmap = cameraLensBitmap;
        this.executeInvalidateDelay();
    }

    public int getMaskColor() {
        return this.maskColor;
    }

    public void setMaskColor(@ColorInt int maskColor) {
        this.maskColor = maskColor;
        this.executeInvalidateDelay();
    }

    public int getBoxBorderColor() {
        return this.boxBorderColor;
    }

    public void setBoxBorderColor(@ColorInt int boxBorderColor) {
        this.boxBorderColor = boxBorderColor;
        this.executeInvalidateDelay();
    }

    public int getBoxBorderWidth() {
        return this.boxBorderWidth;
    }

    public void setBoxBorderWidth(int boxBorderWidth) {
        this.boxBorderWidth = boxBorderWidth;
        this.executeInvalidateDelay();
    }

    public int getBoxAngleColor() {
        return this.boxAngleColor;
    }

    public void setBoxAngleColor(@ColorInt int boxAngleColor) {
        this.boxAngleColor = boxAngleColor;
        this.executeInvalidateDelay();
    }

    public int getBoxAngleBorderWidth() {
        return this.boxAngleBorderWidth;
    }

    public void setBoxAngleBorderWidth(int boxAngleBorderWidth) {
        this.boxAngleBorderWidth = boxAngleBorderWidth;
        this.executeInvalidateDelay();
    }

    public int getBoxAngleLength() {
        return this.boxAngleLength;
    }

    public void setBoxAngleLength(int boxAngleLength) {
        this.boxAngleLength = boxAngleLength;
        this.executeInvalidateDelay();
    }

    public int getCameraLensTopMargin() {
        return this.cameraLensTopMargin;
    }

    public void setCameraLensTopMargin(int cameraLensTopMargin) {
        this.cameraLensTopMargin = cameraLensTopMargin;
        this.requestLayout();
    }

    public float getCameraLensSizeRatio() {
        return this.cameraLensSizeRatio;
    }

    public void setCameraLensSizeRatio(@FloatRange(from=0.0, to=1.0) float cameraLensSizeRatio) {
        this.cameraLensSizeRatio = cameraLensSizeRatio;
        this.requestLayout();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.executeInvalidateDelay();
    }

    public boolean isTextMathParent() {
        return this.textMathParent;
    }

    public void setTextMathParent(boolean textMathParent) {
        this.textMathParent = textMathParent;
        this.executeInvalidateDelay();
    }

    public int getTextLocation() {
        return this.textLocation;
    }

    public void setTextLocation(int textLocation) {
        this.textLocation = textLocation;
        this.executeInvalidateDelay();
    }

    public int getTextVerticalMargin() {
        return this.textVerticalMargin;
    }

    public void setTextVerticalMargin(int textVerticalMargin) {
        this.textVerticalMargin = textVerticalMargin;
        this.executeInvalidateDelay();
    }

    public int getTextLeftMargin() {
        return this.textLeftMargin;
    }

    public void setTextLeftMargin(int textLeftMargin) {
        this.textLeftMargin = textLeftMargin;
        this.executeInvalidateDelay();
    }

    public int getTextRightMargin() {
        return this.textRightMargin;
    }

    public void setTextRightMargin(int textRightMargin) {
        this.textRightMargin = textRightMargin;
        this.executeInvalidateDelay();
    }

    public int getCameraLensShape() {
        return this.cameraLensShape;
    }

    public void setCameraLensShape(int cameraLensShape) {
        this.cameraLensShape = cameraLensShape;
        this.executeInvalidateDelay();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TextLocation {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CameraLensShape {
    }
}

