/*
 * Decompiled with CFR 0.152.
 */
package jsc.kit.cameramask;

import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import jsc.kit.cameramask.CameraLensView;
import jsc.kit.cameramask.ScannerBarView;

public class CameraScannerMaskView
extends FrameLayout {
    private ScannerBarView scannerBarView;
    private CameraLensView cameraLensView;

    public CameraScannerMaskView(@NonNull Context context) {
        this(context, null);
    }

    public CameraScannerMaskView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CameraScannerMaskView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.cameraLensView = new CameraLensView(context, attrs, defStyleAttr);
        this.scannerBarView = new ScannerBarView(context, attrs, defStyleAttr);
        this.addView(this.cameraLensView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.addView((View)this.scannerBarView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.scannerBarView.getLayoutParams();
        Rect rect = this.cameraLensView.getCameraLensRect();
        params.width = rect.width();
        params.height = rect.height();
        params.leftMargin = rect.left;
        params.topMargin = rect.top;
        this.scannerBarView.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void start() {
        this.scannerBarView.start();
    }

    public void pause() {
        this.scannerBarView.pause();
    }

    public void resume() {
        this.scannerBarView.resume();
    }

    public void stop() {
        this.scannerBarView.stop();
    }
}

