/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.picasso.transformations;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.Log;
import com.squareup.picasso.Transformation;

public class CropTransformation
implements Transformation {
    private static final String TAG = "PicassoTransformation";
    private float mAspectRatio;
    private int mLeft;
    private int mTop;
    private int mWidth;
    private int mHeight;
    private float mWidthRatio;
    private float mHeightRatio;
    private GravityHorizontal mGravityHorizontal = GravityHorizontal.CENTER;
    private GravityVertical mGravityVertical = GravityVertical.CENTER;

    public CropTransformation(int left, int top, int width, int height) {
        this.mLeft = left;
        this.mTop = top;
        this.mWidth = width;
        this.mHeight = height;
    }

    public CropTransformation(int width, int height, GravityHorizontal gravityHorizontal, GravityVertical gravityVertical) {
        this.mWidth = width;
        this.mHeight = height;
        this.mGravityHorizontal = gravityHorizontal;
        this.mGravityVertical = gravityVertical;
    }

    public CropTransformation(int width, int height) {
        this(width, height, GravityHorizontal.CENTER, GravityVertical.CENTER);
    }

    public CropTransformation(float widthRatio, float heightRatio, GravityHorizontal gravityHorizontal, GravityVertical gravityVertical) {
        this.mWidthRatio = widthRatio;
        this.mHeightRatio = heightRatio;
        this.mGravityHorizontal = gravityHorizontal;
        this.mGravityVertical = gravityVertical;
    }

    public CropTransformation(float widthRatio, float heightRatio) {
        this(widthRatio, heightRatio, GravityHorizontal.CENTER, GravityVertical.CENTER);
    }

    public CropTransformation(int width, int height, float aspectRatio, GravityHorizontal gravityHorizontal, GravityVertical gravityVertical) {
        this.mWidth = width;
        this.mHeight = height;
        this.mAspectRatio = aspectRatio;
        this.mGravityHorizontal = gravityHorizontal;
        this.mGravityVertical = gravityVertical;
    }

    public CropTransformation(float widthRatio, float heightRatio, float aspectRatio, GravityHorizontal gravityHorizontal, GravityVertical gravityVertical) {
        this.mWidthRatio = widthRatio;
        this.mHeightRatio = heightRatio;
        this.mAspectRatio = aspectRatio;
        this.mGravityHorizontal = gravityHorizontal;
        this.mGravityVertical = gravityVertical;
    }

    public CropTransformation(float aspectRatio, GravityHorizontal gravityHorizontal, GravityVertical gravityVertical) {
        this.mAspectRatio = aspectRatio;
        this.mGravityHorizontal = gravityHorizontal;
        this.mGravityVertical = gravityVertical;
    }

    public Bitmap transform(Bitmap source) {
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("transform(): called, " + this.key()));
        }
        if (this.mWidth == 0 && this.mWidthRatio != 0.0f) {
            this.mWidth = (int)((float)source.getWidth() * this.mWidthRatio);
        }
        if (this.mHeight == 0 && this.mHeightRatio != 0.0f) {
            this.mHeight = (int)((float)source.getHeight() * this.mHeightRatio);
        }
        if (this.mAspectRatio != 0.0f) {
            if (this.mWidth == 0 && this.mHeight == 0) {
                float sourceRatio = (float)source.getWidth() / (float)source.getHeight();
                if (Log.isLoggable((String)TAG, (int)2)) {
                    Log.v((String)TAG, (String)("transform(): mAspectRatio: " + this.mAspectRatio + ", sourceRatio: " + sourceRatio));
                }
                if (sourceRatio > this.mAspectRatio) {
                    this.mHeight = source.getHeight();
                } else {
                    this.mWidth = source.getWidth();
                }
            }
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("transform(): before setting other of h/w: mAspectRatio: " + this.mAspectRatio + ", set one of width: " + this.mWidth + ", height: " + this.mHeight));
            }
            if (this.mWidth != 0) {
                this.mHeight = (int)((float)this.mWidth / this.mAspectRatio);
            } else if (this.mHeight != 0) {
                this.mWidth = (int)((float)this.mHeight * this.mAspectRatio);
            }
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("transform(): mAspectRatio: " + this.mAspectRatio + ", set width: " + this.mWidth + ", height: " + this.mHeight));
            }
        }
        if (this.mWidth == 0) {
            this.mWidth = source.getWidth();
        }
        if (this.mHeight == 0) {
            this.mHeight = source.getHeight();
        }
        if (this.mGravityHorizontal != null) {
            this.mLeft = this.getLeft(source);
        }
        if (this.mGravityVertical != null) {
            this.mTop = this.getTop(source);
        }
        Rect sourceRect = new Rect(this.mLeft, this.mTop, this.mLeft + this.mWidth, this.mTop + this.mHeight);
        Rect targetRect = new Rect(0, 0, this.mWidth, this.mHeight);
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("transform(): created sourceRect with mLeft: " + this.mLeft + ", mTop: " + this.mTop + ", right: " + (this.mLeft + this.mWidth) + ", bottom: " + (this.mTop + this.mHeight)));
        }
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("transform(): created targetRect with width: " + this.mWidth + ", height: " + this.mHeight));
        }
        Bitmap bitmap = Bitmap.createBitmap((int)this.mWidth, (int)this.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("transform(): copying from source with width: " + source.getWidth() + ", height: " + source.getHeight()));
        }
        canvas.drawBitmap(source, sourceRect, targetRect, null);
        source.recycle();
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("transform(): returning bitmap with width: " + bitmap.getWidth() + ", height: " + bitmap.getHeight()));
        }
        return bitmap;
    }

    public String key() {
        return "CropTransformation(width=" + this.mWidth + ", height=" + this.mHeight + ", mWidthRatio=" + this.mWidthRatio + ", mHeightRatio=" + this.mHeightRatio + ", mAspectRatio=" + this.mAspectRatio + ", gravityHorizontal=" + (Object)((Object)this.mGravityHorizontal) + ", mGravityVertical=" + (Object)((Object)this.mGravityVertical) + ")";
    }

    private int getTop(Bitmap source) {
        switch (this.mGravityVertical) {
            case TOP: {
                return 0;
            }
            case CENTER: {
                return (source.getHeight() - this.mHeight) / 2;
            }
            case BOTTOM: {
                return source.getHeight() - this.mHeight;
            }
        }
        return 0;
    }

    private int getLeft(Bitmap source) {
        switch (this.mGravityHorizontal) {
            case LEFT: {
                return 0;
            }
            case CENTER: {
                return (source.getWidth() - this.mWidth) / 2;
            }
            case RIGHT: {
                return source.getWidth() - this.mWidth;
            }
        }
        return 0;
    }

    public static enum GravityVertical {
        TOP,
        CENTER,
        BOTTOM;

    }

    public static enum GravityHorizontal {
        LEFT,
        CENTER,
        RIGHT;

    }
}

