/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.picasso.transformations;

import android.graphics.Bitmap;
import com.squareup.picasso.Transformation;

public class CropSquareTransformation
implements Transformation {
    private int mWidth;
    private int mHeight;

    public Bitmap transform(Bitmap source) {
        int size = Math.min(source.getWidth(), source.getHeight());
        this.mWidth = (source.getWidth() - size) / 2;
        this.mHeight = (source.getHeight() - size) / 2;
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)source, (int)this.mWidth, (int)this.mHeight, (int)size, (int)size);
        if (bitmap != source) {
            source.recycle();
        }
        return bitmap;
    }

    public String key() {
        return "CropSquareTransformation(width=" + this.mWidth + ", height=" + this.mHeight + ")";
    }
}

