/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations.gpu;

import android.graphics.PointF;
import androidx.annotation.NonNull;
import java.security.MessageDigest;
import java.util.Arrays;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageVignetteFilter;
import jp.wasabeef.glide.transformations.gpu.GPUFilterTransformation;

public class VignetteFilterTransformation
extends GPUFilterTransformation {
    private static final int VERSION = 1;
    private static final String ID = "jp.wasabeef.glide.transformations.gpu.VignetteFilterTransformation.1";
    private final PointF center;
    private final float[] vignetteColor;
    private final float vignetteStart;
    private final float vignetteEnd;

    public VignetteFilterTransformation() {
        this(new PointF(0.5f, 0.5f), new float[]{0.0f, 0.0f, 0.0f}, 0.0f, 0.75f);
    }

    public VignetteFilterTransformation(PointF center, float[] color, float start, float end) {
        super((GPUImageFilter)new GPUImageVignetteFilter());
        this.center = center;
        this.vignetteColor = color;
        this.vignetteStart = start;
        this.vignetteEnd = end;
        GPUImageVignetteFilter filter = (GPUImageVignetteFilter)this.getFilter();
        filter.setVignetteCenter(this.center);
        filter.setVignetteColor(this.vignetteColor);
        filter.setVignetteStart(this.vignetteStart);
        filter.setVignetteEnd(this.vignetteEnd);
    }

    @Override
    public String toString() {
        return "VignetteFilterTransformation(center=" + this.center.toString() + ",color=" + Arrays.toString(this.vignetteColor) + ",start=" + this.vignetteStart + ",end=" + this.vignetteEnd + ")";
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof VignetteFilterTransformation && ((VignetteFilterTransformation)o).center.equals(this.center.x, this.center.y) && Arrays.equals(((VignetteFilterTransformation)o).vignetteColor, this.vignetteColor) && ((VignetteFilterTransformation)o).vignetteStart == this.vignetteStart && ((VignetteFilterTransformation)o).vignetteEnd == this.vignetteEnd;
    }

    @Override
    public int hashCode() {
        return ID.hashCode() + this.center.hashCode() + Arrays.hashCode(this.vignetteColor) + (int)(this.vignetteStart * 100.0f) + (int)(this.vignetteEnd * 10.0f);
    }

    @Override
    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update((ID + this.center + Arrays.hashCode(this.vignetteColor) + this.vignetteStart + this.vignetteEnd).getBytes(CHARSET));
    }
}

