/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations.gpu;

import androidx.annotation.NonNull;
import java.security.MessageDigest;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageBrightnessFilter;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;
import jp.wasabeef.glide.transformations.gpu.GPUFilterTransformation;

public class BrightnessFilterTransformation
extends GPUFilterTransformation {
    private static final int VERSION = 1;
    private static final String ID = "jp.wasabeef.glide.transformations.gpu.BrightnessFilterTransformation.1";
    private final float brightness;

    public BrightnessFilterTransformation() {
        this(0.0f);
    }

    public BrightnessFilterTransformation(float brightness) {
        super((GPUImageFilter)new GPUImageBrightnessFilter());
        this.brightness = brightness;
        GPUImageBrightnessFilter filter = (GPUImageBrightnessFilter)this.getFilter();
        filter.setBrightness(this.brightness);
    }

    @Override
    public String toString() {
        return "BrightnessFilterTransformation(brightness=" + this.brightness + ")";
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof BrightnessFilterTransformation && ((BrightnessFilterTransformation)o).brightness == this.brightness;
    }

    @Override
    public int hashCode() {
        return ID.hashCode() + (int)((this.brightness + 1.0f) * 10.0f);
    }

    @Override
    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update((ID + this.brightness).getBytes(CHARSET));
    }
}

