/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.TransformationUtils;
import java.security.MessageDigest;
import jp.wasabeef.glide.transformations.BitmapTransformation;
import jp.wasabeef.glide.transformations.internal.Utils;

public class CropCircleWithBorderTransformation
extends BitmapTransformation {
    private static final int VERSION = 1;
    private static final String ID = "jp.wasabeef.glide.transformations.CropCircleWithBorderTransformation.1";
    private int borderSize;
    private int borderColor;

    public CropCircleWithBorderTransformation() {
        this.borderSize = Utils.toDp(4);
        this.borderColor = -16777216;
    }

    public CropCircleWithBorderTransformation(int borderSize, @ColorInt int borderColor) {
        this.borderSize = borderSize;
        this.borderColor = borderColor;
    }

    @Override
    protected Bitmap transform(@NonNull Context context, @NonNull BitmapPool pool, @NonNull Bitmap toTransform, int outWidth, int outHeight) {
        Bitmap bitmap = TransformationUtils.circleCrop((BitmapPool)pool, (Bitmap)toTransform, (int)outWidth, (int)outHeight);
        this.setCanvasBitmapDensity(toTransform, bitmap);
        Paint paint = new Paint();
        paint.setColor(this.borderColor);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth((float)this.borderSize);
        paint.setAntiAlias(true);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawCircle((float)outWidth / 2.0f, (float)outHeight / 2.0f, (float)Math.max(outWidth, outHeight) / 2.0f - (float)this.borderSize / 2.0f, paint);
        return bitmap;
    }

    @Override
    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update((ID + this.borderSize + this.borderColor).getBytes(CHARSET));
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof CropCircleWithBorderTransformation && ((CropCircleWithBorderTransformation)o).borderSize == this.borderSize && ((CropCircleWithBorderTransformation)o).borderColor == this.borderColor;
    }

    @Override
    public int hashCode() {
        return ID.hashCode() + this.borderSize * 100 + this.borderColor + 10;
    }
}

