/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;

public class GrayscaleTransformation
implements Transformation<Bitmap> {
    private BitmapPool mBitmapPool;

    public GrayscaleTransformation(BitmapPool pool) {
        this.mBitmapPool = pool;
    }

    public Resource<Bitmap> transform(Resource<Bitmap> resource, int outWidth, int outHeight) {
        Bitmap.Config config;
        int height;
        Bitmap source = (Bitmap)resource.get();
        int width = source.getWidth();
        Bitmap bitmap = this.mBitmapPool.get(width, height = source.getHeight(), config = source.getConfig() != null ? source.getConfig() : Bitmap.Config.ARGB_8888);
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        }
        Canvas canvas = new Canvas(bitmap);
        ColorMatrix saturation = new ColorMatrix();
        saturation.setSaturation(0.0f);
        Paint paint = new Paint();
        paint.setColorFilter((ColorFilter)new ColorMatrixColorFilter(saturation));
        canvas.drawBitmap(source, 0.0f, 0.0f, paint);
        return BitmapResource.obtain((Bitmap)bitmap, (BitmapPool)this.mBitmapPool);
    }

    public String getId() {
        return "GrayscaleTransformation()";
    }
}

