/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations.gpu;

import android.content.Context;
import android.graphics.Bitmap;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import jp.co.cyberagent.android.gpuimage.GPUImage;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.GPUImageSepiaFilter;

public class SepiaFilterTransformation
implements Transformation<Bitmap> {
    private Context mContext;
    private BitmapPool mBitmapPool;
    private GPUImageSepiaFilter mFilter = new GPUImageSepiaFilter();
    private float mIntensity;

    public SepiaFilterTransformation(Context context, BitmapPool pool) {
        this.mContext = context;
        this.mBitmapPool = pool;
    }

    public SepiaFilterTransformation(Context context, BitmapPool pool, float intensity) {
        this.mContext = context;
        this.mBitmapPool = pool;
        this.mIntensity = intensity;
        this.mFilter.setIntensity(this.mIntensity);
    }

    public Resource<Bitmap> transform(Resource<Bitmap> resource, int outWidth, int outHeight) {
        Bitmap source = (Bitmap)resource.get();
        GPUImage gpuImage = new GPUImage(this.mContext);
        gpuImage.setImage(source);
        gpuImage.setFilter((GPUImageFilter)this.mFilter);
        Bitmap bitmap = gpuImage.getBitmapWithFilterApplied();
        source.recycle();
        return BitmapResource.obtain((Bitmap)bitmap, (BitmapPool)this.mBitmapPool);
    }

    public String getId() {
        return "SepiaFilterTransformation(intensity=" + this.mIntensity + ")";
    }
}

