/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.ScriptIntrinsicBlur;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;

public class BlurTransformation
implements Transformation<Bitmap> {
    private static int MAX_RADIUS = 25;
    private Context mContext;
    private BitmapPool mBitmapPool;
    private int mRadius;

    public BlurTransformation(Context context, BitmapPool pool) {
        this(context, pool, MAX_RADIUS);
    }

    public BlurTransformation(Context context, BitmapPool pool, int radius) {
        this.mContext = context;
        this.mBitmapPool = pool;
        this.mRadius = radius;
    }

    public Resource<Bitmap> transform(Resource<Bitmap> resource, int outWidth, int outHeight) {
        Bitmap.Config config;
        int height;
        Bitmap source = (Bitmap)resource.get();
        int width = source.getWidth();
        Bitmap bitmap = this.mBitmapPool.get(width, height = source.getHeight(), config = source.getConfig() != null ? source.getConfig() : Bitmap.Config.ARGB_8888);
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        }
        Canvas canvas = new Canvas(bitmap);
        canvas.drawBitmap(source, 0.0f, 0.0f, null);
        RenderScript rs = RenderScript.create((Context)this.mContext);
        Allocation overlayAlloc = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)bitmap);
        ScriptIntrinsicBlur blur = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)overlayAlloc.getElement());
        blur.setInput(overlayAlloc);
        blur.setRadius((float)this.mRadius);
        blur.forEach(overlayAlloc);
        overlayAlloc.copyTo(bitmap);
        rs.destroy();
        return BitmapResource.obtain((Bitmap)bitmap, (BitmapPool)this.mBitmapPool);
    }

    public String getId() {
        return "BlurTransformation(radius=" + this.mRadius + ")";
    }
}

