/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations.gpu;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import jp.co.cyberagent.android.gpuimage.GPUImage;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.GPUImageSwirlFilter;

public class SwirlFilterTransformation
implements Transformation<Bitmap> {
    private Context mContext;
    private BitmapPool mBitmapPool;
    private GPUImageSwirlFilter mFilter = new GPUImageSwirlFilter();
    private float mRadius;
    private float mAngle;
    private PointF mCenter;

    public SwirlFilterTransformation(Context context, BitmapPool pool) {
        this.mContext = context;
        this.mBitmapPool = pool;
        this.mCenter = new PointF();
    }

    public SwirlFilterTransformation(Context context, BitmapPool pool, float radius, float angle, PointF center) {
        this.mContext = context;
        this.mBitmapPool = pool;
        this.mRadius = radius;
        this.mAngle = angle;
        this.mCenter = center;
        this.mFilter.setRadius(this.mRadius);
        this.mFilter.setAngle(this.mAngle);
        this.mFilter.setCenter(this.mCenter);
    }

    public Resource<Bitmap> transform(Resource<Bitmap> resource, int outWidth, int outHeight) {
        Bitmap source = (Bitmap)resource.get();
        GPUImage gpuImage = new GPUImage(this.mContext);
        gpuImage.setImage(source);
        gpuImage.setFilter((GPUImageFilter)this.mFilter);
        Bitmap bitmap = gpuImage.getBitmapWithFilterApplied();
        source.recycle();
        return BitmapResource.obtain((Bitmap)bitmap, (BitmapPool)this.mBitmapPool);
    }

    public String getId() {
        return "SwirlFilterTransformation(radius=" + this.mRadius + ",angle=" + this.mAngle + ",center=" + this.mCenter.toString() + ")";
    }
}

