/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.picasso.transformations.gpu;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import com.squareup.picasso.Transformation;
import java.util.Arrays;
import jp.co.cyberagent.android.gpuimage.GPUImage;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.GPUImageVignetteFilter;

public class VignetteFilterTransformation
implements Transformation {
    private Context mContext;
    private GPUImageVignetteFilter mFilter = new GPUImageVignetteFilter();
    private PointF mCenter;
    private float[] mVignetteColor;
    private float mVignetteStart;
    private float mVignetteEnd;

    public VignetteFilterTransformation(Context context) {
        this.mContext = context;
        this.mCenter = new PointF();
    }

    public VignetteFilterTransformation(Context context, PointF center, float[] color, float start, float end) {
        this.mContext = context;
        this.mCenter = center;
        this.mVignetteColor = color;
        this.mVignetteStart = start;
        this.mVignetteEnd = end;
        this.mFilter.setVignetteCenter(this.mCenter);
        this.mFilter.setVignetteColor(this.mVignetteColor);
        this.mFilter.setVignetteStart(this.mVignetteStart);
        this.mFilter.setVignetteEnd(this.mVignetteEnd);
    }

    public Bitmap transform(Bitmap source) {
        GPUImage gpuImage = new GPUImage(this.mContext);
        gpuImage.setImage(source);
        gpuImage.setFilter((GPUImageFilter)this.mFilter);
        Bitmap bitmap = gpuImage.getBitmapWithFilterApplied();
        source.recycle();
        return bitmap;
    }

    public String key() {
        return "VignetteFilterTransformation(center=" + this.mCenter.toString() + ",color=" + Arrays.toString(this.mVignetteColor) + ",start=" + this.mVignetteStart + ",end=" + this.mVignetteEnd + ")";
    }
}

