/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.picasso.transformations.gpu;

import android.content.Context;
import android.graphics.Bitmap;
import com.squareup.picasso.Transformation;
import jp.co.cyberagent.android.gpuimage.GPUImage;
import jp.co.cyberagent.android.gpuimage.GPUImageContrastFilter;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;

public class ContrastFilterTransformation
implements Transformation {
    private Context mContext;
    private GPUImageContrastFilter mFilter = new GPUImageContrastFilter();
    private float mContrast;

    public ContrastFilterTransformation(Context context) {
        this.mContext = context;
    }

    public ContrastFilterTransformation(Context context, float contrast) {
        this.mContext = context;
        this.mContrast = contrast;
        this.mFilter.setContrast(this.mContrast);
    }

    public Bitmap transform(Bitmap source) {
        GPUImage gpuImage = new GPUImage(this.mContext);
        gpuImage.setImage(source);
        gpuImage.setFilter((GPUImageFilter)this.mFilter);
        Bitmap bitmap = gpuImage.getBitmapWithFilterApplied();
        source.recycle();
        return bitmap;
    }

    public String key() {
        return "ContrastFilterTransformation(contrast=" + this.mContrast + ")";
    }
}

