/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.picasso.transformations.gpu;

import android.content.Context;
import android.graphics.Bitmap;
import com.squareup.picasso.Transformation;
import jp.co.cyberagent.android.gpuimage.GPUImage;
import jp.co.cyberagent.android.gpuimage.GPUImageBrightnessFilter;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;

public class BrightnessFilterTransformation
implements Transformation {
    private Context mContext;
    private GPUImageBrightnessFilter mFilter = new GPUImageBrightnessFilter();
    private float mBrightness;

    public BrightnessFilterTransformation(Context context) {
        this.mContext = context;
    }

    public BrightnessFilterTransformation(Context context, float brightness) {
        this.mContext = context;
        this.mBrightness = brightness;
        this.mFilter.setBrightness(this.mBrightness);
    }

    public Bitmap transform(Bitmap source) {
        GPUImage gpuImage = new GPUImage(this.mContext);
        gpuImage.setImage(source);
        gpuImage.setFilter((GPUImageFilter)this.mFilter);
        Bitmap bitmap = gpuImage.getBitmapWithFilterApplied();
        source.recycle();
        return bitmap;
    }

    public String key() {
        return "BrightnessFilterTransformation(brightness=" + this.mBrightness + ")";
    }
}

