/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.picasso.transformations;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import com.squareup.picasso.Transformation;

public class CropTransformation
implements Transformation {
    private int mWidth;
    private int mHeight;

    public CropTransformation() {
    }

    public CropTransformation(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    public Bitmap transform(Bitmap source) {
        if (this.mWidth == 0) {
            this.mWidth = source.getWidth();
        }
        if (this.mHeight == 0) {
            this.mHeight = source.getHeight();
        }
        float scaleX = (float)this.mWidth / (float)source.getWidth();
        float scaleY = (float)this.mHeight / (float)source.getHeight();
        float scale = Math.max(scaleX, scaleY);
        float scaledWidth = scale * (float)source.getWidth();
        float scaledHeight = scale * (float)source.getHeight();
        float left = ((float)this.mWidth - scaledWidth) / 2.0f;
        float top = ((float)this.mHeight - scaledHeight) / 2.0f;
        RectF targetRect = new RectF(left, top, left + scaledWidth, top + scaledHeight);
        Bitmap bitmap = Bitmap.createBitmap((int)this.mWidth, (int)this.mHeight, (Bitmap.Config)source.getConfig());
        Canvas canvas = new Canvas(bitmap);
        canvas.drawBitmap(source, null, targetRect, null);
        source.recycle();
        return bitmap;
    }

    public String key() {
        return "CropTransformation(width=" + this.mWidth + ", height=" + this.mHeight + ")";
    }
}

