/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.picasso.transformations;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Shader;
import com.squareup.picasso.Transformation;

public class CropCircleTransformation
implements Transformation {
    public Bitmap transform(Bitmap source) {
        int height;
        int size = Math.min(source.getWidth(), source.getHeight());
        int width = (source.getWidth() - size) / 2;
        Bitmap squaredBitmap = Bitmap.createBitmap((Bitmap)source, (int)width, (int)(height = (source.getHeight() - size) / 2), (int)size, (int)size);
        if (squaredBitmap != source) {
            source.recycle();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        BitmapShader shader = new BitmapShader(squaredBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        paint.setShader((Shader)shader);
        paint.setAntiAlias(true);
        float r = (float)size / 2.0f;
        canvas.drawCircle(r, r, r, paint);
        squaredBitmap.recycle();
        return bitmap;
    }

    public String key() {
        return "CropCircleTransformation()";
    }
}

