/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.picasso.transformations;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.ScriptIntrinsicBlur;
import com.squareup.picasso.Transformation;

public class BlurTransformation
implements Transformation {
    private static int MAX_RADIUS = 25;
    private Context mContext;
    private int mRadius;

    public BlurTransformation(Context context) {
        this(context, MAX_RADIUS);
    }

    public BlurTransformation(Context context, int radius) {
        this.mContext = context;
        this.mRadius = radius;
    }

    public Bitmap transform(Bitmap source) {
        Bitmap outBitmap = Bitmap.createBitmap((int)source.getWidth(), (int)source.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(outBitmap);
        canvas.drawBitmap(source, 0.0f, 0.0f, null);
        RenderScript rs = RenderScript.create((Context)this.mContext);
        Allocation overlayAlloc = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)outBitmap);
        ScriptIntrinsicBlur blur = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)overlayAlloc.getElement());
        blur.setInput(overlayAlloc);
        blur.setRadius((float)this.mRadius);
        blur.forEach(overlayAlloc);
        overlayAlloc.copyTo(outBitmap);
        source.recycle();
        rs.destroy();
        return outBitmap;
    }

    public String key() {
        return "BlurTransformation(radius=" + this.mRadius + ")";
    }
}

