/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.picasso.transformations.gpu;

import android.content.Context;
import android.graphics.Bitmap;
import com.squareup.picasso.Transformation;
import jp.co.cyberagent.android.gpuimage.GPUImage;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.GPUImagePixelationFilter;

public class PixelationFilterTransformation
implements Transformation {
    private Context mContext;
    private GPUImagePixelationFilter mFilter = new GPUImagePixelationFilter();
    private float mPixel;

    public PixelationFilterTransformation(Context context) {
        this.mContext = context;
    }

    public PixelationFilterTransformation(Context context, float pixel) {
        this.mContext = context;
        this.mPixel = pixel;
        this.mFilter.setPixel(this.mPixel);
    }

    public Bitmap transform(Bitmap source) {
        GPUImage gpuImage = new GPUImage(this.mContext);
        gpuImage.setImage(source);
        gpuImage.setFilter((GPUImageFilter)this.mFilter);
        Bitmap bitmap = gpuImage.getBitmapWithFilterApplied();
        source.recycle();
        return bitmap;
    }

    public String key() {
        return "PixelationFilterTransformation(pixel=" + this.mPixel + ")";
    }
}

