/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations.gpu;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import java.util.Arrays;
import jp.co.cyberagent.android.gpuimage.GPUImage;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.GPUImageVignetteFilter;

public class VignetteFilterTransformation
implements Transformation<Bitmap> {
    private Context mContext;
    private BitmapPool mBitmapPool;
    private GPUImageVignetteFilter mFilter = new GPUImageVignetteFilter();
    private PointF mCenter;
    private float[] mVignetteColor;
    private float mVignetteStart;
    private float mVignetteEnd;

    public VignetteFilterTransformation(Context context, BitmapPool pool) {
        this.mContext = context;
        this.mBitmapPool = pool;
        this.mCenter = new PointF();
    }

    public VignetteFilterTransformation(Context context, BitmapPool pool, PointF center, float[] color, float start, float end) {
        this.mContext = context;
        this.mBitmapPool = pool;
        this.mCenter = center;
        this.mVignetteColor = color;
        this.mVignetteStart = start;
        this.mVignetteEnd = end;
        this.mFilter.setVignetteCenter(this.mCenter);
        this.mFilter.setVignetteColor(this.mVignetteColor);
        this.mFilter.setVignetteStart(this.mVignetteStart);
        this.mFilter.setVignetteEnd(this.mVignetteEnd);
    }

    public Resource<Bitmap> transform(Resource<Bitmap> resource, int outWidth, int outHeight) {
        Bitmap source = (Bitmap)resource.get();
        GPUImage gpuImage = new GPUImage(this.mContext);
        gpuImage.setImage(source);
        gpuImage.setFilter((GPUImageFilter)this.mFilter);
        Bitmap bitmap = gpuImage.getBitmapWithFilterApplied();
        source.recycle();
        return BitmapResource.obtain((Bitmap)bitmap, (BitmapPool)this.mBitmapPool);
    }

    public String getId() {
        return "VignetteFilterTransformation(center=" + this.mCenter.toString() + ",color=" + Arrays.toString(this.mVignetteColor) + ",start=" + this.mVignetteStart + ",end=" + this.mVignetteEnd + ")";
    }
}

