/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations.gpu;

import android.content.Context;
import android.graphics.Bitmap;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import jp.co.cyberagent.android.gpuimage.GPUImage;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.GPUImagePixelationFilter;

public class PixelationFilterTransformation
implements Transformation<Bitmap> {
    private Context mContext;
    private BitmapPool mBitmapPool;
    private GPUImagePixelationFilter mFilter = new GPUImagePixelationFilter();
    private float mPixel;

    public PixelationFilterTransformation(Context context, BitmapPool pool) {
        this.mContext = context;
        this.mBitmapPool = pool;
    }

    public PixelationFilterTransformation(Context context, BitmapPool pool, float pixel) {
        this.mContext = context;
        this.mBitmapPool = pool;
        this.mPixel = pixel;
        this.mFilter.setPixel(this.mPixel);
    }

    public Resource<Bitmap> transform(Resource<Bitmap> resource, int outWidth, int outHeight) {
        Bitmap source = (Bitmap)resource.get();
        GPUImage gpuImage = new GPUImage(this.mContext);
        gpuImage.setImage(source);
        gpuImage.setFilter((GPUImageFilter)this.mFilter);
        Bitmap bitmap = gpuImage.getBitmapWithFilterApplied();
        source.recycle();
        return BitmapResource.obtain((Bitmap)bitmap, (BitmapPool)this.mBitmapPool);
    }

    public String getId() {
        return "PixelationFilterTransformation(pixel=" + this.mPixel + ")";
    }
}

