/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.blurry.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jp.wasabeef.blurry.internal.Blur;
import jp.wasabeef.blurry.internal.BlurFactor;

public class BlurTask {
    private Resources res;
    private WeakReference<Context> contextWeakRef;
    private BlurFactor factor;
    private Bitmap bitmap;
    private Callback callback;
    private static ExecutorService THREAD_POOL = Executors.newCachedThreadPool();

    public BlurTask(View target, BlurFactor factor, Callback callback) {
        this.res = target.getResources();
        this.factor = factor;
        this.callback = callback;
        this.contextWeakRef = new WeakReference<Context>(target.getContext());
        target.setDrawingCacheEnabled(true);
        target.destroyDrawingCache();
        target.setDrawingCacheQuality(524288);
        this.bitmap = target.getDrawingCache();
    }

    public BlurTask(Context context, Bitmap bitmap, BlurFactor factor, Callback callback) {
        this.res = context.getResources();
        this.factor = factor;
        this.callback = callback;
        this.contextWeakRef = new WeakReference<Context>(context);
        this.bitmap = bitmap;
    }

    public void execute() {
        THREAD_POOL.execute(new Runnable(){

            @Override
            public void run() {
                Context context = (Context)BlurTask.this.contextWeakRef.get();
                final BitmapDrawable bitmapDrawable = new BitmapDrawable(BlurTask.this.res, Blur.of(context, BlurTask.this.bitmap, BlurTask.this.factor));
                if (BlurTask.this.callback != null) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            BlurTask.this.callback.done(bitmapDrawable);
                        }
                    });
                }
            }
        });
    }

    public static interface Callback {
        public void done(BitmapDrawable var1);
    }
}

