/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.blurry;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import jp.wasabeef.blurry.internal.Blur;
import jp.wasabeef.blurry.internal.BlurFactor;
import jp.wasabeef.blurry.internal.BlurTask;
import jp.wasabeef.blurry.internal.Helper;

public class Blurry {
    private static final String TAG = Blurry.class.getSimpleName();

    public static Composer with(Context context) {
        return new Composer(context);
    }

    public static void delete(ViewGroup target) {
        View view = target.findViewWithTag((Object)TAG);
        if (view != null) {
            target.removeView(view);
        }
    }

    public static class ImageComposer {
        private Context context;
        private View capture;
        private BlurFactor factor;
        private boolean async;
        private ImageComposerListener listener;

        public ImageComposer(Context context, View capture, BlurFactor factor, boolean async, ImageComposerListener listener) {
            this.context = context;
            this.capture = capture;
            this.factor = factor;
            this.async = async;
            this.listener = listener;
        }

        public void into(final ImageView target) {
            this.factor.width = this.capture.getMeasuredWidth();
            this.factor.height = this.capture.getMeasuredHeight();
            if (this.async) {
                BlurTask task = new BlurTask(this.capture, this.factor, new BlurTask.Callback(){

                    @Override
                    public void done(BitmapDrawable drawable) {
                        if (ImageComposer.this.listener == null) {
                            target.setImageDrawable((Drawable)drawable);
                        } else {
                            ImageComposer.this.listener.onImageReady(drawable);
                        }
                    }
                });
                task.execute();
            } else {
                BitmapDrawable drawable = new BitmapDrawable(this.context.getResources(), Blur.of(this.capture, this.factor));
                target.setImageDrawable((Drawable)drawable);
            }
        }

        public static interface ImageComposerListener {
            public void onImageReady(BitmapDrawable var1);
        }
    }

    public static class Composer {
        private View blurredView;
        private Context context;
        private BlurFactor factor;
        private boolean async;
        private boolean animate;
        private int duration = 300;
        private ImageComposer.ImageComposerListener listener;

        public Composer(Context context) {
            this.context = context;
            this.blurredView = new View(context);
            this.blurredView.setTag((Object)TAG);
            this.factor = new BlurFactor();
        }

        public Composer radius(int radius) {
            this.factor.radius = radius;
            return this;
        }

        public Composer sampling(int sampling) {
            this.factor.sampling = sampling;
            return this;
        }

        public Composer color(int color) {
            this.factor.color = color;
            return this;
        }

        public Composer async() {
            this.async = true;
            return this;
        }

        public Composer async(ImageComposer.ImageComposerListener listener) {
            this.async = true;
            this.listener = listener;
            return this;
        }

        public Composer animate() {
            this.animate = true;
            return this;
        }

        public Composer animate(int duration) {
            this.animate = true;
            this.duration = duration;
            return this;
        }

        public ImageComposer capture(View capture) {
            return new ImageComposer(this.context, capture, this.factor, this.async, this.listener);
        }

        public void onto(final ViewGroup target) {
            this.factor.width = target.getMeasuredWidth();
            this.factor.height = target.getMeasuredHeight();
            if (this.async) {
                BlurTask task = new BlurTask((View)target, this.factor, new BlurTask.Callback(){

                    @Override
                    public void done(BitmapDrawable drawable) {
                        Composer.this.addView(target, (Drawable)drawable);
                    }
                });
                task.execute();
            } else {
                BitmapDrawable drawable = new BitmapDrawable(this.context.getResources(), Blur.of((View)target, this.factor));
                this.addView(target, (Drawable)drawable);
            }
        }

        private void addView(ViewGroup target, Drawable drawable) {
            Helper.setBackground(this.blurredView, drawable);
            target.addView(this.blurredView);
            if (this.animate) {
                Helper.animate(this.blurredView, this.duration);
            }
        }
    }
}

